<?php

namespace MoySklad\Modules\AdminSyncMySklad;

use ActiveTable\ColumnTable;
use Core\Form\ControlBuilder;
use Core\ModuleController;
use Core\Template\Template;

use Diamond\Helpers\Form;
use DiamondTable\TableFactory;

use GuzzleHttp\Exception\ConnectException;
use Local\Config\Main;
use Monolog\Handler\StreamHandler;
use MoySklad\Application\Modules\AdminSyncMySklad\SyncMySkladTrait;
use MoySklad\Application\Modules\AdminSyncMySklad\UpdatePriceListsAction;
use MoySklad\Application\MoySkladFactory;
use MoySklad\Application\MoySkladTaskService;

use MoySklad\Infrastructure\MoySkladTask\MoySkladCriteria;
use MoySklad\Infrastructure\MoySkladTask\MoySkladTaskRepository;
use MoySklad\Models\MoySkladTask\MoySkladTask;
use Shop\Repositories\Brand;
use Shop\Helpers\Form as FormHelper;
use Shop\Repositories\PriceList\PriceListCriteria;
use Shop\Repositories\PriceList\PriceListRepository;
use Shop\Repositories\ProductCategory\ProductCategoryCriteria;
use Shop\Repositories\ProductCategory\ProductCategoryRepository;
use spaceonfire\CommandBus\CommandBus;

/**
 * Description of AdminSyncMySklad
 *
 * @author Diamond Code Generator
 */
class AdminSyncMySklad extends ModuleController
{

    use SyncMySkladTrait;

    protected $repo;
    protected $priceListRepo;
    protected $repoCategory;
    protected $repoBrand;
    protected $cBuilder;

    protected $mainConfig;
    protected $template;
    protected $moySkladTaskService;

    protected $tableFactory;

    protected $commandBus;

    public function __construct(
        MoySkladTaskRepository $repo,
        ProductCategoryRepository $repoCategory,
        Brand\BrandRepository $brandRepo,
        ControlBuilder $controlBuilder,
        Main $mainConfig,
        PriceListRepository $priceListRepo,
        Template $template,
        MoySkladTaskService $moySkladTaskService,
        TableFactory $tableFactory,
        CommandBus $commandBus)
    {

        $this->repo = $repo;
        $this->repoCategory = $repoCategory;
        $this->repoBrand = $brandRepo;
        $this->cBuilder = $controlBuilder;
        $this->mainConfig = $mainConfig;
        $this->tableFactory = $tableFactory;
        $this->priceListRepo = $priceListRepo;
        $this->template = $template;
        $this->moySkladTaskService = $moySkladTaskService;

        $this->tableFactory = $tableFactory;
        $this->commandBus = $commandBus;
    }


    protected function testDebug()
    {
        @set_time_limit(0);
        @ini_set('max_execution_time', 0);
        @ini_set('max_input_time', '3600');
        ignore_user_abort(true);
        $logger = (new \Monolog\Logger('syncLogger'));


        $format = "[%datetime%] [%level_name%] %message% [Context %context% Extra %extra%]\n";


        /**
         * @var MoySkladTask $task
         */
        $task = $this->repo->findById(2);
        $stream = new StreamHandler(
            $this->moySkladTaskService->createLoggerPath($task->getId(), $this->mainConfig->getMoyskladLogin(), '123')
        );
        $stream->setFormatter(new \Monolog\Formatter\LineFormatter($format, 'd/m/Y H:i:s'));

        $logger->pushHandler($stream);

        $moySkladService = MoySkladFactory::buildService($this->mainConfig->getMoyskladLogin(),
            $this->mainConfig->getMoyskladPassword(), $logger);

        $salePrice = $task->getSalePrice();

        $storeCode = preg_replace('~.*\[(.*?)\]~', '$1', $task->getStockId());


        $remainsCollection = $moySkladService->getStockRemainsByStockId(
            $storeCode,
            null,// 'ИП Корепанов Алексей Николаевич',
            $salePrice, 0, 10);

        dd($remainsCollection);

        $data = $moySkladService->convertRemainCollectionToArray($remainsCollection, 0);

        $moySkladService->prepareArrayRemainsDataGroupPrices($data);

        dd($remainsCollection);
    }

    /**
     * @return string
     * @throws \Propel\Runtime\Exception\PropelException
     * @throws \ReflectionException
     * @throws \Repo\Concrete\Exceptions\Collection
     * @throws \Twig\Error\LoaderError
     * @throws \Twig\Error\RuntimeError
     * @throws \Twig\Error\SyntaxError
     */
    public function process(): string
    {

        //для дебага
        //$this->testDebug();


        $this->template->addScript($this->render('javascript_new'));
        $this->template->addScriptLinks($this->setJsLinks());
        $this->template->addStyleLinks($this->setCssLinks());

        if (input_get('process') > 0) {

            /**
             * @var  MoySkladTask $task
             */
            $task = $this->repo->findById(input_get('process'));

            if (input_get('force')) {

                try {

                    $this->moySkladTaskService->loadMoySkladTask($task);

                } catch (ConnectException $ex) {
                }
            }

            if ($task->getPricelistSheet()) {
                $notice = Form::buildAnnouncementMessage('Все найденные остатки будут привязаны к выбранному прайсу');
                $priceTitle = $task->getPricelistSheet()->getTitle();
                $priceId = $task->getPricelistSheetId();
            } else {
                $notice = Form::buildAnnouncementMessage('Привязка к прайс-листам будет происходить по контрагентам приемок');
                $priceTitle = 'который будет найден по контрагенту приемки';
                $priceId = null;
            }

            return $this->render('process_form', [
                'store' => $task->getStockUuid(),
                'brandDef' => $task->getBrandId(),
                'categoryDef' => $task->getCategoryId(),
                'login' => $this->mainConfig->getMoyskladLogin(),
                'pass' => $this->mainConfig->getMoyskladPassword(),
                'storeDisplay' => $task->getStockId(),
                'priceDisplay' => $priceTitle,
                'pricelist' => $priceId,
                'notice' => $notice,
                'task' => $task->getId(),
                'mark' => $task->getMark(),
                'salePrice' => $task->getSalePrice(),
                'first' => input_get('first')
            ]);


        } elseif (input_get('report') > 0) {

            $task = $this->repo->findById(input_get('report'));

            $logPath = $this->moySkladTaskService->createLoggerPath(
                $task->getId(),
                $this->mainConfig->getMoyskladLogin(),
                $task->getMark());

            if(file_exists($logPath)){
                $content = file_get_contents($logPath);
            }
            else{
                $content = '';
            }

            // dump($content);
            return $this->render('report', [
                'content' => $content
            ]);
        }

        $login = $this->mainConfig->getMoyskladLogin();
        $pass = $this->mainConfig->getMoyskladPassword();

        $registry = $this->tableFactory->buildAdminTable($this->repo, MoySkladCriteria::create());

        $registry->addRowActionCommand(
            'update-price-lists-selected',
            new UpdatePriceListsAction($registry, $this->commandBus),
            'Обновить прайс-листы'
        );

        $registry
            ->addColumn(
                (new ColumnTable('id', '№'))
                    ->setWidth(40)
            )
            ->addColumn(
                (new ColumnTable('login', 'Логин'))
            )
            ->addColumn(
                (new ColumnTable('salePrice', 'Цена продажи'))
                    ->setFormat($this, 'columnPriceSale')
            )
            ->addColumn(
                (new ColumnTable('pricelistSheetId', 'Прайс-лист/Дата обновления/Позиций'))
                    ->setFormat($this, 'columnPrice')
            )
            ->addColumn(
                (new ColumnTable('stockId', 'Удаленный склад'))
                    ->setFormat($this, 'columnStock')
            )
            ->addColumn(
                (new ColumnTable('datetimeStart', 'Дата старта'))
                    ->setFormat($this, 'columnDateStart')
            )
            ->addColumn(
                (new ColumnTable('datetimeEnd', 'Дата завершения'))
                    ->setFormat($this, 'columnDateEnd')
            )
            ->addColumn(
                (new ColumnTable('time', 'Продол-сть'))->setFormat($this, 'columnTime')
            )
            ->addColumn(
                (new ColumnTable('complete', 'Статус'))
                    ->setFormat($this, 'columnComplete')
            )

            ->addColumn(
                (new ColumnTable('action', 'Прогресс'))
                    ->setFormat($this, 'columnProgress')
            )
            ->addColumn(
                (new ColumnTable('interval', 'Активность/Интервал'))
                    ->setFormat($this, 'columnInterval')
            )
            ->addColumn(
                (new ColumnTable('actions', ''))
                    ->setWidth(120)
                    ->setFormat($this, 'formatActions')
            );


        $categoriesCollection = $this->repoCategory->findByCriteria(
            ProductCategoryCriteria::create()
        );

        $categories = FormHelper::prepareDropdownWithDef($categoriesCollection, '-1', 'раздел', 'getDropdownListWithParent');

        $brandsCollection = $this->repoBrand->findByCriteria(
            Brand\BrandCriteria::create()
        );

        $brands = FormHelper::prepareDropdownWithDef($brandsCollection, '-1', 'производителя');

        $pricelistsCollection = $this->priceListRepo->findByCriteria(
            PriceListCriteria::create()
        );


        $priceLists = [
            'NULL' => 'авто-поиск прайс-листа по контрагенту остатков'
        ];

        $priceLists += $pricelistsCollection->getDropdownListWithFileName();


        //FormHelper::prepareDropdown($pricelistsCollection, 'Прайс-лист', 'getDropdownListWithFileName');

        $interval = [
            '1h' => '1 час',
            '2h' => '2 часа',
            '4h' => '4 часа',
            '12h' => '12 часов',
            '24h' => '24 часа',
            '1d' => '1 день',
            '7d' => '7 дней',
        ];

        $timeStart = [
            '00:00','01:00','02:00','03:00','04:00','05:00','06:00','07:00','08:00','09:00','10:00','11:00','12:00','13:00','14:00','15:00','16:00','17:00','18:00','19:00','20:00','21:00','22:00','23:00'
        ];

        $registry
            ->addField(
                $this->cBuilder->buildFormHeader('Автозапуск', 'header1')
            )
            ->addField(
                $this->cBuilder->buildCheckbox('active', 1, 0), true, 'Автозапуск'
            )
            ->addField(
                $this->cBuilder->buildDropdownUniform('interval', $interval), false, 'Интервал', 'периодичность повторений'
            )
            ->addField(
                $this->cBuilder->buildDropdownUniform('time_start', array_combine($timeStart,$timeStart)), false, 'Время старта'
            )
            ->addField(
                $this->cBuilder->buildFormHeader('Основные', 'header2')
            )
            ->addField(
                $this->cBuilder->buildAutoDropdown('pricelistSheetId', $priceLists), false, 'Прайс-лист', 'Куда будут загружены остатки'
            )
            ->addField(
                $this->cBuilder->buildInputSmall('salePrice'), true, null, 'цена продажи из сервиса'
            )
            ->addField(
                $this->cBuilder->buildAutoDropdown('categoryId', $categories), true, 'Раздел каталога', 'по умолчанию'
            )
            ->addField(
                $this->cBuilder->buildAutoDropdown('brandId', $brands), true, 'Производитель', 'по умолчанию'
            )
            ->addField(
                $this->cBuilder->buildHidden('login')->setValue($login)
            )
            ->addField(
                $this->cBuilder->buildHidden('password')->setValue($pass)
            )
            ->addField(
                $this->cBuilder->buildHidden('stockId'), true
            )
            ->addField(
                $this->cBuilder->buildRow('ff',
                    '<span id="preview2"></span>' . $this->cBuilder->buildButton('load_stock', 'Подключиться и получить склады')->render()
                )
            );

        $registry
            ->addFilter(
                $this->cBuilder->buildInput('search_by_stockId')
            )
            ->addFilter(
                $this->cBuilder->buildInput('search_by_salePrice')
            );


        return $registry->render();
    }


    /**
     * @return array
     */
    private function setCssLinks(): array
    {
        return [
            '/_diamond/widgets/assets/jquery/jgrid/skin/ui.jqgrid.css',
            '/_diamond/diamond-cms/assets/css/plugins/jqgrid.style.css'
        ];
    }

    /**
     * @return array
     */
    private function setJsLinks(): array
    {
        return [
            '/_diamond/widgets/assets/jquery/lib/jquery-1.7.min.js',
            '/_diamond/widgets/assets/jquery/jgrid/grid-locale-ru.js',
            '/_diamond/widgets/assets/jquery/jgrid/jquery-jqGrid-min.js',
            '/_diamond/widgets/assets/jquery/jgrid/aplication.js',
            '/_diamond/widgets/assets/jquery/jgrid/jqgrid.ext.js'
        ];
    }


}