<?php


namespace MoySklad\Application\Commands\UpdatePriceListFromRemains;


class UpdatePriceListsByTaskCommand
{

    /**
     * @var int
     */
    protected $taskId;

    /**
     * @var array
     */
    protected $filterIds;

    /**
     * @var
     */
    protected $effectedRows = 0;

    /**
     * UpdatePriceListsByTaskCommand constructor.
     * @param int $taskId
     * @param array $filterIds
     */
    public function __construct(int $taskId, ?array $filterIds = null)
    {
        $this->taskId = $taskId;
        $this->filterIds = $filterIds;
    }

    /**
     * @return int
     */
    public function getTaskId(): int
    {
        return $this->taskId;
    }

    /**
     * @return array
     */
    public function getFilterIds(): ?array
    {
        return $this->filterIds;
    }

    /**
     * @return mixed
     */
    public function getEffectedRows(): int
    {
        return $this->effectedRows;
    }

    /**
     * @param mixed $effectedRows
     * @return UpdatePriceListsByTaskCommand
     */
    public function setEffectedRows(int $effectedRows)
    {
        $this->effectedRows = $effectedRows;
        return $this;
    }

}