<?php

namespace MoySklad\Models\MoySkladTask\Base;

use \DateTime;
use \Exception;
use \PDO;
use MoySklad\Models\MoySkladTask\MoySkladTaskQuery as ChildMoySkladTaskQuery;
use MoySklad\Models\MoySkladTask\Map\MoySkladTaskTableMap;
use Propel\Runtime\Propel;
use Propel\Runtime\ActiveQuery\Criteria;
use Propel\Runtime\ActiveQuery\ModelCriteria;
use Propel\Runtime\ActiveRecord\ActiveRecordInterface;
use Propel\Runtime\Collection\Collection;
use Propel\Runtime\Connection\ConnectionInterface;
use Propel\Runtime\Exception\BadMethodCallException;
use Propel\Runtime\Exception\LogicException;
use Propel\Runtime\Exception\PropelException;
use Propel\Runtime\Map\TableMap;
use Propel\Runtime\Parser\AbstractParser;
use Propel\Runtime\Util\PropelDateTime;
use Shop\Models\Brand\Brand;
use Shop\Models\Brand\BrandQuery;
use Shop\Models\Category\Category;
use Shop\Models\Category\CategoryQuery;
use Shop\Models\PricelistSheet\PricelistSheet;
use Shop\Models\PricelistSheet\PricelistSheetQuery;

/**
 * Base class that represents a row from the 'moysklad_tasks' table.
 *
 *
 *
 * @package    propel.generator.Models.MoySkladTask.Base
 */
abstract class MoySkladTask implements ActiveRecordInterface
{
    /**
     * TableMap class name
     */
    const TABLE_MAP = '\\MoySklad\\Models\\MoySkladTask\\Map\\MoySkladTaskTableMap';


    /**
     * attribute to determine if this object has previously been saved.
     * @var boolean
     */
    protected $new = true;

    /**
     * attribute to determine whether this object has been deleted.
     * @var boolean
     */
    protected $deleted = false;

    /**
     * The columns that have been modified in current object.
     * Tracking modified columns allows us to only update modified columns.
     * @var array
     */
    protected $modifiedColumns = array();

    /**
     * The (virtual) columns that are added at runtime
     * The formatters can add supplementary columns based on a resultset
     * @var array
     */
    protected $virtualColumns = array();

    /**
     * The value for the id field.
     *
     * @var        int
     */
    protected $id;

    /**
     * The value for the sale_price field.
     *
     * @var        string
     */
    protected $sale_price;

    /**
     * The value for the brand_id field.
     *
     * @var        int
     */
    protected $brand_id;

    /**
     * The value for the category_id field.
     *
     * @var        int
     */
    protected $category_id;

    /**
     * The value for the login field.
     *
     * @var        string
     */
    protected $login;

    /**
     * The value for the password field.
     *
     * @var        string
     */
    protected $password;

    /**
     * The value for the active field.
     *
     * Note: this column has a database default value of: 1
     * @var        int
     */
    protected $active;

    /**
     * The value for the complete field.
     *
     * Note: this column has a database default value of: 0
     * @var        int
     */
    protected $complete;

    /**
     * The value for the stock_id field.
     *
     * @var        string
     */
    protected $stock_id;

    /**
     * The value for the mark field.
     *
     * @var        int
     */
    protected $mark;

    /**
     * The value for the datetime_start field.
     *
     * @var        DateTime
     */
    protected $datetime_start;

    /**
     * The value for the datetime_end field.
     *
     * @var        DateTime
     */
    protected $datetime_end;

    /**
     * The value for the pricelist_sheet_id field.
     *
     * @var        int
     */
    protected $pricelist_sheet_id;

    /**
     * The value for the time_start field.
     *
     * Note: this column has a database default value of: '00:00'
     * @var        string
     */
    protected $time_start;

    /**
     * The value for the interval field.
     *
     * Note: this column has a database default value of: '1d'
     * @var        string
     */
    protected $interval;

    /**
     * @var        Brand
     */
    protected $aShopBrand;

    /**
     * @var        Category
     */
    protected $aCategory;

    /**
     * @var        PricelistSheet
     */
    protected $aPricelistSheet;

    /**
     * Flag to prevent endless save loop, if this object is referenced
     * by another object which falls in this transaction.
     *
     * @var boolean
     */
    protected $alreadyInSave = false;

    /**
     * Applies default values to this object.
     * This method should be called from the object's constructor (or
     * equivalent initialization method).
     * @see __construct()
     */
    public function applyDefaultValues()
    {
        $this->active = 1;
        $this->complete = 0;
        $this->time_start = '00:00';
        $this->interval = '1d';
    }

    /**
     * Initializes internal state of MoySklad\Models\MoySkladTask\Base\MoySkladTask object.
     * @see applyDefaults()
     */
    public function __construct()
    {
        $this->applyDefaultValues();
    }

    /**
     * Returns whether the object has been modified.
     *
     * @return boolean True if the object has been modified.
     */
    public function isModified()
    {
        return !!$this->modifiedColumns;
    }

    /**
     * Has specified column been modified?
     *
     * @param  string  $col column fully qualified name (TableMap::TYPE_COLNAME), e.g. Book::AUTHOR_ID
     * @return boolean True if $col has been modified.
     */
    public function isColumnModified($col)
    {
        return $this->modifiedColumns && isset($this->modifiedColumns[$col]);
    }

    /**
     * Get the columns that have been modified in this object.
     * @return array A unique list of the modified column names for this object.
     */
    public function getModifiedColumns()
    {
        return $this->modifiedColumns ? array_keys($this->modifiedColumns) : [];
    }

    /**
     * Returns whether the object has ever been saved.  This will
     * be false, if the object was retrieved from storage or was created
     * and then saved.
     *
     * @return boolean true, if the object has never been persisted.
     */
    public function isNew()
    {
        return $this->new;
    }

    /**
     * Setter for the isNew attribute.  This method will be called
     * by Propel-generated children and objects.
     *
     * @param boolean $b the state of the object.
     */
    public function setNew($b)
    {
        $this->new = (boolean) $b;
    }

    /**
     * Whether this object has been deleted.
     * @return boolean The deleted state of this object.
     */
    public function isDeleted()
    {
        return $this->deleted;
    }

    /**
     * Specify whether this object has been deleted.
     * @param  boolean $b The deleted state of this object.
     * @return void
     */
    public function setDeleted($b)
    {
        $this->deleted = (boolean) $b;
    }

    /**
     * Sets the modified state for the object to be false.
     * @param  string $col If supplied, only the specified column is reset.
     * @return void
     */
    public function resetModified($col = null)
    {
        if (null !== $col) {
            if (isset($this->modifiedColumns[$col])) {
                unset($this->modifiedColumns[$col]);
            }
        } else {
            $this->modifiedColumns = array();
        }
    }

    /**
     * Compares this with another <code>MoySkladTask</code> instance.  If
     * <code>obj</code> is an instance of <code>MoySkladTask</code>, delegates to
     * <code>equals(MoySkladTask)</code>.  Otherwise, returns <code>false</code>.
     *
     * @param  mixed   $obj The object to compare to.
     * @return boolean Whether equal to the object specified.
     */
    public function equals($obj)
    {
        if (!$obj instanceof static) {
            return false;
        }

        if ($this === $obj) {
            return true;
        }

        if (null === $this->getPrimaryKey() || null === $obj->getPrimaryKey()) {
            return false;
        }

        return $this->getPrimaryKey() === $obj->getPrimaryKey();
    }

    /**
     * Get the associative array of the virtual columns in this object
     *
     * @return array
     */
    public function getVirtualColumns()
    {
        return $this->virtualColumns;
    }

    /**
     * Checks the existence of a virtual column in this object
     *
     * @param  string  $name The virtual column name
     * @return boolean
     */
    public function hasVirtualColumn($name)
    {
        return array_key_exists($name, $this->virtualColumns);
    }

    /**
     * Get the value of a virtual column in this object
     *
     * @param  string $name The virtual column name
     * @return mixed
     *
     * @throws PropelException
     */
    public function getVirtualColumn($name)
    {
        if (!$this->hasVirtualColumn($name)) {
            throw new PropelException(sprintf('Cannot get value of inexistent virtual column %s.', $name));
        }

        return $this->virtualColumns[$name];
    }

    /**
     * Set the value of a virtual column in this object
     *
     * @param string $name  The virtual column name
     * @param mixed  $value The value to give to the virtual column
     *
     * @return $this|MoySkladTask The current object, for fluid interface
     */
    public function setVirtualColumn($name, $value)
    {
        $this->virtualColumns[$name] = $value;

        return $this;
    }

    /**
     * Logs a message using Propel::log().
     *
     * @param  string  $msg
     * @param  int     $priority One of the Propel::LOG_* logging levels
     * @return boolean
     */
    protected function log($msg, $priority = Propel::LOG_INFO)
    {
        return Propel::log(get_class($this) . ': ' . $msg, $priority);
    }

    /**
     * Export the current object properties to a string, using a given parser format
     * <code>
     * $book = BookQuery::create()->findPk(9012);
     * echo $book->exportTo('JSON');
     *  => {"Id":9012,"Title":"Don Juan","ISBN":"0140422161","Price":12.99,"PublisherId":1234,"AuthorId":5678}');
     * </code>
     *
     * @param  mixed   $parser                 A AbstractParser instance, or a format name ('XML', 'YAML', 'JSON', 'CSV')
     * @param  boolean $includeLazyLoadColumns (optional) Whether to include lazy load(ed) columns. Defaults to TRUE.
     * @return string  The exported data
     */
    public function exportTo($parser, $includeLazyLoadColumns = true)
    {
        if (!$parser instanceof AbstractParser) {
            $parser = AbstractParser::getParser($parser);
        }

        return $parser->fromArray($this->toArray(TableMap::TYPE_PHPNAME, $includeLazyLoadColumns, array(), true));
    }

    /**
     * Clean up internal collections prior to serializing
     * Avoids recursive loops that turn into segmentation faults when serializing
     */
    public function __sleep()
    {
        $this->clearAllReferences();

        $cls = new \ReflectionClass($this);
        $propertyNames = [];
        $serializableProperties = array_diff($cls->getProperties(), $cls->getProperties(\ReflectionProperty::IS_STATIC));

        foreach($serializableProperties as $property) {
            $propertyNames[] = $property->getName();
        }

        return $propertyNames;
    }

    /**
     * Get the [id] column value.
     *
     * @return int
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Get the [sale_price] column value.
     *
     * @return string
     */
    public function getSalePrice()
    {
        return $this->sale_price;
    }

    /**
     * Get the [brand_id] column value.
     *
     * @return int
     */
    public function getBrandId()
    {
        return $this->brand_id;
    }

    /**
     * Get the [category_id] column value.
     *
     * @return int
     */
    public function getCategoryId()
    {
        return $this->category_id;
    }

    /**
     * Get the [login] column value.
     *
     * @return string
     */
    public function getLogin()
    {
        return $this->login;
    }

    /**
     * Get the [password] column value.
     *
     * @return string
     */
    public function getPassword()
    {
        return $this->password;
    }

    /**
     * Get the [active] column value.
     *
     * @return int
     */
    public function getActive()
    {
        return $this->active;
    }

    /**
     * Get the [complete] column value.
     *
     * @return int
     */
    public function getComplete()
    {
        return $this->complete;
    }

    /**
     * Get the [stock_id] column value.
     *
     * @return string
     */
    public function getStockId()
    {
        return $this->stock_id;
    }

    /**
     * Get the [mark] column value.
     *
     * @return int
     */
    public function getMark()
    {
        return $this->mark;
    }

    /**
     * Get the [optionally formatted] temporal [datetime_start] column value.
     *
     *
     * @param      string|null $format The date/time format string (either date()-style or strftime()-style).
     *                            If format is NULL, then the raw DateTime object will be returned.
     *
     * @return string|DateTime Formatted date/time value as string or DateTime object (if format is NULL), NULL if column is NULL, and 0 if column value is 0000-00-00 00:00:00
     *
     * @throws PropelException - if unable to parse/validate the date/time value.
     */
    public function getDateTimeStart($format = NULL)
    {
        if ($format === null) {
            return $this->datetime_start;
        } else {
            return $this->datetime_start instanceof \DateTimeInterface ? $this->datetime_start->format($format) : null;
        }
    }

    /**
     * Get the [optionally formatted] temporal [datetime_end] column value.
     *
     *
     * @param      string|null $format The date/time format string (either date()-style or strftime()-style).
     *                            If format is NULL, then the raw DateTime object will be returned.
     *
     * @return string|DateTime Formatted date/time value as string or DateTime object (if format is NULL), NULL if column is NULL, and 0 if column value is 0000-00-00 00:00:00
     *
     * @throws PropelException - if unable to parse/validate the date/time value.
     */
    public function getDateTimeEnd($format = NULL)
    {
        if ($format === null) {
            return $this->datetime_end;
        } else {
            return $this->datetime_end instanceof \DateTimeInterface ? $this->datetime_end->format($format) : null;
        }
    }

    /**
     * Get the [pricelist_sheet_id] column value.
     *
     * @return int
     */
    public function getPricelistSheetId()
    {
        return $this->pricelist_sheet_id;
    }

    /**
     * Get the [time_start] column value.
     *
     * @return string
     */
    public function getTimeStart()
    {
        return $this->time_start;
    }

    /**
     * Get the [interval] column value.
     *
     * @return string
     */
    public function getInterval()
    {
        return $this->interval;
    }

    /**
     * Set the value of [id] column.
     *
     * @param int $v new value
     * @return $this|\MoySklad\Models\MoySkladTask\MoySkladTask The current object (for fluent API support)
     */
    public function setId($v)
    {
        if ($v !== null) {
            $v = (int) $v;
        }

        if ($this->id !== $v) {
            $this->id = $v;
            $this->modifiedColumns[MoySkladTaskTableMap::COL_ID] = true;
        }

        return $this;
    } // setId()

    /**
     * Set the value of [sale_price] column.
     *
     * @param string $v new value
     * @return $this|\MoySklad\Models\MoySkladTask\MoySkladTask The current object (for fluent API support)
     */
    public function setSalePrice($v)
    {
        if ($v !== null) {
            $v = (string) $v;
        }

        if ($this->sale_price !== $v) {
            $this->sale_price = $v;
            $this->modifiedColumns[MoySkladTaskTableMap::COL_SALE_PRICE] = true;
        }

        return $this;
    } // setSalePrice()

    /**
     * Set the value of [brand_id] column.
     *
     * @param int $v new value
     * @return $this|\MoySklad\Models\MoySkladTask\MoySkladTask The current object (for fluent API support)
     */
    public function setBrandId($v)
    {
        if ($v !== null) {
            $v = (int) $v;
        }

        if ($this->brand_id !== $v) {
            $this->brand_id = $v;
            $this->modifiedColumns[MoySkladTaskTableMap::COL_BRAND_ID] = true;
        }

        if ($this->aShopBrand !== null && $this->aShopBrand->getId() !== $v) {
            $this->aShopBrand = null;
        }

        return $this;
    } // setBrandId()

    /**
     * Set the value of [category_id] column.
     *
     * @param int $v new value
     * @return $this|\MoySklad\Models\MoySkladTask\MoySkladTask The current object (for fluent API support)
     */
    public function setCategoryId($v)
    {
        if ($v !== null) {
            $v = (int) $v;
        }

        if ($this->category_id !== $v) {
            $this->category_id = $v;
            $this->modifiedColumns[MoySkladTaskTableMap::COL_CATEGORY_ID] = true;
        }

        if ($this->aCategory !== null && $this->aCategory->getId() !== $v) {
            $this->aCategory = null;
        }

        return $this;
    } // setCategoryId()

    /**
     * Set the value of [login] column.
     *
     * @param string $v new value
     * @return $this|\MoySklad\Models\MoySkladTask\MoySkladTask The current object (for fluent API support)
     */
    public function setLogin($v)
    {
        if ($v !== null) {
            $v = (string) $v;
        }

        if ($this->login !== $v) {
            $this->login = $v;
            $this->modifiedColumns[MoySkladTaskTableMap::COL_LOGIN] = true;
        }

        return $this;
    } // setLogin()

    /**
     * Set the value of [password] column.
     *
     * @param string $v new value
     * @return $this|\MoySklad\Models\MoySkladTask\MoySkladTask The current object (for fluent API support)
     */
    public function setPassword($v)
    {
        if ($v !== null) {
            $v = (string) $v;
        }

        if ($this->password !== $v) {
            $this->password = $v;
            $this->modifiedColumns[MoySkladTaskTableMap::COL_PASSWORD] = true;
        }

        return $this;
    } // setPassword()

    /**
     * Set the value of [active] column.
     *
     * @param int $v new value
     * @return $this|\MoySklad\Models\MoySkladTask\MoySkladTask The current object (for fluent API support)
     */
    public function setActive($v)
    {
        if ($v !== null) {
            $v = (int) $v;
        }

        if ($this->active !== $v) {
            $this->active = $v;
            $this->modifiedColumns[MoySkladTaskTableMap::COL_ACTIVE] = true;
        }

        return $this;
    } // setActive()

    /**
     * Set the value of [complete] column.
     *
     * @param int $v new value
     * @return $this|\MoySklad\Models\MoySkladTask\MoySkladTask The current object (for fluent API support)
     */
    public function setComplete($v)
    {
        if ($v !== null) {
            $v = (int) $v;
        }

        if ($this->complete !== $v) {
            $this->complete = $v;
            $this->modifiedColumns[MoySkladTaskTableMap::COL_COMPLETE] = true;
        }

        return $this;
    } // setComplete()

    /**
     * Set the value of [stock_id] column.
     *
     * @param string $v new value
     * @return $this|\MoySklad\Models\MoySkladTask\MoySkladTask The current object (for fluent API support)
     */
    public function setStockId($v)
    {
        if ($v !== null) {
            $v = (string) $v;
        }

        if ($this->stock_id !== $v) {
            $this->stock_id = $v;
            $this->modifiedColumns[MoySkladTaskTableMap::COL_STOCK_ID] = true;
        }

        return $this;
    } // setStockId()

    /**
     * Set the value of [mark] column.
     *
     * @param int $v new value
     * @return $this|\MoySklad\Models\MoySkladTask\MoySkladTask The current object (for fluent API support)
     */
    public function setMark($v)
    {
        if ($v !== null) {
            $v = (int) $v;
        }

        if ($this->mark !== $v) {
            $this->mark = $v;
            $this->modifiedColumns[MoySkladTaskTableMap::COL_MARK] = true;
        }

        return $this;
    } // setMark()

    /**
     * Sets the value of [datetime_start] column to a normalized version of the date/time value specified.
     *
     * @param  mixed $v string, integer (timestamp), or \DateTimeInterface value.
     *               Empty strings are treated as NULL.
     * @return $this|\MoySklad\Models\MoySkladTask\MoySkladTask The current object (for fluent API support)
     */
    public function setDateTimeStart($v)
    {
        $dt = PropelDateTime::newInstance($v, null, 'DateTime');
        if ($this->datetime_start !== null || $dt !== null) {
            if ($this->datetime_start === null || $dt === null || $dt->format("Y-m-d H:i:s.u") !== $this->datetime_start->format("Y-m-d H:i:s.u")) {
                $this->datetime_start = $dt === null ? null : clone $dt;
                $this->modifiedColumns[MoySkladTaskTableMap::COL_DATETIME_START] = true;
            }
        } // if either are not null

        return $this;
    } // setDateTimeStart()

    /**
     * Sets the value of [datetime_end] column to a normalized version of the date/time value specified.
     *
     * @param  mixed $v string, integer (timestamp), or \DateTimeInterface value.
     *               Empty strings are treated as NULL.
     * @return $this|\MoySklad\Models\MoySkladTask\MoySkladTask The current object (for fluent API support)
     */
    public function setDateTimeEnd($v)
    {
        $dt = PropelDateTime::newInstance($v, null, 'DateTime');
        if ($this->datetime_end !== null || $dt !== null) {
            if ($this->datetime_end === null || $dt === null || $dt->format("Y-m-d H:i:s.u") !== $this->datetime_end->format("Y-m-d H:i:s.u")) {
                $this->datetime_end = $dt === null ? null : clone $dt;
                $this->modifiedColumns[MoySkladTaskTableMap::COL_DATETIME_END] = true;
            }
        } // if either are not null

        return $this;
    } // setDateTimeEnd()

    /**
     * Set the value of [pricelist_sheet_id] column.
     *
     * @param int $v new value
     * @return $this|\MoySklad\Models\MoySkladTask\MoySkladTask The current object (for fluent API support)
     */
    public function setPricelistSheetId($v)
    {
        if ($v !== null) {
            $v = (int) $v;
        }

        if ($this->pricelist_sheet_id !== $v) {
            $this->pricelist_sheet_id = $v;
            $this->modifiedColumns[MoySkladTaskTableMap::COL_PRICELIST_SHEET_ID] = true;
        }

        if ($this->aPricelistSheet !== null && $this->aPricelistSheet->getId() !== $v) {
            $this->aPricelistSheet = null;
        }

        return $this;
    } // setPricelistSheetId()

    /**
     * Set the value of [time_start] column.
     *
     * @param string $v new value
     * @return $this|\MoySklad\Models\MoySkladTask\MoySkladTask The current object (for fluent API support)
     */
    public function setTimeStart($v)
    {
        if ($v !== null) {
            $v = (string) $v;
        }

        if ($this->time_start !== $v) {
            $this->time_start = $v;
            $this->modifiedColumns[MoySkladTaskTableMap::COL_TIME_START] = true;
        }

        return $this;
    } // setTimeStart()

    /**
     * Set the value of [interval] column.
     *
     * @param string $v new value
     * @return $this|\MoySklad\Models\MoySkladTask\MoySkladTask The current object (for fluent API support)
     */
    public function setInterval($v)
    {
        if ($v !== null) {
            $v = (string) $v;
        }

        if ($this->interval !== $v) {
            $this->interval = $v;
            $this->modifiedColumns[MoySkladTaskTableMap::COL_INTERVAL] = true;
        }

        return $this;
    } // setInterval()

    /**
     * Indicates whether the columns in this object are only set to default values.
     *
     * This method can be used in conjunction with isModified() to indicate whether an object is both
     * modified _and_ has some values set which are non-default.
     *
     * @return boolean Whether the columns in this object are only been set with default values.
     */
    public function hasOnlyDefaultValues()
    {
            if ($this->active !== 1) {
                return false;
            }

            if ($this->complete !== 0) {
                return false;
            }

            if ($this->time_start !== '00:00') {
                return false;
            }

            if ($this->interval !== '1d') {
                return false;
            }

        // otherwise, everything was equal, so return TRUE
        return true;
    } // hasOnlyDefaultValues()

    /**
     * Hydrates (populates) the object variables with values from the database resultset.
     *
     * An offset (0-based "start column") is specified so that objects can be hydrated
     * with a subset of the columns in the resultset rows.  This is needed, for example,
     * for results of JOIN queries where the resultset row includes columns from two or
     * more tables.
     *
     * @param array   $row       The row returned by DataFetcher->fetch().
     * @param int     $startcol  0-based offset column which indicates which restultset column to start with.
     * @param boolean $rehydrate Whether this object is being re-hydrated from the database.
     * @param string  $indexType The index type of $row. Mostly DataFetcher->getIndexType().
                                  One of the class type constants TableMap::TYPE_PHPNAME, TableMap::TYPE_CAMELNAME
     *                            TableMap::TYPE_COLNAME, TableMap::TYPE_FIELDNAME, TableMap::TYPE_NUM.
     *
     * @return int             next starting column
     * @throws PropelException - Any caught Exception will be rewrapped as a PropelException.
     */
    public function hydrate($row, $startcol = 0, $rehydrate = false, $indexType = TableMap::TYPE_NUM)
    {
        try {

            $col = $row[TableMap::TYPE_NUM == $indexType ? 0 + $startcol : MoySkladTaskTableMap::translateFieldName('Id', TableMap::TYPE_PHPNAME, $indexType)];
            $this->id = (null !== $col) ? (int) $col : null;

            $col = $row[TableMap::TYPE_NUM == $indexType ? 1 + $startcol : MoySkladTaskTableMap::translateFieldName('SalePrice', TableMap::TYPE_PHPNAME, $indexType)];
            $this->sale_price = (null !== $col) ? (string) $col : null;

            $col = $row[TableMap::TYPE_NUM == $indexType ? 2 + $startcol : MoySkladTaskTableMap::translateFieldName('BrandId', TableMap::TYPE_PHPNAME, $indexType)];
            $this->brand_id = (null !== $col) ? (int) $col : null;

            $col = $row[TableMap::TYPE_NUM == $indexType ? 3 + $startcol : MoySkladTaskTableMap::translateFieldName('CategoryId', TableMap::TYPE_PHPNAME, $indexType)];
            $this->category_id = (null !== $col) ? (int) $col : null;

            $col = $row[TableMap::TYPE_NUM == $indexType ? 4 + $startcol : MoySkladTaskTableMap::translateFieldName('Login', TableMap::TYPE_PHPNAME, $indexType)];
            $this->login = (null !== $col) ? (string) $col : null;

            $col = $row[TableMap::TYPE_NUM == $indexType ? 5 + $startcol : MoySkladTaskTableMap::translateFieldName('Password', TableMap::TYPE_PHPNAME, $indexType)];
            $this->password = (null !== $col) ? (string) $col : null;

            $col = $row[TableMap::TYPE_NUM == $indexType ? 6 + $startcol : MoySkladTaskTableMap::translateFieldName('Active', TableMap::TYPE_PHPNAME, $indexType)];
            $this->active = (null !== $col) ? (int) $col : null;

            $col = $row[TableMap::TYPE_NUM == $indexType ? 7 + $startcol : MoySkladTaskTableMap::translateFieldName('Complete', TableMap::TYPE_PHPNAME, $indexType)];
            $this->complete = (null !== $col) ? (int) $col : null;

            $col = $row[TableMap::TYPE_NUM == $indexType ? 8 + $startcol : MoySkladTaskTableMap::translateFieldName('StockId', TableMap::TYPE_PHPNAME, $indexType)];
            $this->stock_id = (null !== $col) ? (string) $col : null;

            $col = $row[TableMap::TYPE_NUM == $indexType ? 9 + $startcol : MoySkladTaskTableMap::translateFieldName('Mark', TableMap::TYPE_PHPNAME, $indexType)];
            $this->mark = (null !== $col) ? (int) $col : null;

            $col = $row[TableMap::TYPE_NUM == $indexType ? 10 + $startcol : MoySkladTaskTableMap::translateFieldName('DateTimeStart', TableMap::TYPE_PHPNAME, $indexType)];
            if ($col === '0000-00-00 00:00:00') {
                $col = null;
            }
            $this->datetime_start = (null !== $col) ? PropelDateTime::newInstance($col, null, 'DateTime') : null;

            $col = $row[TableMap::TYPE_NUM == $indexType ? 11 + $startcol : MoySkladTaskTableMap::translateFieldName('DateTimeEnd', TableMap::TYPE_PHPNAME, $indexType)];
            if ($col === '0000-00-00 00:00:00') {
                $col = null;
            }
            $this->datetime_end = (null !== $col) ? PropelDateTime::newInstance($col, null, 'DateTime') : null;

            $col = $row[TableMap::TYPE_NUM == $indexType ? 12 + $startcol : MoySkladTaskTableMap::translateFieldName('PricelistSheetId', TableMap::TYPE_PHPNAME, $indexType)];
            $this->pricelist_sheet_id = (null !== $col) ? (int) $col : null;

            $col = $row[TableMap::TYPE_NUM == $indexType ? 13 + $startcol : MoySkladTaskTableMap::translateFieldName('TimeStart', TableMap::TYPE_PHPNAME, $indexType)];
            $this->time_start = (null !== $col) ? (string) $col : null;

            $col = $row[TableMap::TYPE_NUM == $indexType ? 14 + $startcol : MoySkladTaskTableMap::translateFieldName('Interval', TableMap::TYPE_PHPNAME, $indexType)];
            $this->interval = (null !== $col) ? (string) $col : null;
            $this->resetModified();

            $this->setNew(false);

            if ($rehydrate) {
                $this->ensureConsistency();
            }

            return $startcol + 15; // 15 = MoySkladTaskTableMap::NUM_HYDRATE_COLUMNS.

        } catch (Exception $e) {
            throw new PropelException(sprintf('Error populating %s object', '\\MoySklad\\Models\\MoySkladTask\\MoySkladTask'), 0, $e);
        }
    }

    /**
     * Checks and repairs the internal consistency of the object.
     *
     * This method is executed after an already-instantiated object is re-hydrated
     * from the database.  It exists to check any foreign keys to make sure that
     * the objects related to the current object are correct based on foreign key.
     *
     * You can override this method in the stub class, but you should always invoke
     * the base method from the overridden method (i.e. parent::ensureConsistency()),
     * in case your model changes.
     *
     * @throws PropelException
     */
    public function ensureConsistency()
    {
        if ($this->aShopBrand !== null && $this->brand_id !== $this->aShopBrand->getId()) {
            $this->aShopBrand = null;
        }
        if ($this->aCategory !== null && $this->category_id !== $this->aCategory->getId()) {
            $this->aCategory = null;
        }
        if ($this->aPricelistSheet !== null && $this->pricelist_sheet_id !== $this->aPricelistSheet->getId()) {
            $this->aPricelistSheet = null;
        }
    } // ensureConsistency

    /**
     * Reloads this object from datastore based on primary key and (optionally) resets all associated objects.
     *
     * This will only work if the object has been saved and has a valid primary key set.
     *
     * @param      boolean $deep (optional) Whether to also de-associated any related objects.
     * @param      ConnectionInterface $con (optional) The ConnectionInterface connection to use.
     * @return void
     * @throws PropelException - if this object is deleted, unsaved or doesn't have pk match in db
     */
    public function reload($deep = false, ConnectionInterface $con = null)
    {
        if ($this->isDeleted()) {
            throw new PropelException("Cannot reload a deleted object.");
        }

        if ($this->isNew()) {
            throw new PropelException("Cannot reload an unsaved object.");
        }

        if ($con === null) {
            $con = Propel::getServiceContainer()->getReadConnection(MoySkladTaskTableMap::DATABASE_NAME);
        }

        // We don't need to alter the object instance pool; we're just modifying this instance
        // already in the pool.

        $dataFetcher = ChildMoySkladTaskQuery::create(null, $this->buildPkeyCriteria())->setFormatter(ModelCriteria::FORMAT_STATEMENT)->find($con);
        $row = $dataFetcher->fetch();
        $dataFetcher->close();
        if (!$row) {
            throw new PropelException('Cannot find matching row in the database to reload object values.');
        }
        $this->hydrate($row, 0, true, $dataFetcher->getIndexType()); // rehydrate

        if ($deep) {  // also de-associate any related objects?

            $this->aShopBrand = null;
            $this->aCategory = null;
            $this->aPricelistSheet = null;
        } // if (deep)
    }

    /**
     * Removes this object from datastore and sets delete attribute.
     *
     * @param      ConnectionInterface $con
     * @return void
     * @throws PropelException
     * @see MoySkladTask::setDeleted()
     * @see MoySkladTask::isDeleted()
     */
    public function delete(ConnectionInterface $con = null)
    {
        if ($this->isDeleted()) {
            throw new PropelException("This object has already been deleted.");
        }

        if ($con === null) {
            $con = Propel::getServiceContainer()->getWriteConnection(MoySkladTaskTableMap::DATABASE_NAME);
        }

        $con->transaction(function () use ($con) {
            $deleteQuery = ChildMoySkladTaskQuery::create()
                ->filterByPrimaryKey($this->getPrimaryKey());
            $ret = $this->preDelete($con);
            if ($ret) {
                $deleteQuery->delete($con);
                $this->postDelete($con);
                $this->setDeleted(true);
            }
        });
    }

    /**
     * Persists this object to the database.
     *
     * If the object is new, it inserts it; otherwise an update is performed.
     * All modified related objects will also be persisted in the doSave()
     * method.  This method wraps all precipitate database operations in a
     * single transaction.
     *
     * @param      ConnectionInterface $con
     * @return int             The number of rows affected by this insert/update and any referring fk objects' save() operations.
     * @throws PropelException
     * @see doSave()
     */
    public function save(ConnectionInterface $con = null)
    {
        if ($this->isDeleted()) {
            throw new PropelException("You cannot save an object that has been deleted.");
        }

        if ($this->alreadyInSave) {
            return 0;
        }

        if ($con === null) {
            $con = Propel::getServiceContainer()->getWriteConnection(MoySkladTaskTableMap::DATABASE_NAME);
        }

        return $con->transaction(function () use ($con) {
            $ret = $this->preSave($con);
            $isInsert = $this->isNew();
            if ($isInsert) {
                $ret = $ret && $this->preInsert($con);
            } else {
                $ret = $ret && $this->preUpdate($con);
            }
            if ($ret) {
                $affectedRows = $this->doSave($con);
                if ($isInsert) {
                    $this->postInsert($con);
                } else {
                    $this->postUpdate($con);
                }
                $this->postSave($con);
                MoySkladTaskTableMap::addInstanceToPool($this);
            } else {
                $affectedRows = 0;
            }

            return $affectedRows;
        });
    }

    /**
     * Performs the work of inserting or updating the row in the database.
     *
     * If the object is new, it inserts it; otherwise an update is performed.
     * All related objects are also updated in this method.
     *
     * @param      ConnectionInterface $con
     * @return int             The number of rows affected by this insert/update and any referring fk objects' save() operations.
     * @throws PropelException
     * @see save()
     */
    protected function doSave(ConnectionInterface $con)
    {
        $affectedRows = 0; // initialize var to track total num of affected rows
        if (!$this->alreadyInSave) {
            $this->alreadyInSave = true;

            // We call the save method on the following object(s) if they
            // were passed to this object by their corresponding set
            // method.  This object relates to these object(s) by a
            // foreign key reference.

            if ($this->aShopBrand !== null) {
                if ($this->aShopBrand->isModified() || $this->aShopBrand->isNew()) {
                    $affectedRows += $this->aShopBrand->save($con);
                }
                $this->setShopBrand($this->aShopBrand);
            }

            if ($this->aCategory !== null) {
                if ($this->aCategory->isModified() || $this->aCategory->isNew()) {
                    $affectedRows += $this->aCategory->save($con);
                }
                $this->setCategory($this->aCategory);
            }

            if ($this->aPricelistSheet !== null) {
                if ($this->aPricelistSheet->isModified() || $this->aPricelistSheet->isNew()) {
                    $affectedRows += $this->aPricelistSheet->save($con);
                }
                $this->setPricelistSheet($this->aPricelistSheet);
            }

            if ($this->isNew() || $this->isModified()) {
                // persist changes
                if ($this->isNew()) {
                    $this->doInsert($con);
                    $affectedRows += 1;
                } else {
                    $affectedRows += $this->doUpdate($con);
                }
                $this->resetModified();
            }

            $this->alreadyInSave = false;

        }

        return $affectedRows;
    } // doSave()

    /**
     * Insert the row in the database.
     *
     * @param      ConnectionInterface $con
     *
     * @throws PropelException
     * @see doSave()
     */
    protected function doInsert(ConnectionInterface $con)
    {
        $modifiedColumns = array();
        $index = 0;

        $this->modifiedColumns[MoySkladTaskTableMap::COL_ID] = true;
        if (null !== $this->id) {
            throw new PropelException('Cannot insert a value for auto-increment primary key (' . MoySkladTaskTableMap::COL_ID . ')');
        }

         // check the columns in natural order for more readable SQL queries
        if ($this->isColumnModified(MoySkladTaskTableMap::COL_ID)) {
            $modifiedColumns[':p' . $index++]  = '`id`';
        }
        if ($this->isColumnModified(MoySkladTaskTableMap::COL_SALE_PRICE)) {
            $modifiedColumns[':p' . $index++]  = '`sale_price`';
        }
        if ($this->isColumnModified(MoySkladTaskTableMap::COL_BRAND_ID)) {
            $modifiedColumns[':p' . $index++]  = '`brand_id`';
        }
        if ($this->isColumnModified(MoySkladTaskTableMap::COL_CATEGORY_ID)) {
            $modifiedColumns[':p' . $index++]  = '`category_id`';
        }
        if ($this->isColumnModified(MoySkladTaskTableMap::COL_LOGIN)) {
            $modifiedColumns[':p' . $index++]  = '`login`';
        }
        if ($this->isColumnModified(MoySkladTaskTableMap::COL_PASSWORD)) {
            $modifiedColumns[':p' . $index++]  = '`password`';
        }
        if ($this->isColumnModified(MoySkladTaskTableMap::COL_ACTIVE)) {
            $modifiedColumns[':p' . $index++]  = '`active`';
        }
        if ($this->isColumnModified(MoySkladTaskTableMap::COL_COMPLETE)) {
            $modifiedColumns[':p' . $index++]  = '`complete`';
        }
        if ($this->isColumnModified(MoySkladTaskTableMap::COL_STOCK_ID)) {
            $modifiedColumns[':p' . $index++]  = '`stock_id`';
        }
        if ($this->isColumnModified(MoySkladTaskTableMap::COL_MARK)) {
            $modifiedColumns[':p' . $index++]  = '`mark`';
        }
        if ($this->isColumnModified(MoySkladTaskTableMap::COL_DATETIME_START)) {
            $modifiedColumns[':p' . $index++]  = '`datetime_start`';
        }
        if ($this->isColumnModified(MoySkladTaskTableMap::COL_DATETIME_END)) {
            $modifiedColumns[':p' . $index++]  = '`datetime_end`';
        }
        if ($this->isColumnModified(MoySkladTaskTableMap::COL_PRICELIST_SHEET_ID)) {
            $modifiedColumns[':p' . $index++]  = '`pricelist_sheet_id`';
        }
        if ($this->isColumnModified(MoySkladTaskTableMap::COL_TIME_START)) {
            $modifiedColumns[':p' . $index++]  = '`time_start`';
        }
        if ($this->isColumnModified(MoySkladTaskTableMap::COL_INTERVAL)) {
            $modifiedColumns[':p' . $index++]  = '`interval`';
        }

        $sql = sprintf(
            'INSERT INTO `moysklad_tasks` (%s) VALUES (%s)',
            implode(', ', $modifiedColumns),
            implode(', ', array_keys($modifiedColumns))
        );

        try {
            $stmt = $con->prepare($sql);
            foreach ($modifiedColumns as $identifier => $columnName) {
                switch ($columnName) {
                    case '`id`':
                        $stmt->bindValue($identifier, $this->id, PDO::PARAM_INT);
                        break;
                    case '`sale_price`':
                        $stmt->bindValue($identifier, $this->sale_price, PDO::PARAM_STR);
                        break;
                    case '`brand_id`':
                        $stmt->bindValue($identifier, $this->brand_id, PDO::PARAM_INT);
                        break;
                    case '`category_id`':
                        $stmt->bindValue($identifier, $this->category_id, PDO::PARAM_INT);
                        break;
                    case '`login`':
                        $stmt->bindValue($identifier, $this->login, PDO::PARAM_STR);
                        break;
                    case '`password`':
                        $stmt->bindValue($identifier, $this->password, PDO::PARAM_STR);
                        break;
                    case '`active`':
                        $stmt->bindValue($identifier, $this->active, PDO::PARAM_INT);
                        break;
                    case '`complete`':
                        $stmt->bindValue($identifier, $this->complete, PDO::PARAM_INT);
                        break;
                    case '`stock_id`':
                        $stmt->bindValue($identifier, $this->stock_id, PDO::PARAM_STR);
                        break;
                    case '`mark`':
                        $stmt->bindValue($identifier, $this->mark, PDO::PARAM_INT);
                        break;
                    case '`datetime_start`':
                        $stmt->bindValue($identifier, $this->datetime_start ? $this->datetime_start->format("Y-m-d H:i:s.u") : null, PDO::PARAM_STR);
                        break;
                    case '`datetime_end`':
                        $stmt->bindValue($identifier, $this->datetime_end ? $this->datetime_end->format("Y-m-d H:i:s.u") : null, PDO::PARAM_STR);
                        break;
                    case '`pricelist_sheet_id`':
                        $stmt->bindValue($identifier, $this->pricelist_sheet_id, PDO::PARAM_INT);
                        break;
                    case '`time_start`':
                        $stmt->bindValue($identifier, $this->time_start, PDO::PARAM_STR);
                        break;
                    case '`interval`':
                        $stmt->bindValue($identifier, $this->interval, PDO::PARAM_STR);
                        break;
                }
            }
            $stmt->execute();
        } catch (Exception $e) {
            Propel::log($e->getMessage(), Propel::LOG_ERR);
            throw new PropelException(sprintf('Unable to execute INSERT statement [%s]', $sql), 0, $e);
        }

        try {
            $pk = $con->lastInsertId();
        } catch (Exception $e) {
            throw new PropelException('Unable to get autoincrement id.', 0, $e);
        }
        $this->setId($pk);

        $this->setNew(false);
    }

    /**
     * Update the row in the database.
     *
     * @param      ConnectionInterface $con
     *
     * @return Integer Number of updated rows
     * @see doSave()
     */
    protected function doUpdate(ConnectionInterface $con)
    {
        $selectCriteria = $this->buildPkeyCriteria();
        $valuesCriteria = $this->buildCriteria();

        return $selectCriteria->doUpdate($valuesCriteria, $con);
    }

    /**
     * Retrieves a field from the object by name passed in as a string.
     *
     * @param      string $name name
     * @param      string $type The type of fieldname the $name is of:
     *                     one of the class type constants TableMap::TYPE_PHPNAME, TableMap::TYPE_CAMELNAME
     *                     TableMap::TYPE_COLNAME, TableMap::TYPE_FIELDNAME, TableMap::TYPE_NUM.
     *                     Defaults to TableMap::TYPE_PHPNAME.
     * @return mixed Value of field.
     */
    public function getByName($name, $type = TableMap::TYPE_PHPNAME)
    {
        $pos = MoySkladTaskTableMap::translateFieldName($name, $type, TableMap::TYPE_NUM);
        $field = $this->getByPosition($pos);

        return $field;
    }

    /**
     * Retrieves a field from the object by Position as specified in the xml schema.
     * Zero-based.
     *
     * @param      int $pos position in xml schema
     * @return mixed Value of field at $pos
     */
    public function getByPosition($pos)
    {
        switch ($pos) {
            case 0:
                return $this->getId();
                break;
            case 1:
                return $this->getSalePrice();
                break;
            case 2:
                return $this->getBrandId();
                break;
            case 3:
                return $this->getCategoryId();
                break;
            case 4:
                return $this->getLogin();
                break;
            case 5:
                return $this->getPassword();
                break;
            case 6:
                return $this->getActive();
                break;
            case 7:
                return $this->getComplete();
                break;
            case 8:
                return $this->getStockId();
                break;
            case 9:
                return $this->getMark();
                break;
            case 10:
                return $this->getDateTimeStart();
                break;
            case 11:
                return $this->getDateTimeEnd();
                break;
            case 12:
                return $this->getPricelistSheetId();
                break;
            case 13:
                return $this->getTimeStart();
                break;
            case 14:
                return $this->getInterval();
                break;
            default:
                return null;
                break;
        } // switch()
    }

    /**
     * Exports the object as an array.
     *
     * You can specify the key type of the array by passing one of the class
     * type constants.
     *
     * @param     string  $keyType (optional) One of the class type constants TableMap::TYPE_PHPNAME, TableMap::TYPE_CAMELNAME,
     *                    TableMap::TYPE_COLNAME, TableMap::TYPE_FIELDNAME, TableMap::TYPE_NUM.
     *                    Defaults to TableMap::TYPE_PHPNAME.
     * @param     boolean $includeLazyLoadColumns (optional) Whether to include lazy loaded columns. Defaults to TRUE.
     * @param     array $alreadyDumpedObjects List of objects to skip to avoid recursion
     * @param     boolean $includeForeignObjects (optional) Whether to include hydrated related objects. Default to FALSE.
     *
     * @return array an associative array containing the field names (as keys) and field values
     */
    public function toArray($keyType = TableMap::TYPE_PHPNAME, $includeLazyLoadColumns = true, $alreadyDumpedObjects = array(), $includeForeignObjects = false)
    {

        if (isset($alreadyDumpedObjects['MoySkladTask'][$this->hashCode()])) {
            return '*RECURSION*';
        }
        $alreadyDumpedObjects['MoySkladTask'][$this->hashCode()] = true;
        $keys = MoySkladTaskTableMap::getFieldNames($keyType);
        $result = array(
            $keys[0] => $this->getId(),
            $keys[1] => $this->getSalePrice(),
            $keys[2] => $this->getBrandId(),
            $keys[3] => $this->getCategoryId(),
            $keys[4] => $this->getLogin(),
            $keys[5] => $this->getPassword(),
            $keys[6] => $this->getActive(),
            $keys[7] => $this->getComplete(),
            $keys[8] => $this->getStockId(),
            $keys[9] => $this->getMark(),
            $keys[10] => $this->getDateTimeStart(),
            $keys[11] => $this->getDateTimeEnd(),
            $keys[12] => $this->getPricelistSheetId(),
            $keys[13] => $this->getTimeStart(),
            $keys[14] => $this->getInterval(),
        );
        if ($result[$keys[10]] instanceof \DateTimeInterface) {
            $result[$keys[10]] = $result[$keys[10]]->format('c');
        }

        if ($result[$keys[11]] instanceof \DateTimeInterface) {
            $result[$keys[11]] = $result[$keys[11]]->format('c');
        }

        $virtualColumns = $this->virtualColumns;
        foreach ($virtualColumns as $key => $virtualColumn) {
            $result[$key] = $virtualColumn;
        }

        if ($includeForeignObjects) {
            if (null !== $this->aShopBrand) {

                switch ($keyType) {
                    case TableMap::TYPE_CAMELNAME:
                        $key = 'brand';
                        break;
                    case TableMap::TYPE_FIELDNAME:
                        $key = 'shop_brands';
                        break;
                    default:
                        $key = 'ShopBrand';
                }

                $result[$key] = $this->aShopBrand->toArray($keyType, $includeLazyLoadColumns,  $alreadyDumpedObjects, true);
            }
            if (null !== $this->aCategory) {

                switch ($keyType) {
                    case TableMap::TYPE_CAMELNAME:
                        $key = 'category';
                        break;
                    case TableMap::TYPE_FIELDNAME:
                        $key = 'shop_categories';
                        break;
                    default:
                        $key = 'Category';
                }

                $result[$key] = $this->aCategory->toArray($keyType, $includeLazyLoadColumns,  $alreadyDumpedObjects, true);
            }
            if (null !== $this->aPricelistSheet) {

                switch ($keyType) {
                    case TableMap::TYPE_CAMELNAME:
                        $key = 'pricelistSheet';
                        break;
                    case TableMap::TYPE_FIELDNAME:
                        $key = 'shop_pricelist_sheets';
                        break;
                    default:
                        $key = 'PricelistSheet';
                }

                $result[$key] = $this->aPricelistSheet->toArray($keyType, $includeLazyLoadColumns,  $alreadyDumpedObjects, true);
            }
        }

        return $result;
    }

    /**
     * Sets a field from the object by name passed in as a string.
     *
     * @param  string $name
     * @param  mixed  $value field value
     * @param  string $type The type of fieldname the $name is of:
     *                one of the class type constants TableMap::TYPE_PHPNAME, TableMap::TYPE_CAMELNAME
     *                TableMap::TYPE_COLNAME, TableMap::TYPE_FIELDNAME, TableMap::TYPE_NUM.
     *                Defaults to TableMap::TYPE_PHPNAME.
     * @return $this|\MoySklad\Models\MoySkladTask\MoySkladTask
     */
    public function setByName($name, $value, $type = TableMap::TYPE_PHPNAME)
    {
        $pos = MoySkladTaskTableMap::translateFieldName($name, $type, TableMap::TYPE_NUM);

        return $this->setByPosition($pos, $value);
    }

    /**
     * Sets a field from the object by Position as specified in the xml schema.
     * Zero-based.
     *
     * @param  int $pos position in xml schema
     * @param  mixed $value field value
     * @return $this|\MoySklad\Models\MoySkladTask\MoySkladTask
     */
    public function setByPosition($pos, $value)
    {
        switch ($pos) {
            case 0:
                $this->setId($value);
                break;
            case 1:
                $this->setSalePrice($value);
                break;
            case 2:
                $this->setBrandId($value);
                break;
            case 3:
                $this->setCategoryId($value);
                break;
            case 4:
                $this->setLogin($value);
                break;
            case 5:
                $this->setPassword($value);
                break;
            case 6:
                $this->setActive($value);
                break;
            case 7:
                $this->setComplete($value);
                break;
            case 8:
                $this->setStockId($value);
                break;
            case 9:
                $this->setMark($value);
                break;
            case 10:
                $this->setDateTimeStart($value);
                break;
            case 11:
                $this->setDateTimeEnd($value);
                break;
            case 12:
                $this->setPricelistSheetId($value);
                break;
            case 13:
                $this->setTimeStart($value);
                break;
            case 14:
                $this->setInterval($value);
                break;
        } // switch()

        return $this;
    }

    /**
     * Populates the object using an array.
     *
     * This is particularly useful when populating an object from one of the
     * request arrays (e.g. $_POST).  This method goes through the column
     * names, checking to see whether a matching key exists in populated
     * array. If so the setByName() method is called for that column.
     *
     * You can specify the key type of the array by additionally passing one
     * of the class type constants TableMap::TYPE_PHPNAME, TableMap::TYPE_CAMELNAME,
     * TableMap::TYPE_COLNAME, TableMap::TYPE_FIELDNAME, TableMap::TYPE_NUM.
     * The default key type is the column's TableMap::TYPE_PHPNAME.
     *
     * @param      array  $arr     An array to populate the object from.
     * @param      string $keyType The type of keys the array uses.
     * @return void
     */
    public function fromArray($arr, $keyType = TableMap::TYPE_PHPNAME)
    {
        $keys = MoySkladTaskTableMap::getFieldNames($keyType);

        if (array_key_exists($keys[0], $arr)) {
            $this->setId($arr[$keys[0]]);
        }
        if (array_key_exists($keys[1], $arr)) {
            $this->setSalePrice($arr[$keys[1]]);
        }
        if (array_key_exists($keys[2], $arr)) {
            $this->setBrandId($arr[$keys[2]]);
        }
        if (array_key_exists($keys[3], $arr)) {
            $this->setCategoryId($arr[$keys[3]]);
        }
        if (array_key_exists($keys[4], $arr)) {
            $this->setLogin($arr[$keys[4]]);
        }
        if (array_key_exists($keys[5], $arr)) {
            $this->setPassword($arr[$keys[5]]);
        }
        if (array_key_exists($keys[6], $arr)) {
            $this->setActive($arr[$keys[6]]);
        }
        if (array_key_exists($keys[7], $arr)) {
            $this->setComplete($arr[$keys[7]]);
        }
        if (array_key_exists($keys[8], $arr)) {
            $this->setStockId($arr[$keys[8]]);
        }
        if (array_key_exists($keys[9], $arr)) {
            $this->setMark($arr[$keys[9]]);
        }
        if (array_key_exists($keys[10], $arr)) {
            $this->setDateTimeStart($arr[$keys[10]]);
        }
        if (array_key_exists($keys[11], $arr)) {
            $this->setDateTimeEnd($arr[$keys[11]]);
        }
        if (array_key_exists($keys[12], $arr)) {
            $this->setPricelistSheetId($arr[$keys[12]]);
        }
        if (array_key_exists($keys[13], $arr)) {
            $this->setTimeStart($arr[$keys[13]]);
        }
        if (array_key_exists($keys[14], $arr)) {
            $this->setInterval($arr[$keys[14]]);
        }
    }

     /**
     * Populate the current object from a string, using a given parser format
     * <code>
     * $book = new Book();
     * $book->importFrom('JSON', '{"Id":9012,"Title":"Don Juan","ISBN":"0140422161","Price":12.99,"PublisherId":1234,"AuthorId":5678}');
     * </code>
     *
     * You can specify the key type of the array by additionally passing one
     * of the class type constants TableMap::TYPE_PHPNAME, TableMap::TYPE_CAMELNAME,
     * TableMap::TYPE_COLNAME, TableMap::TYPE_FIELDNAME, TableMap::TYPE_NUM.
     * The default key type is the column's TableMap::TYPE_PHPNAME.
     *
     * @param mixed $parser A AbstractParser instance,
     *                       or a format name ('XML', 'YAML', 'JSON', 'CSV')
     * @param string $data The source data to import from
     * @param string $keyType The type of keys the array uses.
     *
     * @return $this|\MoySklad\Models\MoySkladTask\MoySkladTask The current object, for fluid interface
     */
    public function importFrom($parser, $data, $keyType = TableMap::TYPE_PHPNAME)
    {
        if (!$parser instanceof AbstractParser) {
            $parser = AbstractParser::getParser($parser);
        }

        $this->fromArray($parser->toArray($data), $keyType);

        return $this;
    }

    /**
     * Build a Criteria object containing the values of all modified columns in this object.
     *
     * @return Criteria The Criteria object containing all modified values.
     */
    public function buildCriteria()
    {
        $criteria = new Criteria(MoySkladTaskTableMap::DATABASE_NAME);

        if ($this->isColumnModified(MoySkladTaskTableMap::COL_ID)) {
            $criteria->add(MoySkladTaskTableMap::COL_ID, $this->id);
        }
        if ($this->isColumnModified(MoySkladTaskTableMap::COL_SALE_PRICE)) {
            $criteria->add(MoySkladTaskTableMap::COL_SALE_PRICE, $this->sale_price);
        }
        if ($this->isColumnModified(MoySkladTaskTableMap::COL_BRAND_ID)) {
            $criteria->add(MoySkladTaskTableMap::COL_BRAND_ID, $this->brand_id);
        }
        if ($this->isColumnModified(MoySkladTaskTableMap::COL_CATEGORY_ID)) {
            $criteria->add(MoySkladTaskTableMap::COL_CATEGORY_ID, $this->category_id);
        }
        if ($this->isColumnModified(MoySkladTaskTableMap::COL_LOGIN)) {
            $criteria->add(MoySkladTaskTableMap::COL_LOGIN, $this->login);
        }
        if ($this->isColumnModified(MoySkladTaskTableMap::COL_PASSWORD)) {
            $criteria->add(MoySkladTaskTableMap::COL_PASSWORD, $this->password);
        }
        if ($this->isColumnModified(MoySkladTaskTableMap::COL_ACTIVE)) {
            $criteria->add(MoySkladTaskTableMap::COL_ACTIVE, $this->active);
        }
        if ($this->isColumnModified(MoySkladTaskTableMap::COL_COMPLETE)) {
            $criteria->add(MoySkladTaskTableMap::COL_COMPLETE, $this->complete);
        }
        if ($this->isColumnModified(MoySkladTaskTableMap::COL_STOCK_ID)) {
            $criteria->add(MoySkladTaskTableMap::COL_STOCK_ID, $this->stock_id);
        }
        if ($this->isColumnModified(MoySkladTaskTableMap::COL_MARK)) {
            $criteria->add(MoySkladTaskTableMap::COL_MARK, $this->mark);
        }
        if ($this->isColumnModified(MoySkladTaskTableMap::COL_DATETIME_START)) {
            $criteria->add(MoySkladTaskTableMap::COL_DATETIME_START, $this->datetime_start);
        }
        if ($this->isColumnModified(MoySkladTaskTableMap::COL_DATETIME_END)) {
            $criteria->add(MoySkladTaskTableMap::COL_DATETIME_END, $this->datetime_end);
        }
        if ($this->isColumnModified(MoySkladTaskTableMap::COL_PRICELIST_SHEET_ID)) {
            $criteria->add(MoySkladTaskTableMap::COL_PRICELIST_SHEET_ID, $this->pricelist_sheet_id);
        }
        if ($this->isColumnModified(MoySkladTaskTableMap::COL_TIME_START)) {
            $criteria->add(MoySkladTaskTableMap::COL_TIME_START, $this->time_start);
        }
        if ($this->isColumnModified(MoySkladTaskTableMap::COL_INTERVAL)) {
            $criteria->add(MoySkladTaskTableMap::COL_INTERVAL, $this->interval);
        }

        return $criteria;
    }

    /**
     * Builds a Criteria object containing the primary key for this object.
     *
     * Unlike buildCriteria() this method includes the primary key values regardless
     * of whether or not they have been modified.
     *
     * @throws LogicException if no primary key is defined
     *
     * @return Criteria The Criteria object containing value(s) for primary key(s).
     */
    public function buildPkeyCriteria()
    {
        $criteria = ChildMoySkladTaskQuery::create();
        $criteria->add(MoySkladTaskTableMap::COL_ID, $this->id);

        return $criteria;
    }

    /**
     * If the primary key is not null, return the hashcode of the
     * primary key. Otherwise, return the hash code of the object.
     *
     * @return int Hashcode
     */
    public function hashCode()
    {
        $validPk = null !== $this->getId();

        $validPrimaryKeyFKs = 0;
        $primaryKeyFKs = [];

        if ($validPk) {
            return crc32(json_encode($this->getPrimaryKey(), JSON_UNESCAPED_UNICODE));
        } elseif ($validPrimaryKeyFKs) {
            return crc32(json_encode($primaryKeyFKs, JSON_UNESCAPED_UNICODE));
        }

        return spl_object_hash($this);
    }

    /**
     * Returns the primary key for this object (row).
     * @return int
     */
    public function getPrimaryKey()
    {
        return $this->getId();
    }

    /**
     * Generic method to set the primary key (id column).
     *
     * @param       int $key Primary key.
     * @return void
     */
    public function setPrimaryKey($key)
    {
        $this->setId($key);
    }

    /**
     * Returns true if the primary key for this object is null.
     * @return boolean
     */
    public function isPrimaryKeyNull()
    {
        return null === $this->getId();
    }

    /**
     * Sets contents of passed object to values from current object.
     *
     * If desired, this method can also make copies of all associated (fkey referrers)
     * objects.
     *
     * @param      object $copyObj An object of \MoySklad\Models\MoySkladTask\MoySkladTask (or compatible) type.
     * @param      boolean $deepCopy Whether to also copy all rows that refer (by fkey) to the current row.
     * @param      boolean $makeNew Whether to reset autoincrement PKs and make the object new.
     * @throws PropelException
     */
    public function copyInto($copyObj, $deepCopy = false, $makeNew = true)
    {
        $copyObj->setSalePrice($this->getSalePrice());
        $copyObj->setBrandId($this->getBrandId());
        $copyObj->setCategoryId($this->getCategoryId());
        $copyObj->setLogin($this->getLogin());
        $copyObj->setPassword($this->getPassword());
        $copyObj->setActive($this->getActive());
        $copyObj->setComplete($this->getComplete());
        $copyObj->setStockId($this->getStockId());
        $copyObj->setMark($this->getMark());
        $copyObj->setDateTimeStart($this->getDateTimeStart());
        $copyObj->setDateTimeEnd($this->getDateTimeEnd());
        $copyObj->setPricelistSheetId($this->getPricelistSheetId());
        $copyObj->setTimeStart($this->getTimeStart());
        $copyObj->setInterval($this->getInterval());
        if ($makeNew) {
            $copyObj->setNew(true);
            $copyObj->setId(NULL); // this is a auto-increment column, so set to default value
        }
    }

    /**
     * Makes a copy of this object that will be inserted as a new row in table when saved.
     * It creates a new object filling in the simple attributes, but skipping any primary
     * keys that are defined for the table.
     *
     * If desired, this method can also make copies of all associated (fkey referrers)
     * objects.
     *
     * @param  boolean $deepCopy Whether to also copy all rows that refer (by fkey) to the current row.
     * @return \MoySklad\Models\MoySkladTask\MoySkladTask Clone of current object.
     * @throws PropelException
     */
    public function copy($deepCopy = false)
    {
        // we use get_class(), because this might be a subclass
        $clazz = get_class($this);
        $copyObj = new $clazz();
        $this->copyInto($copyObj, $deepCopy);

        return $copyObj;
    }

    /**
     * Declares an association between this object and a Brand object.
     *
     * @param  Brand $v
     * @return $this|\MoySklad\Models\MoySkladTask\MoySkladTask The current object (for fluent API support)
     * @throws PropelException
     */
    public function setShopBrand(Brand $v = null)
    {
        if ($v === null) {
            $this->setBrandId(NULL);
        } else {
            $this->setBrandId($v->getId());
        }

        $this->aShopBrand = $v;

        // Add binding for other direction of this n:n relationship.
        // If this object has already been added to the Brand object, it will not be re-added.
        if ($v !== null) {
            $v->addMoySkladTask($this);
        }


        return $this;
    }


    /**
     * Get the associated Brand object
     *
     * @param  ConnectionInterface $con Optional Connection object.
     * @return Brand The associated Brand object.
     * @throws PropelException
     */
    public function getShopBrand(ConnectionInterface $con = null)
    {
        if ($this->aShopBrand === null && ($this->brand_id != 0)) {
            $this->aShopBrand = BrandQuery::create()->findPk($this->brand_id, $con);
            /* The following can be used additionally to
                guarantee the related object contains a reference
                to this object.  This level of coupling may, however, be
                undesirable since it could result in an only partially populated collection
                in the referenced object.
                $this->aShopBrand->addMoySkladTasks($this);
             */
        }

        return $this->aShopBrand;
    }

    /**
     * Declares an association between this object and a Category object.
     *
     * @param  Category $v
     * @return $this|\MoySklad\Models\MoySkladTask\MoySkladTask The current object (for fluent API support)
     * @throws PropelException
     */
    public function setCategory(Category $v = null)
    {
        if ($v === null) {
            $this->setCategoryId(NULL);
        } else {
            $this->setCategoryId($v->getId());
        }

        $this->aCategory = $v;

        // Add binding for other direction of this n:n relationship.
        // If this object has already been added to the Category object, it will not be re-added.
        if ($v !== null) {
            $v->addMoySkladTask($this);
        }


        return $this;
    }


    /**
     * Get the associated Category object
     *
     * @param  ConnectionInterface $con Optional Connection object.
     * @return Category The associated Category object.
     * @throws PropelException
     */
    public function getCategory(ConnectionInterface $con = null)
    {
        if ($this->aCategory === null && ($this->category_id != 0)) {
            $this->aCategory = CategoryQuery::create()->findPk($this->category_id, $con);
            /* The following can be used additionally to
                guarantee the related object contains a reference
                to this object.  This level of coupling may, however, be
                undesirable since it could result in an only partially populated collection
                in the referenced object.
                $this->aCategory->addMoySkladTasks($this);
             */
        }

        return $this->aCategory;
    }

    /**
     * Declares an association between this object and a PricelistSheet object.
     *
     * @param  PricelistSheet $v
     * @return $this|\MoySklad\Models\MoySkladTask\MoySkladTask The current object (for fluent API support)
     * @throws PropelException
     */
    public function setPricelistSheet(PricelistSheet $v = null)
    {
        if ($v === null) {
            $this->setPricelistSheetId(NULL);
        } else {
            $this->setPricelistSheetId($v->getId());
        }

        $this->aPricelistSheet = $v;

        // Add binding for other direction of this n:n relationship.
        // If this object has already been added to the PricelistSheet object, it will not be re-added.
        if ($v !== null) {
            $v->addMoySkladTask($this);
        }


        return $this;
    }


    /**
     * Get the associated PricelistSheet object
     *
     * @param  ConnectionInterface $con Optional Connection object.
     * @return PricelistSheet The associated PricelistSheet object.
     * @throws PropelException
     */
    public function getPricelistSheet(ConnectionInterface $con = null)
    {
        if ($this->aPricelistSheet === null && ($this->pricelist_sheet_id != 0)) {
            $this->aPricelistSheet = PricelistSheetQuery::create()->findPk($this->pricelist_sheet_id, $con);
            /* The following can be used additionally to
                guarantee the related object contains a reference
                to this object.  This level of coupling may, however, be
                undesirable since it could result in an only partially populated collection
                in the referenced object.
                $this->aPricelistSheet->addMoySkladTasks($this);
             */
        }

        return $this->aPricelistSheet;
    }

    /**
     * Clears the current object, sets all attributes to their default values and removes
     * outgoing references as well as back-references (from other objects to this one. Results probably in a database
     * change of those foreign objects when you call `save` there).
     */
    public function clear()
    {
        if (null !== $this->aShopBrand) {
            $this->aShopBrand->removeMoySkladTask($this);
        }
        if (null !== $this->aCategory) {
            $this->aCategory->removeMoySkladTask($this);
        }
        if (null !== $this->aPricelistSheet) {
            $this->aPricelistSheet->removeMoySkladTask($this);
        }
        $this->id = null;
        $this->sale_price = null;
        $this->brand_id = null;
        $this->category_id = null;
        $this->login = null;
        $this->password = null;
        $this->active = null;
        $this->complete = null;
        $this->stock_id = null;
        $this->mark = null;
        $this->datetime_start = null;
        $this->datetime_end = null;
        $this->pricelist_sheet_id = null;
        $this->time_start = null;
        $this->interval = null;
        $this->alreadyInSave = false;
        $this->clearAllReferences();
        $this->applyDefaultValues();
        $this->resetModified();
        $this->setNew(true);
        $this->setDeleted(false);
    }

    /**
     * Resets all references and back-references to other model objects or collections of model objects.
     *
     * This method is used to reset all php object references (not the actual reference in the database).
     * Necessary for object serialisation.
     *
     * @param      boolean $deep Whether to also clear the references on all referrer objects.
     */
    public function clearAllReferences($deep = false)
    {
        if ($deep) {
        } // if ($deep)

        $this->aShopBrand = null;
        $this->aCategory = null;
        $this->aPricelistSheet = null;
    }

    /**
     * Return the string representation of this object
     *
     * @return string
     */
    public function __toString()
    {
        return (string) $this->exportTo(MoySkladTaskTableMap::DEFAULT_STRING_FORMAT);
    }

    /**
     * Code to be run before persisting the object
     * @param  ConnectionInterface $con
     * @return boolean
     */
    public function preSave(ConnectionInterface $con = null)
    {
                return true;
    }

    /**
     * Code to be run after persisting the object
     * @param ConnectionInterface $con
     */
    public function postSave(ConnectionInterface $con = null)
    {
            }

    /**
     * Code to be run before inserting to database
     * @param  ConnectionInterface $con
     * @return boolean
     */
    public function preInsert(ConnectionInterface $con = null)
    {
                return true;
    }

    /**
     * Code to be run after inserting to database
     * @param ConnectionInterface $con
     */
    public function postInsert(ConnectionInterface $con = null)
    {
            }

    /**
     * Code to be run before updating the object in database
     * @param  ConnectionInterface $con
     * @return boolean
     */
    public function preUpdate(ConnectionInterface $con = null)
    {
                return true;
    }

    /**
     * Code to be run after updating the object in database
     * @param ConnectionInterface $con
     */
    public function postUpdate(ConnectionInterface $con = null)
    {
            }

    /**
     * Code to be run before deleting the object in database
     * @param  ConnectionInterface $con
     * @return boolean
     */
    public function preDelete(ConnectionInterface $con = null)
    {
                return true;
    }

    /**
     * Code to be run after deleting the object in database
     * @param ConnectionInterface $con
     */
    public function postDelete(ConnectionInterface $con = null)
    {
            }


    /**
     * Derived method to catches calls to undefined methods.
     *
     * Provides magic import/export method support (fromXML()/toXML(), fromYAML()/toYAML(), etc.).
     * Allows to define default __call() behavior if you overwrite __call()
     *
     * @param string $name
     * @param mixed  $params
     *
     * @return array|string
     */
    public function __call($name, $params)
    {
        if (0 === strpos($name, 'get')) {
            $virtualColumn = substr($name, 3);
            if ($this->hasVirtualColumn($virtualColumn)) {
                return $this->getVirtualColumn($virtualColumn);
            }

            $virtualColumn = lcfirst($virtualColumn);
            if ($this->hasVirtualColumn($virtualColumn)) {
                return $this->getVirtualColumn($virtualColumn);
            }
        }

        if (0 === strpos($name, 'from')) {
            $format = substr($name, 4);

            return $this->importFrom($format, reset($params));
        }

        if (0 === strpos($name, 'to')) {
            $format = substr($name, 2);
            $includeLazyLoadColumns = isset($params[0]) ? $params[0] : true;

            return $this->exportTo($format, $includeLazyLoadColumns);
        }

        throw new BadMethodCallException(sprintf('Call to undefined method: %s.', $name));
    }

}
