<?php

namespace Mailbox\Infrastructure\Repositories\Helpers;

/**
 * методы помошники для репозитория
 * Trait HelperTrait
 * @package Mailbox\Infrastructure\Repositories
 */
trait FileHelperTrait
{

    /**
     * @param string $translit
     * @return array|string
     */
    private function translit(string $translit)
    {


        $str = array(
            "ё" => "e",
            "й" => "i",
            "ц" => "c",
            "у" => "u",
            "к" => "c",
            "е" => "e",
            "н" => "n",
            "г" => "g",
            "ш" => "sh",
            "щ" => "sh",
            "з" => "z",
            "х" => "h",
            "ъ" => "",
            "ф" => "f",
            "ы" => "i",
            "в" => "v",
            "а" => "a",
            "п" => "p",
            "р" => "r",
            "о" => "o",
            "л" => "l",
            "д" => "d",
            "ж" => "j",
            "э" => "e",
            "я" => "ya",
            "ч" => "ch",
            "с" => "s",
            "м" => "m",
            "и" => "i",
            "т" => "t",
            "ь" => "",
            "б" => "b",
            "ю" => "u",
            "Ё" => "E",
            "Й" => "I",
            "Ц" => "C",
            "У" => "U",
            "К" => "C",
            "Е" => "E",
            "Н" => "N",
            "Г" => "G",
            "Ш" => "SH",
            "Щ" => "SH",
            "З" => "Z",
            "Х" => "H",
            "Ъ" => "",
            "Ф" => "F",
            "Ы" => "I",
            "В" => "V",
            "А" => "A",
            "П" => "P",
            "Р" => "R",
            "О" => "O",
            "Л" => "L",
            "Д" => "D",
            "Ж" => "J",
            "Э" => "E",
            "Я" => "YA",
            "Ч" => "CH",
            "С" => "S",
            "М" => "M",
            "И" => "I",
            "Т" => "T",
            "Ь" => "",
            "Б" => "B",
            "Ю" => "U"
        );

        $str = strtr($translit, $str);

        return $str;
    }

    /**
     * @param string $name
     *
     * @return string
     */
    private function clearFileName(string $name): string
    {
        return trim($name, '"');
    }

    /**
     * поиск части строки по регулярке
     * @param $name
     * @param $rule
     * @return bool
     */
    private function findNameByRule(string $filename, string $rule): bool
    {

        //ini_set('mbstring.internal_encoding', 'utf-8');
        mb_internal_encoding('UTF-8');
        mb_regex_encoding('UTF-8');

        $rule = mb_strtolower($rule);

        $rule_reg = '~(' . $rule . ')~iu';

        //удаление расширения???
//        if (preg_match('~(.*)\..*?$~', $name, $match)) {
//            $filename = mb_strtolower($match[1]);
//        }

        if (preg_match($rule_reg, $filename)) {
            return true;
        }
        return false;
    }


    /**
     * @param string $fileName
     * @return string
     */
    private function normalizeFileName(string $fileName): string
    {
        return strtolower(preg_replace('~[^A-Za-z0-9\.]~', '', $this->translit($fileName)));
    }
}
