<?php

namespace Mailbox\Infrastructure\ImapAdapter;

use Psr\Log\LoggerAwareTrait;
use Zend\Mail\Storage\Exception\RuntimeException;
use Zend\Mail\Storage\Imap as Storage;
use Zend\Mail\Protocol\Imap as Protocol;

/**
 * немного модифицированный Zend\Mail\Storage\Imap
 * Class ImapStorage
 * @package Mailbox\Infrastructure\ImapAdapter
 */
class ImapStorage extends Storage
{
    use LoggerAwareTrait;

    /**
     * @return Protocol
     */
    public function getProtocol(): Protocol
    {
        return $this->protocol;
    }

    /**
     * set flags for message
     *
     * NOTE: this method can't set the recent flag.
     *
     * @param int $id number of message
     * @param array $flags new flags for message
     * @throws RuntimeException
     */
    public function setFlags($id, $flags)
    {
        if (!$this->protocol->store($flags, $id, null, '+')) {
            throw new RuntimeException(
                'cannot set flags, have you tried to set the recent flag or special chars?'
            );
        }
    }

    /**
     * set flags for message
     *
     * NOTE: this method can't set the recent flag.
     *
     * @param int $id number of message
     * @param array $flags new flags for message
     * @throws RuntimeException
     */
    public function unsetFlags(int $id, array $flags): void
    {
        if (!$this->protocol->store($flags, $id, null, '-')) {
            throw new RuntimeException(
                'cannot set flags, have you tried to set the recent flag or special chars?'
            );
        }
    }
}
