<?php

/**
 * Created by PhpStorm.
 * User: d.lanec
 * Date: 21.05.2019
 * Time: 17:18
 */

namespace Mailbox\Domain\Message;

use Repo\Concrete\AbstractCollection;
use Repo\ExportableInterface;

class MessageCollection extends AbstractCollection
{
    /**
     * @return string
     */
    protected function getEntityClass(): string
    {
        return Message::class;
    }

    /**
     * Return an associative array containing all the properties in this object.
     *
     * @return array
     */
    public function toArray(): array
    {

        $new = [];
        $data = get_object_vars($this);

        foreach ($data["_entities"] as $key1 => $d) {
            $dAr = $d->toArray();
            foreach ($dAr as $key => $value) {
                if (is_a($value, ExportableInterface::class)) {
                    $dAr[$key] = $value->toArray();
                } elseif ($key === "fromEmail") {
                    $dAr[$key] = $value->getEmail();
                }
            }

            $new [$key1] = $dAr;
        }

        return $new;
    }
}
