<?php

namespace Mailbox\Application;

use Mailbox\Infrastructure\Repositories\ProtocolConnectionInterface;
use Mailbox\Infrastructure\Repositories\RepositoryCacheInterface;
use Mailbox\Infrastructure\Repositories\RepositoryConfigInterface;

/**
 * Class Config
 * @package Mailbox\Application
 */
class Config implements ProtocolConnectionInterface, RepositoryConfigInterface, RepositoryCacheInterface
{

    /**
     * @todo нужно ли, возможно механизм кеширования нужно реализховтаь через psr cache
     * @var string
     */
    protected $cacheDir;

    protected $attachmentsDir;

    /**
     * @var string
     */
    protected $host;
    /**
     * @var string
     */
    protected $login;
    /**
     * @var string
     */
    protected $password;
    /**
     * @var int
     */
    protected $port = 993;
    /**
     * @var bool
     */
    protected $ssl = true;

    /**
     * @var bool
     */
    protected $useCache = false;

    protected $socketDebug = false;

    /**
     * @var int
     */
    protected $limit = 300;

    /**
     * @return mixed
     */
    public function getAttachmentsDir(): string
    {
        return $this->attachmentsDir;
    }

    /**
     * @param mixed $attachmentsDir
     * @return Config
     */
    public function setAttachmentsDir($attachmentsDir)
    {
        $this->attachmentsDir = $attachmentsDir;
        return $this;
    }


    /**
     * @return bool
     */
    public function isSocketDebug(): bool
    {
        return $this->socketDebug;
    }

    /**
     * @param bool $socketDebug
     * @return Config
     */
    public function setSocketDebug(bool $socketDebug): Config
    {
        $this->socketDebug = $socketDebug;
        return $this;
    }

    /**
     * @return string
     */
    public function getCacheDir(): string
    {
        return $this->cacheDir;
    }

    /**
     * @param string $cacheDir
     * @return Config
     */
    public function setCacheDir(string $cacheDir): Config
    {
        $this->cacheDir = $cacheDir;
        return $this;
    }

    /**
     * @return string
     */
    public function getHost(): string
    {
        return $this->host;
    }

    /**
     * @param string $host
     * @return Config
     */
    public function setHost(string $host): Config
    {
        $this->host = $host;
        return $this;
    }

    /**
     * @return string
     */
    public function getLogin(): string
    {
        return $this->login;
    }

    /**
     * @param string $login
     * @return Config
     */
    public function setLogin(string $login): Config
    {
        $this->login = $login;
        return $this;
    }

    /**
     * @return string
     */
    public function getPassword(): string
    {
        return $this->password;
    }

    /**
     * @param string $password
     * @return Config
     */
    public function setPassword(string $password): Config
    {
        $this->password = $password;
        return $this;
    }

    /**
     * @return int
     */
    public function getPort(): int
    {
        return $this->port;
    }

    /**
     * @param int $port
     * @return Config
     */
    public function setPort(int $port): Config
    {
        $this->port = $port;
        return $this;
    }

    /**
     * @return bool
     */
    public function isSsl(): bool
    {
        return $this->ssl;
    }

    /**
     * @param bool $ssl
     * @return Config
     */
    public function setSsl(bool $ssl): Config
    {
        $this->ssl = $ssl;
        return $this;
    }

    /**
     * @return int
     */
    public function getLimit(): int
    {
        return $this->limit;
    }

    /**
     * @param int $limit
     * @return $this|Config
     */
    public function setLimit(int $limit): self
    {
        $this->limit = $limit;
        return $this;
    }
}
