# MailBox

Функционал для работы с почтовым сервером, поддержка imap (pop2, smtp в планах).

Использует zendframework/zend-mail.

## Как использовать

```php
use Mailbox\Application\Config;
use Mailbox\Application\MailBoxSearchCriteria;
use Mailbox\Application\MailBoxService;
use Mailbox\Application\MessageSearchCriteria;
use Mailbox\Infrastructure\Repositories\MockMessageRepository;

require __DIR__. "/../vendor/autoload.php";

$config
    = (new Config())
    ->setHost("imap.gmail.com")
    ->setLogin("testwapprices@gmail.com")
    ->setPassword("testwapprices123")
    ->setPort(993)
    ->setSsl(true)
    ->setUseCache(true)
    ->setCacheDir(__DIR__."/tmp")
;

$service = new MailBoxService(
  new MockMessageRepository(
      $config
  )
);

//сообщения по фильтру
$messages = $service->getMessagesByCriteria(
    (new MessageSearchCriteria())
        ->setFrom("test@mail.ru")
);

dump($messages);

//сообщение по id
$message = $service->getMessageById(1);

dump($message);

//все папки писем
$folders = $service->getMailBoxesByCriteria(
    (new MailBoxSearchCriteria())
);

dump($folders);

```
## Варианты тестирования

### 1. Пробуем загрузить письмо по критериям поиска
1. запускаем docker-compose up -d & docker-compose run codetools
2. далее настраиваем в index.php следующе строки, раскоментировать: dump($service->getMessagesByCriteria($criteria));
3. настройка конфига для теста config.php - указываем нужные параметры подключения и поиска письма
4. запускаем php ./sandbox/index.php
5. Смотрим результат в консоли, или в файле отладки  php ./sandbox/index.php > debug.txt

### 2. Пробуем загрузить письмо по id - порядковый номер
1. Пункты 1-5 аналогичные как и в обычном поске
2. В index.php следующе строки, раскоментировать: dump($service->getMessageById(687));

### 3. Как тестировать без подключения к сервису
1. Предварительно почистить кеш каталогов sandbox/attachment и sandbox/cache
2. Выполнить получение по id
3. Посмотреть создавшийся файлы в кеше и найти кеш письма  sandbox/cache/...
4. Переместить файл в каталог tests/mails/ и назвать корректно *.eml
5. Открыть файл и убрать лишние символы которые использовались движком кеша, проверить можно открыв файл через MS Outlook
6. Раксоментировать строчку в index.php //include_once 'protocol_stub.php'; и указать в файле нужное тестовое письмо

### 4. Как писать Unit tests
1. Делаем все тоже самое что и в п.3 
2. Открываем файл теста /tests/src/Application/MailBoxServiceTest.php
3. Создаем метод в котором покрываем тестом нужно письмо