<?php

namespace Mailbox\Infrastructure\Repositories\Helpers;

trait StringHelperTrait
{
    /**
     * Получение отправителя и его имени из строки.
     *
     * @param string $value
     *
     * @return array
     */
    private static function toAddressee(string $value): array
    {
        $fromName = null;
        $from = $value;

        if (preg_match("~(.+?) <(.+@.+\..+)>~is", $value, $matches)) {
            [, $fromName, $from] = $matches;
        } elseif (preg_match("~<(.+@.+\..+)>~is", $value, $matches)) {
            [, $from] = $matches;
        }

        return [
            'fromName' => $fromName,
            'from' => $from,
        ];
    }
}
