<?php

namespace Mailbox\Infrastructure\Repositories\Helpers;

trait SocketTimeoutTrait
{

    /**
     * @var int
     */
    private $defaultTimeout = 60;

    /**
     * SocketTimeoutController constructor.
     */
    public function __construct()
    {
        $configurationValue = (int)ini_get('default_socket_timeout');

        if (!empty($configurationValue)) {
            $this->defaultTimeout = $configurationValue;
        }
    }

    /**
     * @param int $seconds
     *
     * @return bool
     */
    public function setTimeout(int $seconds): bool
    {
        return ini_set('default_socket_timeout', $seconds) !== false;
    }

    /**
     * @return bool
     */
    public function setDefaultTimeout(): bool
    {
        return ini_set('default_socket_timeout', $this->defaultTimeout) !== false;
    }
}
