<?php

namespace Mailbox\Domain\Message\Contracts;

use Mailbox\Domain\MailBox\Contracts\MailBoxCriteriaInterface;
use Mailbox\Domain\MailBox\MailBox;
use Mailbox\Domain\MailBox\MailBoxCollection;
use Mailbox\Domain\Message\Message;
use Mailbox\Domain\Message\MessageCollection;

interface MessageRepositoryInterface
{

    /**
     * @param int $id
     * @return Message|null
     */
    public function findById(int $id): ?Message;

    /**
     * @param MessageCriteriaInterface $criteria
     * @return MessageCollection
     */
    public function findByCriteria(MessageCriteriaInterface $criteria): MessageCollection;

    /**
     * @param MailBoxCriteriaInterface $criteria
     * @return MailBoxCollection
     */
    public function findMailBoxesByCriteria(MailBoxCriteriaInterface $criteria): MailBoxCollection;

    /**
     * @param Message $message
     * @param MailBox $mailBox
     */
    public function moveMessage(Message $message, MailBox $mailBox): void;
}
