<?php

namespace Mailbox\Domain\Attachment;

use Repo\Concrete\AbstractEntity;

class Attachment extends AbstractEntity
{


    /**
     * Уникальный номер сообщения
     * @var int
     */
    protected $messageKey;

    /**
     * Порядковый номер сообщения в массиве.
     * @var
     */
    protected $messageId;

    /**
     * @var string
     */
    protected $fileName;
    /**
     * @var null|string
     */
    protected $filePath;

    /**
     * Attachment constructor.
     *
     * @param string $fileName
     */
    public function __construct(string $fileName)
    {
        $this->fileName = $fileName;
    }


    /**
     * @return int
     */
    public function getMessageKey(): string
    {
        return $this->messageKey;
    }

    /**
     * @return mixed
     */
    public function getMessageId()
    {
        return $this->messageId;
    }

    /**
     * @param mixed $messageId
     * @return Attachment
     */
    public function setMessageId($messageId)
    {
        $this->messageId = $messageId;
        return $this;
    }




    /**
     * @param int $messageKey
     */
    public function setMessageKey(string $messageKey)
    {
        $this->messageKey = $messageKey;
        return $this;
    }

    /**
     * @return string
     */
    public function getFileName(): string
    {
        return $this->fileName;
    }

    /**
     * @return null|string
     */
    public function getFilePath(): ?string
    {
        return $this->filePath;
    }

    /**
     * @param null|string $filePath
     */
    public function setFilePath(?string $filePath)
    {
        $this->filePath = $filePath;
        return $this;
    }
}
