<?php

use Mailbox\Application\MailBoxService;
use Mailbox\Infrastructure\Repositories\ImapMessageRepository;
use Monolog\Logger;
use Monolog\Handler\StreamHandler;
use Monolog\Formatter\LineFormatter;

// create a log channel
require __DIR__ . "/../vendor/autoload.php";

$log = new Logger('name');
$outputStream = new StreamHandler('php://stdout', Logger::DEBUG);
$fileStream = new StreamHandler('php://stdout', Logger::ERROR);
//new StreamHandler(__DIR__ . '/errors/' . date('Y-m-d') . '_errors.log', Logger::ERROR);

//formatter
$formatter = new LineFormatter(
    "%datetime% > %level_name% > %message% %context% %extra%\n",
    'Y-m-d H:i:s'
);

$outputStream->setFormatter($formatter);
$fileStream->setFormatter($formatter);

$log->pushHandler($outputStream);
$log->pushHandler($fileStream);

include_once 'config.php';

$config
    ->setCacheDir(__DIR__ . '/cache')//каталог кеша
    ->setAttachmentsDir(__DIR__ . '/attachments')//каталог для вложений
    ->setSocketDebug(true) # выволит в лог результаты и запросы идущее напрямую на сервер через сокет
;

$protocol = new \Mailbox\Infrastructure\ProtocolAdapter\ZendProtocol(
    $config
);

//include_once 'protocol_stub.php';


$repo = new ImapMessageRepository($protocol, $config);
$repo->setLogger($log);

$service = new MailBoxService($repo);
$service->setLogger($log);

dump($service->getMailBoxesByCriteria(
    (new Mailbox\Application\MailBoxSearchCriteria)->setFilterById('prices|autowest')
));
//dump($service->getMessageById(79145));

dump($service->getMessagesByCriteria($criteria));
