<?php

namespace Mailbox\Infrastructure\Repositories;

use Mailbox\Application\Config;
use Mailbox\Domain\MailBox\MailBox;
use Mailbox\Domain\MailBox\MailBoxCollection;
use Mailbox\Domain\MailBox\Contracts\MailBoxCriteriaInterface;
use Mailbox\Domain\Message\Contracts\MessageCriteriaInterface;
use Mailbox\Domain\Message\Contracts\MessageRepositoryInterface;
use Mailbox\Domain\Message\Message;
use Mailbox\Domain\Message\MessageCollection;

/**
 * репозиторий работающий с тестовыми данными
 * Class MockMessageRepository
 * @package Mailbox\Infrastructure\Repositories
 */
class MockMessageRepository implements MessageRepositoryInterface
{

    /**
     * @var Config
     */
    protected $config;

    /**
     * MockMessageRepository constructor.
     * @param Config $config
     */
    public function __construct(Config $config)
    {
        $this->config = $config;
    }

    public function moveMessage(Message $message, MailBox $mailBox): void
    {
        // TODO: Implement moveMessage() method.
    }


    /**
     * @param int $id
     * @return Message|null
     * @throws \Exception
     */
    public function findById(int $id): ?Message
    {
        $messages = self::buildMessageCollection();

        foreach ($messages as $message) {
            if ($message->getId() === $id) {
                return $message;
            }
        }

        return null;
    }

    /**
     * @param MessageCriteriaInterface $criteria
     * @return MessageCollection
     * @throws \Exception
     */
    public function findByCriteria(MessageCriteriaInterface $criteria): MessageCollection
    {
        $messages =  self::buildMessageCollection();

        foreach ($messages as $message) {

            /**
             * @var Message $message
             */
            //filter
            if (!empty($criteria->getFrom()) && $message->getFromEmail() !== $criteria->getFrom()) {
                $messages->offsetUnset($message);
            }
        }

        return $messages;
    }

    /**
     * @return MessageCollection
     * @throws \Exception
     */
    public static function buildMessageCollection(): MessageCollection
    {
        return (new MessageCollection())
            ->push(
                (new Message())
                    ->setId(1)
                    ->setDateTime(new \DateTime())
                    ->setFromEmail("dim@lanets.tw1.ru")
                    ->setSubject("Привет мир")
                    ->setMailBox(
                        new MailBox("Входящие")
                    )
            )
            ->push(
                (new Message())
                    ->setId(2)
                    ->setDateTime(new \DateTime())
                    ->setFromEmail("test@mail.ru")
                    ->setSubject("Тестовое письмо")
                    ->setMailBox(
                        new MailBox("Спам")
                    )
            );
    }

    /**
     * @param MailBoxCriteriaInterface $criteria
     * @return MailBoxCollection
     */
    public function findMailBoxesByCriteria(MailBoxCriteriaInterface $criteria): MailBoxCollection
    {
        return (new MailBoxCollection())
            ->push(
                new MailBox("Входящие")
            )
            ->push(
                new MailBox("Спам")
            )
            ;
    }
}
