<?php

namespace Mailbox\Infrastructure\Repositories\Helpers;

trait StringHelperTrait
{
    /**
     * Получение отправителя и его имени из строки.
     *
     * @param string $value
     *
     * @return array
     */
    private static function toAddressee(string $value): array
    {
        if (preg_match("~(.+?) <(.+@.+\..+)>~", $value, $matches)) {
            [, $fromName, $from] = $matches;
        } else {
            $fromName = null;
            $from = $value;
        }

        return [
            'fromName' => $fromName,
            'from' => $from,
        ];
    }
}
