<?php

namespace Mailbox\Infrastructure\Repositories;

use Psr\Log\LoggerAwareInterface;

interface ProtocolInterface extends LoggerAwareInterface
{
    public function getRawHeaderById(int $id): string;

    public function getRawContentById(int $id): string;

    public function getRawContentByUid(int $uid): string;

    public function getUidById(int $id): int;

    public function getCurrentFolder(): string;

    public function selectFolder(string $folder): array;

    public function getFolders($rootFolder = null): array;

    public function setFlags(int $messageNumber, array $flags): void;

    public function unsetFlags(int $messageNumber, array $flags): void;

    public function countMessages(): int;

    public function noop(): void;

    public function moveMessage(int $id, string $folder): void;
}
