<?php

/**
 * Created by PhpStorm.
 * User: d.lanec
 * Date: 21.05.2019
 * Time: 17:18
 */

namespace Mailbox\Domain\Message;

use Mailbox\Domain\Attachment\AttachmentCollection;
use Mailbox\Domain\MailBox\MailBox;
use Mailbox\Domain\Message\VolueObject\From;
use Repo\Concrete\AbstractEntity;

class Message extends AbstractEntity
{

    /**
     * @var int|null
     */
    protected $uid;

    /**
     * @var string
     */
    protected $messageId;

    /**
     * @var string
     */
    protected $subject;


    /**
     * @var \DateTime
     */
    protected $dateTime;

    /**
     * @var From
     */
    protected $fromEmail;

    /**
     * @var MailBox
     */
    protected $mailBox;

    /**
     * @var bool
     */
    protected $flagSeen;

    /**
     * @var string|null
     */
    protected $body;

    /**
     * @var AttachmentCollection
     */
    protected $attachmentCollection;

    public function __construct()
    {
        $this->attachmentCollection = new AttachmentCollection();
    }

    /**
     * @return string|null
     */
    public function getBody(): ?string
    {
        return $this->body;
    }

    /**
     * @param string|null $body
     * @return Message
     */
    public function setBody(?string $body): Message
    {
        $this->body = $body;
        return $this;
    }


    /**
     * @return int|null
     */
    public function getUid(): ?int
    {
        return $this->uid;
    }

    /**
     * @param int|null $uid
     * @return Message
     */
    public function setUid(?int $uid): Message
    {
        $this->uid = $uid;
        return $this;
    }


    /**
     * @return string
     */
    public function getMessageId(): string
    {
        return $this->messageId;
    }

    /**
     * @param string $messageId
     * @return Message
     */
    public function setMessageId(string $messageId): Message
    {
        $this->messageId = $messageId;
        return $this;
    }


    /**
     * @return MailBox
     */
    public function getMailBox(): MailBox
    {
        return $this->mailBox;
    }

    /**
     * @return bool
     */
    public function isFlagSeen(): bool
    {
        return $this->flagSeen;
    }

    /**
     * @param bool $flagSeen
     * @return Message
     */
    public function setFlagSeen(bool $flagSeen): Message
    {
        $this->flagSeen = $flagSeen;
        return $this;
    }


    /**
     * @param MailBox $mailBox
     * @return Message
     */
    public function setMailBox(MailBox $mailBox): Message
    {
        $this->mailBox = $mailBox;
        return $this;
    }


    /**
     * @return string
     */
    public function getSubject(): ?string
    {
        return $this->subject;
    }

    /**
     * @param string $subject
     * @return Message
     */
    public function setSubject(string $subject): Message
    {
        $this->subject = $subject;
        return $this;
    }

    /**
     * @return \DateTime
     */
    public function getDateTime(): \DateTime
    {
        return $this->dateTime;
    }

    /**
     * @param \DateTime $dateTime
     * @return Message
     */
    public function setDateTime(\DateTime $dateTime): Message
    {
        $this->dateTime = $dateTime;
        return $this;
    }

    /**
     * @return string
     */
    public function getFromEmail(): From
    {
        return $this->fromEmail;
    }

    /**
     * @param string $fromEmail
     * @return Message
     */
    public function setFromEmail(From $fromEmail): Message
    {
        $this->fromEmail = $fromEmail;
        return $this;
    }

    /**
     * @return AttachmentCollection
     */
    public function getAttachmentCollection(): AttachmentCollection
    {
        return $this->attachmentCollection;
    }

    /**
     * @param AttachmentCollection $attachmentColllection
     * @return Message
     */
    public function setAttachmentCollection(AttachmentCollection $attachmentColllection): Message
    {
        $this->attachmentCollection = $attachmentColllection;
        return $this;
    }
}
