<?php

namespace Mailbox\Application\Exceptions;

use Mailbox\Application\MailBoxException;
use Throwable;

class MessageNotFound extends MailBoxException
{

    protected $id;

    public function __construct(string $id, $uid = false)
    {
        parent::__construct(sprintf("message %s `%s` not found", (!$uid ? "id" : "uid"), $id));
        $this->id = $id;
    }

    /**
     * @return string
     */
    public function getId(): string
    {
        return $this->id;
    }
}
