<?php

namespace Mailbox\Infrastructure\ProtocolAdapter;

use Mailbox\Infrastructure\Repositories\ProtocolInterface;
use Psr\Log\LoggerAwareTrait;

class TestProtocol implements ProtocolInterface
{
    use LoggerAwareTrait;

    protected $testMailPath;
    protected $testHeaderPath;


    public function __construct(string $testMailPath, string $testHeaderPath = null)
    {
        if ($testHeaderPath === null) {
            $testHeaderPath = $testMailPath;
        }

        if (!file_exists($testMailPath)) {
            throw new ProtocolException('mail path not found');
        }
        if (!file_exists($testHeaderPath)) {
            throw new ProtocolException('header mail path not found');
        }
        $this->testMailPath = $testMailPath;
        $this->testHeaderPath = $testHeaderPath;
    }

    public function unsetFlags(int $messageNumber, array $flags): void
    {
        // TODO: Implement unsetFlags() method.
    }

    public function getRawContentById(int $id): string
    {
        return file_get_contents($this->testMailPath);
    }

    public function getRawContentByUid(int $uid): string
    {
        return file_get_contents($this->testMailPath);
    }

    public function getUidById(int $id): int
    {
        return 1;
    }

    public function getCurrentFolder(): string
    {
        return 'INBOX';
    }

    public function selectFolder(string $folder): array
    {
        // TODO: Implement selectFolder() method.
        return [
            'flags' => [
                [
                    "\Answered",
                    "\Flagged",
                    "\Deleted",
                    "\Draft",
                    "\Seen"
                ]
            ],
            'exists' => '79143',
            'recent' => '0',
            'uidvalidity' => 1431958381,
        ];
    }

    public function getFolders($rootFolder = null): array
    {
        //phpcs:disable
        return unserialize('a:5:{s:5:"INBOX";a:2:{s:5:"delim";s:1:"/";s:5:"flags";a:1:{i:0;s:6:"\Inbox";}}s:13:"&BCEEPwQwBDw-";a:2:{s:5:"delim";s:1:"/";s:5:"flags";a:1:{i:0;s:5:"\Spam";}}s:34:"&BB4EQgQ,BEAEMAQyBDsENQQ9BD0ESwQ1-";a:2:{s:5:"delim";s:1:"/";s:5:"flags";a:1:{i:0;s:5:"\Sent";}}s:26:"&BCcENQRABD0EPgQyBDgEOgQ4-";a:2:{s:5:"delim";s:1:"/";s:5:"flags";a:1:{i:0;s:7:"\Drafts";}}s:21:"&BBoEPgRABDcEOAQ9BDA-";a:2:{s:5:"delim";s:1:"/";s:5:"flags";a:1:{i:0;s:6:"\Trash";}}}');
        //phpcs:enable
    }

    public function setFlags(int $messageNumber, array $flags): void
    {
        // TODO: Implement setFlags() method.
    }

    public function countMessages(): int
    {
        return 1;
    }

    public function noop(): void
    {
        // TODO: Implement noop() method.
    }

    public function moveMessage(int $id, string $folder): void
    {
        // TODO: Implement moveMessage() method.
    }

    public function getRawHeaderById(int $id): string
    {
        return file_get_contents($this->testHeaderPath);
    }
}
