<?php

namespace Mailbox\Domain\Message\Contracts;

use Repo\RepositoryCriteriaInterface;

interface MessageCriteriaInterface extends RepositoryCriteriaInterface
{

    public function getLimit(): int;

    /**
     * @return array|null
     */
    public function getFilterByFromEmails(): ?array;

    /**
     * @return string|null
     */
    public function getFilterByFromEmail(): ?string;

    /**
     * @return string|null
     */
    public function getFilterByMailBoxName(): ?string;

    /**
     * @return string|null
     */
    public function getSearchBySubject(): ?string;

    /**
     * @return \DateTime|null
     */
    public function getFilterByDatetimeFrom(): ?\DateTime;

    /**
     * @return \DateTime|null
     */
    public function getFilterByDatetimeTo(): ?\DateTime;

    /**
     * помечать прочтенным если письмо найдено
     * @return bool
     */
    public function isMarkSeenIfFound(): bool;

    /**
     * фильтр по уникальному uid
     * @return int|null
     */
    public function getFilterByUid(): ?int;


    /**
     * @return int|null
     */
    public function getFilterById(): ?int;
}
