<?php

namespace Mailbox\Application\Exceptions;

use Mailbox\Application\MailBoxException;
use Throwable;

class MailBoxNotFound extends MailBoxException
{

    /**
     * @var string
     */
    protected $name;

    public function __construct(string $name)
    {
        parent::__construct(sprintf(
            "mailbox `%s` no found",
            $name
        ));
    }

    /**
     * @return mixed
     */
    public function getName(): string
    {
        return $this->name;
    }
}
