<?php

namespace Mailbox\Domain\Message\VolueObject;

class From
{

    /**
     * @var string
     */
    protected $email;

    /**
     * @var string|null
     */
    protected $name;

    public function __construct(string $email, ?string $name)
    {
        $this->name = $name;
        $this->email = $email;
    }

    /**
     * @return string
     */
    public function getEmail(): string
    {
        return $this->email;
    }

    /**
     * @param string $email
     * @return From
     */
    public function setEmail(string $email): From
    {
        $this->email = $email;
        return $this;
    }

    /**
     * @return string
     */
    public function getName(): ?string
    {
        return $this->name;
    }

    /**
     * @param string $name
     * @return From
     */
    public function setName(?string $name): From
    {
        $this->name = $name;
        return $this;
    }
}
