<?php

namespace Mailbox\Application;

use Mailbox\Domain\MailBox\Contracts\MailBoxCriteriaInterface;

/**
 *
 * Class SearchCriteria
 * @package Mailbox\Application
 */
final class MailBoxSearchCriteria implements MailBoxCriteriaInterface
{

    /**
     * @var string|null
     */
    protected $filterByName;

    /**
     * @var string|null
     */
    protected $filterById;

    /**
     * @return mixed
     */
    public function getFilterByName(): ?string
    {
        return $this->filterByName;
    }

    /**
     * @param mixed $filterByName
     * @return MailBoxSearchCriteria
     */
    public function setFilterByName(string $filterByName)
    {
        $this->filterByName = $filterByName;
        return $this;
    }

    /**
     * @return mixed
     */
    public function getFilterById(): ?string
    {
        return $this->filterById;
    }

    /**
     * @param string|null $filterById
     * @return $this
     */
    public function setFilterById(?string $filterById)
    {
        $this->filterById = $filterById;
        return $this;
    }
}
