<?php
/**
 * Created by PhpStorm.
 * User: Admin
 * Date: 15.08.2020
 * Time: 12:13
 */

namespace DiamondTable;


use Symfony\Component\Validator\Constraints;

class ValidatorFactory
{

    /**
     * @param array $rules
     * @return array
     */
    public static function build(array $rules): array
    {

        $correct_rules = [];


        foreach ($rules as $rule => $callable) {

            $ruleName = is_callable($callable)?$rule:$callable;

            switch ($ruleName) {
                case 'required':

                    $rule = new Constraints\NotBlank();
                    $rule->message = 'поле не должно быть пустым.';
                    $correct_rules [] = $rule;

                    break;

                case 'email':
                case 'mail':
                    $rule = new Constraints\Email();
                    $rule->message = 'это значение не является действительным адресом электронной почты';
                    $correct_rules [] = $rule;

                    break;

                case 'captcha':

                    $rule = new \Core\Form\Constraints\Captcha($Field);
                    //$rule->message    = "поле не должно быть пустым.";
                    $correct_rules [] = $rule;

                    break;

                case 'recaptcha':

                    $rule = new \Core\Form\Constraints\ReCaptcha($Field);
                    $correct_rules [] = $rule;

                    break;


                default:

                    $rule = new \Core\Form\Constraints\Custom($callable);
                    $correct_rules [] = $rule;

                    break;
            }
        }


        return $correct_rules;
    }

}