<?php
/**
 * Created by PhpStorm.
 * User: Admin
 * Date: 20.08.2020
 * Time: 12:01
 */

namespace DiamondTable;


use Core\Form\Control\Checkbox;
use Repo\EntityInterface;

final class ControlFactory
{

    /**
     * @param EntityInterface $entity
     * @return string
     */
    public function buildCheckbox(EntityInterface $entity): string
    {
        $name = 'check' . $entity->getId();
        return
                (new Checkbox($name,$entity->getId()))
                ->setClass('magic-checkbox select-row-check')
                ->setId($name)
                ->setSingle(true)
                ->setChecked((int)input_get($name)===$entity->getId())
                ->render() .'<label for="check' . $entity->getId() . '"></label>';
    }

}