<?php
/**
 * Created by PhpStorm.
 * User: Admin
 * Date: 19.08.2020
 * Time: 23:11
 */

namespace DiamondTable;


use Psr\Http\Message\ServerRequestInterface;
use Repo\PaginationInterface;
use Symfony\Component\HttpFoundation\Session\Session;

class SearchCriteriaBuilder
{

    protected static $defaultRows = 10;
    protected static $defaultPage = 1;
    protected static $useSessionRows = true;

    protected const PAGINATION_NAME_ROWS = 'rows';
    protected const PAGINATION_NAME_PAGE = 'page';
    protected const PAGINATION_NAME_SEARCH = 'search';
    protected const PAGINATION_NAME_FILTER = 'filter';
    protected const PAGINATION_NAME_SORT = 'sort';
    protected const PAGINATION_NAME_ID = 'id';

    /**
     * @param ServerRequestInterface $request
     * @param PaginationInterface $criteria
     * @return PaginationInterface
     * @throws \ReflectionException
     */
    public static function buildFromRequest(ServerRequestInterface $request, PaginationInterface $criteria): PaginationInterface
    {
        $getQuery = $request->getQueryParams();

        $getQuery = array_change_key_case($getQuery);

        $session = new Session();

        if($criteria->getLimit() > 0 ){
            $setRows = $criteria->getLimit();
        }
        elseif (isset($getQuery[static::PAGINATION_NAME_ROWS]) && $getQuery[static::PAGINATION_NAME_ROWS] > 0) {
            $setRows = $getQuery[static::PAGINATION_NAME_ROWS];
            $session->set('table-rows', $setRows);
        } elseif (static::$useSessionRows === true && $session->get('table-rows') > 0) {
            $setRows = $session->get('table-rows');
        } else {
            $setRows = static::$defaultRows;
        }

        $criteria->setLimit((int)$setRows);
        $criteria->setPage((int)(isset($getQuery[static::PAGINATION_NAME_PAGE]) && $getQuery[static::PAGINATION_NAME_PAGE] > 0 ? $getQuery[static::PAGINATION_NAME_PAGE] : static::$defaultPage));
        $criteria->setFilterById($getQuery[static::PAGINATION_NAME_ID] ?? null);

        foreach ($getQuery as $name => $param) {
            if (stripos($name, static::PAGINATION_NAME_SEARCH) !== false ||
                stripos($name, static::PAGINATION_NAME_FILTER) !== false ||
                stripos($name, static::PAGINATION_NAME_SORT) !== false
            ) {
                $method = 'set' . str_replace('_', '', $name);

                if (method_exists($criteria, $method)) {

                    $classRef = new \ReflectionClass($criteria);
                    $paramRef = $classRef->getMethod($method)->getParameters();

                    if (isset($paramRef[0]) && $paramRef[0]->getType() &&
                        $paramRef[0]->getType()->getName() === 'bool' && in_array(strtoupper($param), ['Y', 'N'])) {
                        $param = strtoupper($param) === 'Y';
                    }

                    if($param===''){
                        continue;
                    }

                    if (isset($paramRef[0]) && $paramRef[0]->getType() &&
                        $paramRef[0]->getType()->getName() === 'int') {
                        $criteria->$method((int)$param);
                    }
                    else{
                        $criteria->$method(trim($param));
                    }

                }
            }
        }

        return $criteria;
    }

}