<?php
/**
 * Created by PhpStorm.
 * User: Admin
 * Date: 19.08.2020
 * Time: 22:39
 */

namespace DiamondTable\Commands;


use ActiveTable\ColumnTable;
use ActiveTable\Contracts\CommandInterface;
use ActiveTable\DataTableEngine;
use Core\Form\Control\Button;
use Core\Form\Control\Hidden;
use Core\Form\Control\Input;
use Core\Helpers\Text;
use Diamond\Helpers\Url;
use DiamondTable\ControlFactory;
use Psr\Log\LoggerAwareInterface;
use Psr\Log\LoggerAwareTrait;
use Psr\Log\NullLogger;
use Repo\EntityInterface;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Session\Session;

class TableView implements CommandInterface, LoggerAwareInterface
{
    use LoggerAwareTrait;

    protected $engine;
    protected $summary;
    protected $defaultRows;
    protected $listRows = [10, 25, 50, 100, 200, 500];
    protected $addButtonTitle;

    public function __construct(DataTableEngine $tableEngine, string $addButtonTitle)
    {
        $this->engine = $tableEngine;
        $this->logger = new NullLogger();
        $this->defaultRows = $this->listRows[1];
        $this->addButtonTitle = $addButtonTitle;
    }

    /**
     * main process
     */
    public function process(): void
    {

        $this->prepareTableControls();

        $this->engine->addContent($this->buildMessages());

        $this->engine->addContent($this->buildTopControls());

        $this->engine->addContent($this->buildTable());

        $this->engine->addContent($this->buildPagination(false,false));
    }

    private function prepareTableControls(): void
    {
        $controlFactory = new ControlFactory();

        /** @var ColumnTable $column */
        foreach ($this->engine->getColumns() as $column) {
            if ($column->isExported() === true) {
                $this->engine->addControlAccess(DataTableEngine::CONTROL_ACCESS_EXPORT);
                break;
            }
        }

        if ($this->engine->hasControlAccess(DataTableEngine::CONTROL_ROWS_SELECT) ||
            $this->engine->hasControlAccess(DataTableEngine::CONTROL_ACCESS_DELETE)) {
            $this->engine->addFirstColumn(
                (new ColumnTable('check', '<input id="check-all-head" class="checkall magic-checkbox" type="checkbox"><label for="check-all-head"></label>'))
                    ->setWidth(40)
                    ->setClass('text-center')
                    ->setFormat($controlFactory, 'buildCheckbox')
            );
        }

        if ($this->engine->hasControlAccess(DataTableEngine::CONTROL_ACCESS_ADD)) {
            $this->engine
                ->addButton(
                    (new Button('add', '<i class="demo-pli-add"></i>' . nbs() . $this->addButtonTitle))
                        ->setClass('btn btn-info')
                        ->setType('button')
                        ->setOnClick("location.href='" . adaptive_url(['fn' => 'add']) . "'")
                );
        }

        if ($this->engine->hasControlAccess(DataTableEngine::CONTROL_ACCESS_DELETE)) {
            $this->engine
                ->addButton(
                    (new Button('delete', '<i class="demo-pli-recycling"></i>'))
                        ->setClass('btn btn-danger')
                        ->setType('button')
                        ->setOnClick("action_rows('" . $this->engine->getName() . "','rows_delete','Действительно удалить записи?')")
                );
        }

        if ($this->engine->hasControlAccess(DataTableEngine::CONTROL_ACCESS_EXPORT)) {
            $this->engine
                ->addButton(
                    (new Button('delete', '<i class="demo-pli-file-excel"></i>'))
                        ->setClass('btn btn-default')
                        ->setType('button')
                        ->setOnClick("action_rows('" . $this->engine->getName() . "','rows_export','Экспортировать в Excel?')")
                );
        }

    }

    /**
     * @return string
     */
    private function buildMessages(): string
    {
        $session = new Session();
        $noticeses = $session->getFlashBag()->get('table-notice');
        if (is_array($noticeses)) {
            return implode('', $noticeses);
        }
        return '';
    }

    /**
     * @return string
     */
    private function buildTopControls(): string
    {
        $html = '';

        foreach ($this->engine->getButtons() as $button) {
            if ($this->engine->hasControlAccess($button->getName())) {
                $html .= $button->render();
            }
        }

        $globalControls = '';

        $queryParams = $this->engine->getRequest()->getQueryParams();
        $session = new Session();
        $rowsValue = $queryParams['rows'] ?? null;
        $rowsValue = $session->get('table-rows') ?? $rowsValue;


        if ($this->engine->hasControlAccess(DataTableEngine::CONTROL_FILTER_BUTTON)
            && count($this->engine->getFilters())
        ) {

            $forIgnore = [];
            $queryData = $this->engine->getRequest()->getQueryParams();
            $filters = $this->engine->getFilters();
            foreach ($filters as $filter) {
                $filterName = $filter->getControl()->getName();
                unset($queryData[$filterName]);
                $forIgnore[] = $filterName;
            }

            $globalControls .=
                '<span class="filter-controls ' . (isset($queryParams['filter']) ? '' : 'hidden') . '"><button form="search-' . $this->engine->getName() . '" value="1" type="submit" name="filter" class="btn btn-mint mr-1"><i class="demo-pli-magnifi-glass"></i> Найти</button>' .
                '<button form="search-' . $this->engine->getName() . '" onclick="location.href=\'' . adaptive_url(['filter' => 1], $forIgnore) . '\'" type="button" class="btn btn-default">Очистить</button>' .
                '</span><button onclick="filter_show(this)" class="btn ' .
                (isset($queryParams['filter']) ? 'btn-warning' : 'btn-default') .
                '"><i class="fa fa-filter"></i></button>';
        }


        if ($this->engine->hasControlAccess(DataTableEngine::CONTROL_ROWS_SELECT)) {
            $allRows = array_combine(array_values($this->listRows), $this->listRows);

            $rowsValue = $rowsValue ?? $allRows[array_key_first($allRows)];

            $globalControls .= '<button data-toggle="dropdown" class="btn btn-default dropdown-toggle">' . $rowsValue .
                '<span class="caret"></span></button><ul role="menu" class="dropdown-menu dropdown-menu-right">';

            foreach ($allRows as $row) {
                $globalControls .= '<li><a href="' . adaptive_url(['rows' => $row]) . '">' . $row . '</a></li>';
            }
            $globalControls .= '</ul>';
        }

        if ($this->engine->hasControlAccess(DataTableEngine::CONTROL_ROWS_ACTION) && count($this->engine->getRowActions())) {

            $html .= '<div class="btn-group "><button data-toggle="dropdown" class="btn btn-default dropdown-toggle">
					                                <i class="demo-pli-gear"></i>
					                                <span class="caret"></span>
					                            </button>
					                            <ul role="menu" class="dropdown-menu dropdown-menu-right">';

            foreach ($this->engine->getRowActions() as $action) {
                $html .= '<li><a href="#" onclick="action_rows(\'' . $this->engine->getName() . '\',\'' . $action->getControl()->getName() . '\')">' .
                    $action->getCaption() . '</a></li>';
            }

            $html .= '</ul></div>';

            //          $globalControls .= '<select name="actiontype" class="radius3"><option value="">-выберите действие-</option>';

            //  foreach ($this->engine->getRowActions() as $action) {
            //      $globalControls .= sprintf(
            //          '<option value="%s">%s</option>',
            //          $action->getControl()->getName(),
            //          $action->getCaption()
            //      );
            //  }

            //  $globalControls .= '</select>' . $this->renderActionButtons();
            //} elseif ($globalControls) {
            //    $globalControls .= '<input name="actiontype" type="hidden">' . $this->renderActionButtons();
        }

        $buttonsHtml = $this->renderActionButtons();

        if ($html > '' || $buttonsHtml > '' || $globalControls > '') {
            $header =
                '<div class="col-sm-6 table-toolbar-left"><form id="action-' . $this->engine->getName() .
                '" class="diamond-table-action" method="post" name="action-selected-rows">' . $html . $buttonsHtml .
                '<input  type="hidden" name="ids" /><input  name="actiontype" type="hidden"></form>' .
                '</div>';
            return '<div class="row">' . $header .
                '<div class="col-sm-6 table-toolbar-right"><div class="btn-group">' .
                $this->buildPagination(true) . $globalControls .
                '</div></div></div>';
        } else {
            return '';
        }
    }

    /**
     * @return string
     */
    private function renderActionButtons(): string
    {
        $s = '';
        foreach ($this->engine->getActionButtons() as $button) {

            if ($button->getName() === 'action_global' && $this->engine->hasControlAccess(DataTableEngine::CONTROL_ROWS_ACTION) === false) {
                continue;
            }

            $s .= $button->render();
        }

        //dd($this->engine->getActionButtons());
        //$s = '<button name="action_global" type="submit" class="radius3">Применить</button>';
        return $s;
    }

    protected array $cache = [];

    /**
     * @return string
     */
    private function buildPagination(bool $onlyPagination = false, bool $topNav = true): string
    {
        $info = $nav = $controls = '';

        if ($this->engine->hasControlAccess(DataTableEngine::CONTROL_PAGINATION)) {
            $criteria = $this->engine->getCriteria();

            $key = md5(serialize($criteria));

            //внутренний кеш
            if(isset($this->cache[$key])){
                $count = $this->cache[$key];
            }
            else{
                $count = $this->engine->getRepo()->count($criteria);
                $this->cache[$key] = $count;
            }

            $page = $this->engine->getCriteria()->getPage();

            $limit = $this->engine->getCriteria()->getLimit();

            while (true) {

                if ($page > 1 && $count < $page * $limit && $count < $limit) {
                    $page--;
                    continue;
                }

                break;
            }

            // кол-во на странице
            $limit = $limit > $count ? $count : $limit;

            //кол-во страниц
            $allPages = $count > $limit ? (int)ceil($count / $limit) : 1;

            //текущая страница
            $page = $page < 0 ? 1 : $page;

            //показано записей
            $offset = $page * $limit;
            $offset = $offset > $count ? $count : $offset;

            $from = ($offset - $limit + 1);
            $to = ($offset > $count ? $count : $offset);

            // dump($from,$to,$count,$offset);

            if ($from === 1 && $to === $count) {
                $view = $to . ' запис' . Text::morph($count, 'ь', 'и', 'ей');
            } else {
                $view = $from . '-' . $to . ' из ' . $count . ' запис' . Text::morph($count, 'ь', 'ей', 'ей');
            }


            $info = 'Показан' . Text::morph($to, 'а', 'о', 'о') . ' ' . $view;

            if ($page > 1) {
                $bback = '<li>' . Url::anchor(adaptive_url(['page' => 1]), '<i class="demo-psi-arrow-left-2"></i>') . '</li>';
                $back = '<li>' . Url::anchor(adaptive_url(['page' => $page - 1]), '<i class="demo-psi-arrow-left"></i>') . '</li>';
            } else {
                $bback = $back = '';
            }


            if ($page !== $allPages) {
                $nnext = '<li>' . Url::anchor(adaptive_url(['page' => $allPages]), '<i class="demo-psi-arrow-right-2"></i>') . '</li>';
                $next = '<li>' . Url::anchor(adaptive_url(['page' => $page + 1]), '<i class="demo-psi-arrow-right"></i>') . '</li>';
            } else {
                $nnext = $next = '';
            }

            if($topNav === true){
                $pageControl    = (new Input('page'))
                    ->setValue($page)
                    ->addAttr('form', 'search-' . $this->engine->getName())
                    ->setClass('form-control')
                    ->render();
            }
            else{
                $pageControl    = (new Input('page2'))
                    ->setValue($page)
                    //->addAttr('form', 'search-' . $this->engine->getName())
                    ->addAttr('onchange',"jQuery('input[name=page]').val(this.value); jQuery('#search-".$this->engine->getName()."').submit()")
                    ->setClass('form-control')
                    ->render();
            }


            $navigation = '<li><div class="pager-info"><span class="pager-info-fisrt">Страница</span><span class="pager-info-second">' . $pageControl
                . '</span><span class="pager-info-last">из ' . $allPages . '</span>';

            $queryData = $this->engine->getRequest()->getQueryParams();

            $ignored = ['page'];
            foreach ($this->engine->getFilters() as $filter) {
                $ignored[] = $filter->getControl()->getName();
            }

            $navigation .= '</div></li>';

            if ($allPages > 1) {
                if ($onlyPagination === true) {
                    $nav = '<ul class="pager pager-sm pager-top-control">' . $bback . ' ' . $back . $navigation . ' ' . $next . ' ' . $nnext . '</ul>';
                } else {
                    $nav = '<ul class="pager pager-sm">' . $bback . ' ' . $back . $navigation . ' ' . $next . ' ' . $nnext . '</ul>';
                }

            } else {
                $nav = nbs();
            }

            foreach ($queryData as $queryName => $value) {
                if (!in_array($queryName, $ignored) && !isset($this->filterSets[$queryName])) {
                    $nav .= (new Hidden($queryName, $value))->addAttr('form', 'search-' . $this->engine->getName())->render();
                    $this->filterSets[$queryName] = true;
                }
            }
        }


        if ($info || $nav) {

            if ($onlyPagination === true) {
                return $nav;
            }

            $html = '<div class="row">' .
                '<div class="col-sm-6 pager"><div class="text-left">' . $info . '</div></div>' .
                '<div class="col-sm-6 text-right"><div class="dataTables_paginate paging_simple_numbers">' . $nav . '</div></div>' .
                '</div>';
        } else {
            $html = '';
        }

        return $html;
    }

    private array $filterSets = [];

    /**
     * @return string
     */
    private function buildTable(): string
    {

        $criteria = $this->engine->getCriteria();

        //set default sort
        $useSort = false;
        foreach (get_class_methods($criteria) as $method) {
            if (strpos($method, 'getSortBy') !== false && $criteria->{$method}() !== null) {
                $useSort = true;
            }
        }

        if ($useSort === false && $this->engine->getDefaultSortColumn()) {
            $method = 'setSortBy' . array_key_first($this->engine->getDefaultSortColumn());
            $criteria->{$method}(array_values($this->engine->getDefaultSortColumn())[0]);
        }

        $rows = $this->engine->getRepo()->findByCriteria($criteria);
        $getData = $this->engine->getRequest()->getQueryParams();


        $html = '<form id="search-' . $this->engine->getName() . '" name="main-table" method="get" action="' . Request::createFromGlobals()->getPathInfo() . '">' .
            '</form>' .
            //class="table-responsive"
            '<div ><table class="nifty-table dataTable  ' .
            $this->engine->getClass() . '" ' .
            ($this->engine->getId() ? 'id="' . $this->engine->getId() . '"' : '') .
            '>';

        $columns = $this->engine->getColumns();

        if ($this->engine->hasControlAccess(DataTableEngine::CONTROL_ROWS_ACTION) === false) {
            foreach ($columns as $k => $column) {
                if ($column->getName() === 'check') {
                    unset($columns[$k]);
                    break;
                }
            }
        }
        //расчет процента для неотмеченных колонок
        $percent = 100;
        $col = 0;
        foreach ($columns as $column) {
            $w = $column->getWidth();
            if (strpos($w, '%') !== false) {
                $percent -= rtrim($w, '%');
            } else {
                $col++;
            }
        }

        //анализ колонок на остутсвующие указания ширины, если найедены то игнорируем автоподгон
        $fixCount = false;
        foreach ($columns as $column) {
            if ((int)$column->getWidth() === 0) {
                $fixCount = true;
                break;
            }
        }

        if ($percent !== 0 && $fixCount === false) {

            $newWidth = round(abs($percent) / count($columns));

            foreach (array_reverse($columns) as $column) {

                if ($percent === 0) {
                    break;
                }

                $width = (int)rtrim($column->getWidth(), '%');

                if ($percent < 0) {
                    $column->setWidth($width - $newWidth, true);
                    $percent += $newWidth;
                } else {
                    $column->setWidth($width + $newWidth, true);
                    $percent -= $newWidth;
                }

            }
        }


        $htmlCollumns = '<colgroup>';
        $htmlHeader = '<thead><tr>';
        $htmlFotter = '<tfoot><tr>';
        $i = 0;


        /**
         * @var ColumnTable $column
         */
        foreach ($columns as $key => $column) {
            $i++;

            $caption = $column->getCaption() ?? $column->getName();
            $num = ($i % 2 === 0 ? 1 : 0);
            $ignoreSort = array_filter(array_keys($getData), function ($el) {
                return strpos($el, 'sort') !== false;
            });
            $sortClass = '';
            if ($column->isSorted() === true) {

                $sortParam = 'sort_by_' . $column->getName();
                $sortRule = 'asc';
                $sortClass = 'sorting';

                if (isset($getData[$sortParam]) && $getData[$sortParam] === 'asc') {
                    $sortRule = 'desc';
                    $sortClass = 'sorting_asc';
                } elseif (isset($getData[$sortParam]) && $getData[$sortParam] === 'desc') {
                    $sortRule = 'asc';
                    $sortClass = 'sorting_desc';
                }

                $findKey = array_search($sortParam, $ignoreSort, true);

                if ($findKey !== false) {
                    unset($ignoreSort[$findKey]);
                }
                $ignoreSort [] = 'page';

                $url = adaptive_url([
                    $sortParam => $sortRule
                ], $ignoreSort);

                $caption = '<nobr><a href="' . $url . '">' . $caption . '</a></nobr>';
            }

            $class = $sortClass . ' head' . $num;
            $attr = $column->getHeadAttributes();
            $attr['class'] = isset($attr['class']) ? ($attr['class'] . ' ' . $class) : $class;

            $attrStr = ' data-sort-ignore="true"';

            foreach ($attr as $name => $value) {
                $attrStr .= ' ' . $name . '="' . $value . '"';
            }


            $htmlHeader .= '<th' . $attrStr . '>' . $caption . '</th>';
            $htmlFotter .= '<th class="head' . $num . '">' . $caption . '</th>';

            if (stripos($column->getWidth(), 'px') !== false) {
                $style = sprintf('style="width:%s"', $column->getWidth());
            } elseif (stripos($column->getWidth(), '%') !== false) {

                $calculatePercent = ($fixCount === false && $col > 0 ? (round($percent / $col) . '%') : $column->getWidth());
                $style = sprintf('style="width:%s"', $calculatePercent);
            } else {
                $style = '';
            }


            $htmlCollumns .= '<col ' . $style . ' class="con' . $num . '">';
        }
        $htmlCollumns .= '</colgroup>';
        $htmlHeader .= '</tr></thead>';
        $htmlFotter .= '</tr></tfoot>';

        $html .= $htmlCollumns;
        $html .= $htmlHeader;
//        $html .= $htmlFotter;
        $html .= '<tbody>';

        //filters

        $hiddens = [];
//        foreach($queryParams as $queryParam => $value){
//            $hiddens[]= (new Hidden($queryParam, $value))->render();
//        }


        $filters = $this->engine->getFilters();

        if (count($filters)) {

            $style = isset($getData['filter']) ? '' : 'style="display: none"';

            $html .= '<tr ' . $style . ' class="table-filter">';

            $queryData = $getData;
            $existFilters = [];

            foreach ($columns as $key => $column) {
                //dd($column);
                $html .= '<td>';
                foreach ($filters as $filter) {

                    $filterName = $filter->getControl()->getName();

                    if (in_array($filterName, ['search_by_' . $column->getName(), 'filter_by_' . $column->getName()], true)) {

                        $html .=
                            $filter
                                ->getControl()
                                ->setValue(!empty($getData[$filterName])? trim($getData[$filterName]) : null)
                                ->setClass('form-control')
                                ->addAttr('form', 'search-' . $this->engine->getName())
                                ->addAttr('onchange', "jQuery('input[name=page]').val(1)")
                                ->render();

                        unset($queryData[$filterName]);

                        break;
                    }
                }
                $html .= '</td>';
            }


            //фильтры сохраняются в пагинации
//            foreach ($queryData as $queryName => $queryValue) {
//
//                $html .= '<input form="search-' . $this->engine->getName() . '" type="hidden" name="' . $queryName . '" value="' . $queryValue . '">';
//            }

            $html .= '</tr>';
        }


        $i = 0;

        /**
         * @var EntityInterface $entity
         */
        foreach ($rows as $entity) {
            $i++;
            $id = $entity->getId();
            $html .= '<tr ' . ($id > 0 ? 'id="row' . $id . '"' : '') . '>';
            foreach ($columns as $key => $column) {
                $html .= '<td ' . ($column->getClass() ? 'class="' . $column->getClass() . '"' : '') . '>' . $this->prepareRow($entity, $column) . '</td>';
            }
            $html .= '</tr>';
        }

        $html .= '</tbody>';
        $html .= '</table></div>';
        return $html;
    }

    /**
     * @param $model
     * @param ColumnTable $column
     * @return mixed|string
     */
    protected function prepareRow($model, ColumnTable $column)
    {

        $resultReal = method_exists($model, 'get' . $column->getName()) ?
            $model->{'get' . $column->getName()}() : '&nbsp;';

        $callable = $column->getFormat();

        if (is_callable($callable) || (is_array($callable) && isset($callable[0]) && is_object($callable[0]))) {
            $result = call_user_func($callable, $model);
        } else {
            $result = $resultReal;
        }


//        if ($resultReal > 0 && isset($this->summary[$column->getName()])) {
//            $this->summary[$column->getName()] += (float)$resultReal;
//        }

        return $result;
    }
}