<?php
/**
 * Created by PhpStorm.
 * User: Admin
 * Date: 19.08.2020
 * Time: 22:32
 */

namespace DiamondTable\Commands;


use ActiveTable\Contracts\CommandInterface;
use ActiveTable\DataTableEngine;
use Diamond\Helpers\Form;
use Propel\Runtime\Exception\PropelException;
use Psr\Log\LoggerAwareInterface;
use Psr\Log\LoggerAwareTrait;
use Psr\Log\NullLogger;
use Symfony\Component\HttpFoundation\RedirectResponse;
use Twig\Error\Error;
use Twig\Error\RuntimeError;

class TableRowDelete implements CommandInterface, LoggerAwareInterface
{
    use LoggerAwareTrait;
    protected $tableEngine;

    public function __construct(DataTableEngine $tableEngine)
    {
        $this->tableEngine = $tableEngine;
        $this->logger = new NullLogger();
    }

    public function process(): void
    {
        $engine = $this->tableEngine;
        $postData = $engine->getRequest()->getParsedBody();

        $ids = isset($postData['ids']) ? explode(',', trim($postData['ids'], ',')) : null;


        $ids = array_filter($ids, function ($v) {
            return $v > 0;
        });

        if (!$ids) {
            Form::addTableNotice(
                    Form::buildErrorMessage('Не выбранны записи для удаления')
                );
        } else {

            $success = $error = $error_caption = [];

            foreach ($ids as $id) {
                try {

                    if (!$entity = $engine->loadFormEntity($id)) {
                        throw new \RuntimeException('entity not found by id ' . $id);
                    }

                    $engine->getRepo()->delete($entity);
                    $success [] = $id;
                } catch (\RuntimeException | RuntimeError |  PropelException $ex) {
                    $error [] = $id;

                    if(is_a($ex,PropelException::class)){
                        while($ex = $ex->getPrevious()){
                            if(preg_match('~constraint\sfails\s.*?\(.*?\.(.*?)\,~is',$ex->getMessage(),$match)){
                                $error_caption[$id] = 'Имеется относящийся к удаляемой записи `'.$id.'` документ в таблице ' . $match[1];
                                break;
                            }
                        }
                    }
                    $this->logger->error($ex->getMessage());
                }
            }

            if (count($success)) {

                $text = count($ids) === 1 ?
                    sprintf(
                        'Выбранная запись <strong>№ %s</strong> успешно удалена!',
                        implode(',', $success)
                    ) :
                    sprintf(
                        'Выбранные записи <strong>№ %s</strong> успешно удалены!',
                        implode(',', $success)
                    );

                Form::addTableNotice(
                    Form::buildSuccessMessage($text)
                );
            }

            if (count($error)) {

                $text = count($ids) === 1 ?
                    sprintf(
                        'Запись <strong>№ %s</strong> не удалось удалить',
                        implode(',', $error)
                    ) :
                    sprintf(
                        'Следующие записи <strong>№ %s</strong> не удалось удалить',
                        implode(',', $error)
                    );

                if(count($error_caption)){
                    $text .= '. '. implode(',', $error_caption);
                }

                Form::addTableNotice(
                    Form::buildErrorMessage($text)
                );
            }
        }
        RedirectResponse::create(adaptive_url([], ['fn', 'id']))->send();
    }


}