<?php

namespace DiamondTable\Commands;

use ActiveTable\ActionTable;
use ActiveTable\Contracts\CommandInterface;
use ActiveTable\DataTableEngine;
use ActiveTable\Exceptions\TableActionException;

/**
 * Действие над таблицей
 * Class TableAction
 * @package ActiveTable\Commands
 */
class TableAction implements CommandInterface
{
    /**
     * @var DataTableEngine
     */
    protected $tableEngine;

    /**
     * TableView constructor.
     * @param DataTableEngine $tableEngine
     */
    public function __construct(DataTableEngine $tableEngine)
    {
        $this->tableEngine = $tableEngine;
    }


    public function process(): void
    {

        $postData = $this->tableEngine->getRequest()->getParsedBody();
        $postData = array_change_key_case($postData);

        $getData = $this->tableEngine->getRequest()->getQueryParams();

        $actions = array_merge($this->tableEngine->getActions(), $this->tableEngine->getRowActions());

        /**
         * получаем весь набор действий и выполняем тот чьеимя есть в post массиве, т.е было выполнено
         */
        try {
            foreach ($actions as $action) {

                /**
                 * @var ActionTable $action
                 */
                $name = strtolower($action->getControl()->getName());

                if (isset($postData[$name]) ||
                    (isset($postData["actiontype"]) && strtolower($postData["actiontype"]) === $name) ||
                    (isset($getData["fn"]) && strtolower($getData["fn"]) === $name)
                ) {

                    call_user_func_array($action->getCalback(), [$this->tableEngine]);
                }
            }
        } catch (TableActionException $exception) {
            $this->tableEngine->addContent($exception->getMessage());
        }

    }


}