<?php

namespace DiamondTable\Commands;

use ActiveTable\Contracts\CommandInterface;
use Psr\Log\LoggerAwareInterface;
use Psr\Log\LoggerAwareTrait;
use Symfony\Component\HttpFoundation\RedirectResponse;

/**
 * Class TableRowSave
 * @package DiamondTable\Commands
 */
class TableRowSave extends CommandAbstract implements CommandInterface, LoggerAwareInterface
{
    use LoggerAwareTrait;

    /**
     *
     */
    public function process(): void
    {
        //некоторые данные в post перелпределяются, например загрузка картинок
        $data = $this->getPostData();

        $entity = $this->buildEntityFromArray($data,  $this->tableEngine->loadFormEntity());

        $this->saveEntity($entity);

        if(isset($data['save'])){
            $this->redirectSelf($entity);
        }
        else{
            $this->addFormNotice('Запись <strong>№' . $entity->getId() . '</strong> успешно сохранена!', true);
            $this->redirect();
        }

    }

}