<?php
/**
 * Created by PhpStorm.
 * User: Admin
 * Date: 19.08.2020
 * Time: 22:32
 */

namespace DiamondTable\Commands;


use ActiveTable\Contracts\CommandInterface;
use ActiveTable\DataTableEngine;
use Diamond\Helpers\Form;
use Psr\Log\LoggerAwareInterface;
use Psr\Log\LoggerAwareTrait;
use Psr\Log\NullLogger;
use Symfony\Component\HttpFoundation\RedirectResponse;

class TableRowDelete implements CommandInterface, LoggerAwareInterface
{
    use LoggerAwareTrait;
    protected $tableEngine;

    public function __construct(DataTableEngine $tableEngine)
    {
        $this->tableEngine = $tableEngine;
        $this->logger = new NullLogger();
    }

    public function process(): void
    {
        $engine = $this->tableEngine;
        $postData = $engine->getRequest()->getParsedBody();

        $ids = isset($postData['ids']) ? explode(',', trim($postData['ids'], ',')) : null;


        $ids = array_filter($ids, function ($v) {
            return $v > 0;
        });

        if (!$ids) {
            Form::addTableNotice(
                    Form::buildErrorMessage('Не выбранны записи для удаления')
                );
        } else {

            $success = $error = [];

            foreach ($ids as $id) {
                try {
                    if (!$entity = $engine->getRepo()->findById($id)) {
                        throw new \RuntimeException('entity not found by id ' . $id);
                    }

                    $engine->getRepo()->delete($entity);
                    $success [] = $id;
                } catch (\RuntimeException $ex) {
                    $error [] = $id;
                    $this->logger->error($ex->getMessage());
                }
            }

            if (count($success)) {

                $text = count($ids) === 1 ?
                    sprintf(
                        'Выбранная запись № %s успешно удалена!',
                        implode(',', $success)
                    ) :
                    sprintf(
                        'Выбранные записи № %s успешно удалены!',
                        implode(',', $success)
                    );

                Form::addTableNotice(
                    Form::buildSuccessMessage($text)
                );
            }

            if (count($error)) {

                $text = count($ids) === 1 ?
                    sprintf(
                        'Запись № %s не получилось удалить',
                        implode(',', $error)
                    ) :
                    sprintf(
                        'Следующие записи № %s не получилось удалить',
                        implode(',', $error)
                    );

                Form::addTableNotice(
                    Form::buildErrorMessage($text)
                );
            }
        }
        RedirectResponse::create(adaptive_url([], ['fn', 'id']))->send();
    }


}