<?php

namespace DiamondTable\Commands;

use ActiveTable\Contracts\CommandInterface;
use ActiveTable\DataTableEngine;
use Core\Form\Simpleform;
use Diamond\Helpers\Form;
use DiamondTable\CommandException;
use Propel\Runtime\ActiveQuery\ModelCriteria;
use Propel\Runtime\ActiveRecord\ActiveRecordInterface;
use Propel\Runtime\Collection\ObjectCollection;
use Propel\Runtime\Exception\PropelException;
use Propel\Runtime\Exception\RuntimeException;
use Propel\Runtime\Map\TableMap;
use Psr\Log\LoggerAwareInterface;
use Psr\Log\LoggerAwareTrait;
use Psr\Log\NullLogger;
use Repo\CrudRepositoryBuilderInterface;
use Symfony\Component\HttpFoundation\RedirectResponse;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Session\Session;

/**
 * Class TableRowSave
 * @package DiamondTable\Commands
 */
class TableRowSave implements CommandInterface, LoggerAwareInterface
{
    use LoggerAwareTrait;

    protected $tableEngine;

    public function __construct(DataTableEngine $tableEngine)
    {
        $this->tableEngine = $tableEngine;
    }

    /**
     *
     */
    public function process(): void
    {
        //некоторые данные в post перелпределяются, например загрузка картинок
        $data =  Request::createFromGlobals()->request->all();
        //$data = $this->tableEngine->getRequest()->getParsedBody();
        $repo = $this->tableEngine->getRepo();

        /**
         * @var ActiveRecordInterface|ObjectCollection $entity
         */
        $id = $data['id'] ?? null;
        unset($data['id']);


        array_walk($data,function (&$el){
            $el = $el!=='NULL' ? $el : null;
        });

        if ($id) {
            $entity = $repo->buildEntityFromArray($data, $repo->findById($id));
        }
        //update
        else {
            $entity = $repo->buildEntityFromArray($data);
        }

        try {
            $repo->save($entity);
        } catch (PropelException $ex) {
            throw new CommandException($ex->getMessage());
        }

        $session = new Session();
        $session
            ->getFlashBag()
            ->set('table-notice',
                Form::buildSuccessMessage(
                    'Запись №' . $entity->getId() . ' успешно сохранена! ' . anchor(adaptive_url(['fn'=>'add'],['id']), 'Добавить новую запись')
                )
            );

        RedirectResponse::create(adaptive_url([], ['fn', 'id']))->send();
    }

}