<?php

namespace DiamondTable\Commands;

use ActiveTable\Contracts\CommandInterface;
use ActiveTable\DataTableEngine;
use Core\Form\Control\FormField;
use DiamondTable\ValidatorFactory;
use Repo\Concrete\Exceptions\ValidationException;
use Symfony\Component\Validator\Validation;

class FormValidation implements CommandInterface
{

    protected $engine;

    public function __construct(DataTableEngine $tableEngine)
    {
        $this->engine = $tableEngine;
    }

    public function process(): void
    {

        $validator = Validation::createValidator();
        $data = $this->engine->getRequest()->getParsedBody();

        $errors = [];

        /**
         * @var \ActiveTable\FormField $field
         */
        foreach ($this->engine->getFields() as $field) {

            $name = $field->getControl()->getName();

            $fieldValidations = $field->getCustomValidations();

            if ($field->isRequire() === true) {
                $fieldValidations[] = 'required';
            }

            if(count($fieldValidations)===0){
                continue;
            }

            $rules = ValidatorFactory::build($fieldValidations);

            $results = $validator->validate($data[$name] ?? null, $rules);

            foreach ($results as $violation) {
                $errors [] = $field->getCaption() . ' - ' . $violation->getMessage();
            }
        }

        if (count($errors)) {
            throw new ValidationException($errors);
        }
    }

}