<?php
/**
 * Created by PhpStorm.
 * User: Admin
 * Date: 19.08.2020
 * Time: 23:11
 */

namespace DiamondTable;


use Psr\Http\Message\ServerRequestInterface;
use Repo\PaginationInterface;
use Symfony\Component\HttpFoundation\Session\Session;

class SearchCriteriaBuilder
{

    protected static $defaultRows = 10;
    protected static $defaultPage = 1;

    /**
     * @param ServerRequestInterface $request
     * @param PaginationInterface $criteria
     * @return PaginationInterface
     * @throws \ReflectionException
     */
    public static function buildFromRequest(ServerRequestInterface $request, PaginationInterface $criteria): PaginationInterface
    {
        $getQuery = $request->getQueryParams();


        $session = new Session();

        if($criteria->getLimit() > 0 ){
            $setRows = $criteria->getLimit();
        }
        elseif (isset($getQuery['rows']) && $getQuery['rows'] > 0) {
            $setRows = $getQuery['rows'];
            $session->set('table-rows', $setRows);
        } elseif ($session->get('table-rows') > 0) {
            $setRows = $session->get('table-rows');
        } else {
            $setRows = self::$defaultRows;
        }

        $criteria->setLimit($setRows);
        $criteria->setPage(isset($getQuery['page']) && $getQuery['page'] > 0 ? $getQuery['page'] : self::$defaultPage);
        $criteria->setFilterById($getQuery['id'] ?? null);

        foreach ($getQuery as $name => $param) {
            if (stripos($name, 'search') !== false ||
                stripos($name, 'filter') !== false ||
                stripos($name, 'sort') !== false
            ) {
                $method = 'set' . str_replace('_', '', $name);


                if (!empty($param) && method_exists($criteria, $method)) {

                    $classRef = new \ReflectionClass($criteria);
                    $paramRef = $classRef->getMethod($method)->getParameters();

                    if (isset($paramRef[0]) && $paramRef[0]->getType() &&
                        $paramRef[0]->getType()->getName() === 'bool' && in_array(strtoupper($param), ['Y', 'N'])) {
                        $param = strtoupper($param) === 'Y';
                    }

                    $criteria->$method($param);
                }
            }
        }

        return $criteria;
    }

}