<?php
/**
 * Created by PhpStorm.
 * User: Admin
 * Date: 19.08.2020
 * Time: 22:32
 */

namespace DiamondTable\Commands;


use ActiveTable\ColumnTable;
use ActiveTable\Contracts\CommandInterface;
use ActiveTable\DataTableEngine;
use Diamond\Helpers\Form;
use ExportEngine\Drivers\Xlsx;
use ExportEngine\Exporter;
use Psr\Log\LoggerAwareInterface;
use Psr\Log\LoggerAwareTrait;
use Psr\Log\NullLogger;
use Symfony\Component\HttpFoundation\RedirectResponse;

class TableRowExport extends TableView implements CommandInterface
{
    protected $tableEngine;

    public function __construct(DataTableEngine $tableEngine)
    {
        $this->tableEngine = $tableEngine;
    }

    public function process(): void
    {
        $engine = $this->tableEngine;
        $postData = $engine->getRequest()->getParsedBody();

        $ids = isset($postData['ids']) ? explode(',', trim($postData['ids'], ',')) : null;


        $ids = array_filter($ids, function ($v) {
            return $v > 0;
        });


        $export = new Exporter(
            new Xlsx()
        );

        $criteria = $this->tableEngine->getCriteria();
        $criteria->setFilterByIds($ids);

        $rows = $this->tableEngine->getRepo()->findByCriteria($criteria);
        $columns = $this->tableEngine->getColumns();

        $row = [];
        /**
         * @var ColumnTable $column
         */
        foreach ($columns as $key => $column) {
            if ($column->isExported() === true) {
                $row[$key] = $column->getCaption();
            }
        }

        $export->addRow($row);

        foreach ($rows as $entity) {
            $row = [];
            /**
             * @var ColumnTable $column
             */
            foreach ($columns as $key => $column) {
                if ($column->isExported() === true) {
                    $row[$key] = strip_tags($this->prepareRow($entity, $column));
                }
            }

            $export->addRow($row);

        }


        if (!$ids) {
            Form::addTableNotice(
                Form::buildErrorMessage('Не выбранны записи для удаления')
            );
            RedirectResponse::create(adaptive_url([], ['fn', 'id']))->send();
        }

        $path = BASEPATH . '/public_html/upload/export';

        if (!is_dir($path) && !mkdir($path, 0777, true)) {
            Form::addTableNotice(
                Form::buildErrorMessage('Не удалось создать каталог для временных файлов')
            );
            RedirectResponse::create(adaptive_url([], ['fn', 'id']))->send();
        }

        $export->exportToFile($path . '/' . $this->tableEngine->getName() . '.xlsx');

        Form::addTableNotice(
            Form::buildSuccessMessage(sprintf(
                'Экспорт успешно произведен, скачать <a href="%s">файл</a>',
                '/upload/export/' . $this->tableEngine->getName() . '.xlsx'
            ))
        );

        RedirectResponse::create(adaptive_url([], ['fn', 'id']))->send();
    }


}