<?php
/**
 * Created by PhpStorm.
 * User: Admin
 * Date: 15.08.2020
 * Time: 12:13
 */

namespace DiamondTable;


use Symfony\Component\Validator\Constraints;

class ValidatorFactory
{

    /**
     * @todo допилить
     * @param $rules required|captcha  or ['required','captcha']
     * @return array
     */
    public static function build($rules): array
    {
        if (!is_array($rules)) {
            $rules = explode('|', $rules);
        }
        $correct_rules = [];

        foreach ($rules as $rule) {


            switch ($rule) {
                case 'required':

                    $rule = new Constraints\NotBlank();
                    $rule->message = 'поле не должно быть пустым.';
                    $correct_rules [] = $rule;

                    break;

                case 'email':
                case 'mail':
                    $rule = new Constraints\Email();
                    $rule->message = 'это значение не является действительным адресом электронной почты';
                    $correct_rules [] = $rule;

                    break;

                case 'captcha':

                    $rule = new \Core\Form\Constraints\Captcha($Field);
                    //$rule->message    = "поле не должно быть пустым.";
                    $correct_rules [] = $rule;

                    break;

                case 'recaptcha':

                    $rule = new \Core\Form\Constraints\ReCaptcha($Field);
                    $correct_rules [] = $rule;

                    break;


                default:
                    if (isset($customValidations[$rule])) {
                        $rule = new \Core\Form\Constraints\Custom($customValidations[$rule]);
                        $correct_rules [] = $rule;
                    }

                    break;
            }
        }


        return $correct_rules;
    }

}