<?php
namespace Diamond\Modules\ErrorsChart;

use Core\ModuleController;
use Core\Template\Template;

/**
 * Description of AdminAuth
 *
 * @author Dmitriy
 */
class ErrorsChart extends ModuleController
{

    public int $height = 300;
    public string $id = 'chartplace';
    public int $limit = 30;
    public string $url = '/_service/diamond/stat/errors';
    public string $title = '';

    /**
     * ErrorsChart constructor.
     * @param Template $template
     */
    public function __construct(protected Template $template)
    {
    }

    public function process(): string
    {

        $this->template->addScriptLink('/_diamond/widgets/assets/jquery/flot/flot.min.js');
        $this->template->addScriptLink('/_diamond/widgets/assets/jquery/flot/flot.resize.min.js');

        $this->template->addScript($this->render('javascript',
            [
                'interval' => $this->limit,
                'url' => $this->url,
                'id' => $this->id,
                'minTickSize' => 'day'
            ]));

        return $this->render([
            'title' => $this->title,
            'height' => $this->height,
            'id' => $this->id
        ]);
    }

}