<?php


namespace Diamond\Modules\AdminMailingList;


use ActiveTable\Contracts\CommandInterface;
use ActiveTable\DataTableEngine;
use Core\Helpers\Text;
use Diamond\Application\Mailing\Exceptions\MailingException;
use Diamond\Application\Mailing\MailingService;
use Diamond\Helpers\Form;
use Symfony\Component\HttpFoundation\RedirectResponse;

class SendMailingCommand implements CommandInterface
{
    protected $tableEngine;
    protected $mailingUseCases;

    public function __construct(DataTableEngine $tableEngine, MailingService $mailingUseCases)
    {
        $this->tableEngine = $tableEngine;
        $this->mailingUseCases = $mailingUseCases;
    }

    public function process(): void
    {

        $ids = Form::getIdsFromRequest();

        if (!$ids) {
            Form::addTableNotice(
                Form::buildErrorMessage('Не выбранны рассылки для запуска')
            );
        }

        $success = $error = [];

        foreach ($ids as $id) {

            $mailing = $this->mailingUseCases->getMailingListRepository()->findById($id);

            $progressData = $mailing->getProgressData();

            //если рассылка есть
            if ($progressData && $progressData->getProgress() < 100) {
                $error[] = $id;
                continue;
            }

            //запуск рассылки
            try {
                $this->mailingUseCases->sendMailing($mailing);
            } catch (MailingException $ex) {
                $error[] = $id;
                continue;
            }

            $success[] = $id;
        }

        if (count($error)) {

            Form::addTableNotice(
                Form::buildErrorMessage(sprintf(
                    'Рассылк%s №%s уже запущен%s или при выполнении произошел сбой.',
                    Text::morph(count($error), 'а', 'и', 'и'),
                    implode(',', $error),
                    Text::morph(count($error), 'а', 'ы', 'ы')
                ))
            );

        }

        if (count($success)) {
            Form::addTableNotice(
                Form::buildSuccessMessage(
                    sprintf(
                        'Рассылк%s №%s успешно запущен%s.',
                        Text::morph(count($success), 'а', 'и', 'и'),
                        implode(',', $success),
                        Text::morph(count($success), 'а', 'ы', 'ы')
                    )
                )
            );
        }


        RedirectResponse::create(adaptive_url([], ['fn', 'id']))->send();
    }

}