<?php declare(strict_types=1);

namespace Diamond\Helpers;

class UserIconHelper
{
    /**
     * Создаем иконку на основе id пользователя
     * @param int $id
     * @return string
     */
    public static function createIcon(int $id): string
    {
        $lastNum = (int)round(substr((string)$id, -1, 1) / 2);

        $lastNum = $lastNum===0 ? 1: $lastNum;
        return '/_diamond/diamond-cms/assets/nifty/img/profile-photos/' . $lastNum . '.png';
    }
}