<?php declare(strict_types=1);

namespace Diamond\Repositories\MessageRequest;

use Diamond\Domain\MessageRequest\Contracts\MessageRequestRepositoryInterface;
use Diamond\Domain\MessageRequest\MessageRequestCollection;
use Diamond\Infrastructure\Models\MessageRequest\MessageRequest;
use Diamond\Infrastructure\Models\MessageRequest\MessageRequestQuery;
use Diamond\Repositories\PropelAbstractRepository;
use Propel\Runtime\ActiveQuery\Criteria;
use Propel\Runtime\ActiveQuery\ModelCriteria;
use Repo\CollectionInterface;
use Repo\EntityInterface;
use Repo\PaginationInterface;

class MessageRequestRepository extends PropelAbstractRepository implements MessageRequestRepositoryInterface
{
    public static function createEntity(): EntityInterface
    {
        return new MessageRequest();
    }

    protected function createQuery(): ModelCriteria
    {
        return MessageRequestQuery::create();
    }

    protected function createCollection(): CollectionInterface
    {
        return new MessageRequestCollection();
    }

    /**
     * @param PaginationInterface|MessageRequestCriteria $criteria
     * @param ModelCriteria|MessageRequestQuery $dbCriteria
     * @return void
     */
    protected function modifyCriteria(PaginationInterface $criteria, ModelCriteria $dbCriteria): void
    {
        $dbCriteria
            ->_if($criteria->getSearchByEmailTo())
            ->filterByEmailTo('%'.$criteria->getSearchByEmailTo().'%',Criteria::LIKE)
            ->_endif()
            ->_if($criteria->getSearchByEmailFrom())
            ->filterByEmailFrom('%'.$criteria->getSearchByEmailFrom().'%',Criteria::LIKE)
            ->_endif()
            ->_if($criteria->getSearchBySubject())
            ->filterBySubject('%'.$criteria->getSearchBySubject().'%',Criteria::LIKE)
            ->_endif()
            ->_if($criteria->getSearchByStatus())
            ->filterByStatus('%'.$criteria->getSearchByStatus().'%',Criteria::LIKE)
            ->_endif()
            ;
    }

}