<?php

namespace Diamond\Repositories\MailingRequestRecipient;

use Diamond\Domain\MailingRequestRecipient\Contracts\MailingRequestRecipientCriteriaInterface;
use Diamond\Domain\MailingRequestRecipient\MailingRequestRecipientCollection;
use Diamond\Infrastructure\Models\MailingRequest\MailingRequest;
use Diamond\Infrastructure\Models\MailingRequestRecipient\MailingRequestRecipient;
use Diamond\Infrastructure\Models\MailingRequestRecipient\MailingRequestRecipientQuery;
use Diamond\Repositories\PropelAbstractRepository;
use Propel\Runtime\ActiveQuery\Criteria;
use Propel\Runtime\ActiveQuery\ModelCriteria;
use Repo\CollectionInterface;
use Repo\CrudRepositoryBuilderInterface;
use Repo\EntityInterface;
use Repo\PaginationInterface;

class MailingRequestRecipientRepository  extends PropelAbstractRepository implements CrudRepositoryBuilderInterface
{
    public static function createEntity(): EntityInterface
    {
        return new MailingRequestRecipient();
    }

    protected function createQuery(): ModelCriteria
    {
        return MailingRequestRecipientQuery::create();
    }

    /**
     * @param PaginationInterface|MailingRequestRecipientCriteriaInterface $criteria
     * @param ModelCriteria|MailingRequestRecipientQuery $dbCriteria
     * @return void
     */
    protected function modifyCriteria(PaginationInterface $criteria, ModelCriteria $dbCriteria): void
    {

        $dbCriteria
            ->_if($criteria->getSearchByEmail() !== null)
            ->filterByEmail('%' . $criteria->getSearchByEmail() .'%',Criteria::LIKE)
            ->_endif()
            ->_if($criteria->getFilterByStatuses() !== null)
            ->filterByStatus($criteria->getFilterByStatuses())
            ->_endif()
            ->_if($criteria->getFilterByRequestId() !== null)
            ->filterByRequestId($criteria->getFilterByRequestId())
            ->_endif()
        ;
    }


    protected function createCollection(): CollectionInterface
    {
        return new MailingRequestRecipientCollection();
    }

}