<?php

namespace Diamond\Repositories\MailingRequestRecipient;

use Diamond\Domain\MailingRequestRecipient\Contracts\MailingRequestRecipientCriteriaInterface;
use Repo\Concrete\AbstractCriteria;

class MailingRequestRecipientCriteria extends AbstractCriteria implements MailingRequestRecipientCriteriaInterface
{
    /**
     * @var int|null
     */
    private int|null $filterByRequestId = null;

    private string|null $searchByEmail = null;

    private array|null $filterByStatuses = null;

    public static function create()
    {
        return new self();
    }

    public function getFilterByStatuses(): ?array
    {
        return $this->filterByStatuses;
    }

    public function setFilterByStatuses(?array $filterByStatuses): MailingRequestRecipientCriteriaInterface
    {
        $this->filterByStatuses = $filterByStatuses;
        return $this;
    }

    public function getSearchByEmail(): ?string
    {
        return $this->searchByEmail;
    }

    public function setSearchByEmail(?string $searchByEmail): MailingRequestRecipientCriteriaInterface
    {
        $this->searchByEmail = $searchByEmail;
        return $this;
    }

    /**
     * @return int|null
     */
    public function getFilterByRequestId(): ?int
    {
        return $this->filterByRequestId;
    }

    /**
     * @param int|null $filterByRequestId
     * @return MailingRequestRecipientCriteria
     */
    public function setFilterByRequestId(?int $filterByRequestId): MailingRequestRecipientCriteriaInterface
    {
        $this->filterByRequestId = $filterByRequestId;
        return $this;
    }


}