<?php
/**
 * Created by PhpStorm.
 * User: Admin
 * Date: 08.09.2020
 * Time: 19:15
 */

namespace Diamond\Repositories\GuestBookItem;


use Diamond\Domain\GuestBookItem\Contracts\GuestBookItemCriteriaInterface;
use Diamond\Domain\GuestBookItem\GuestBookItemCollection;
use Diamond\Infrastructure\Models\GuestBook\GuestBookQuery;
use Diamond\Infrastructure\Models\GuestBookItem\GuestBookItem;
use Diamond\Infrastructure\Models\GuestBookItem\GuestBookItemQuery;
use Diamond\Repositories\PropelAbstractRepository;
use Propel\Runtime\ActiveQuery\Criteria;
use Propel\Runtime\ActiveQuery\ModelCriteria;
use Propel\Runtime\Collection\ObjectCollection;
use Repo\CollectionInterface;
use Repo\CrudRepositoryBuilderInterface;
use Repo\EntityInterface;
use Repo\PaginationInterface;

class GuestBookItemRepository extends PropelAbstractRepository implements CrudRepositoryBuilderInterface
{
    public static function createEntity(): EntityInterface
    {
        return new GuestBookItem();
    }

    protected function createQuery(): ModelCriteria
    {
        return GuestBookItemQuery::create();
    }

    /**
     * @param PaginationInterface|GuestBookItemCriteriaInterface $criteria
     * @param ModelCriteria|GuestBookItemQuery $dbCriteria
     */
    protected function modifyCriteria(PaginationInterface $criteria, ModelCriteria $dbCriteria): void
    {

        $dateTimeFrom = \DateTime::createFromFormat('d.m.Y|', $criteria->getFilterByDate());

        if (!$date = \DateTime::createFromFormat('d.m.Y|', $criteria->getFilterByDate())) {
            $dateTimeTo = null;
        } else {
            $dateTimeTo = \DateTime::createFromFormat('d.m.Y|', $criteria->getFilterByDate())->modify('+1 day');
        }

        $dbCriteria
            ->_if($criteria->getSortByDate() !== null)
            ->orderByDate($criteria->getSortByDate())
            ->_endif()
            ->_if($criteria->getFilterByObjectId() !== null)
            ->filterByObjectId($criteria->getFilterByObjectId())
            ->_endif()
            ->_if($criteria->getFilterByBookId())
            ->filterByBookId($criteria->getFilterByBookId())
            ->_endif()
            ->_if($criteria->getFilterByPublished() !== null)
            ->filterByPublished($criteria->getFilterByPublished() === true ? 'Y' : 'N')
            ->_endif()
            ->_if($criteria->getFilterByRank())
            ->filterByRank($criteria->getFilterByRank())
            ->_endif()
            ->_if($criteria->getSearchByUserName())
            ->filterByUsername('%' . $criteria->getSearchByUserName() . '%', Criteria::LIKE)
            ->_endif()
            ->_if($criteria->getSearchByUserEmail())
            ->filterByUseremail('%' . $criteria->getSearchByUserEmail() . '%', Criteria::LIKE)
            ->_endif()
            ->_if($criteria->getFilterByDate() !== null)
            ->filterByDate($dateTimeFrom, Criteria::GREATER_EQUAL)
            ->filterByDate($dateTimeTo, Criteria::LESS_THAN)
            ->_endif();

    }


    protected function createCollection(): CollectionInterface
    {
        return new GuestBookItemCollection();
    }


    /**
     * @deprecated
     * @param type $bookId
     * @return type
     */
    public function findPublishedByBookId(int $bookId): ObjectCollection
    {
        return $this->createQuery()
            ->filterByBookId($bookId)
            ->filterByPublished("Y")
            ->orderByDate(Criteria::DESC)
            ->find()
            ;
    }

    /**
     * @deprecated
     * @param int $bookId
     * @param string $objectId
     * @return ObjectCollection
     */
    public function findPublishedByBookIdAndObject(int $bookId,string $objectId): ObjectCollection
    {
        return $this->buildQuery()
            ->filterByBookId($bookId)
            ->filterByPublished("Y")
            ->filterByObjectId($objectId)
            ->orderByDate(Criteria::DESC)
            ->find()
            ;
    }
}