<?php

namespace Diamond\Repositories\Content;


use Diamond\Domain\Content\Contracts\ContentEntityInterface;
use Diamond\Infrastructure\Models\Content\Content;
use Diamond\Infrastructure\Models\Content\ContentArchive;
use Diamond\Infrastructure\Models\Content\ContentArchiveQuery;
use Propel\Runtime\ActiveQuery\ModelCriteria;
use Repo\EntityInterface;

class ArchiveContentRepository extends ContentRepository
{


    public static function createEntity(): EntityInterface
    {
        return new ContentArchive();
    }

    /**
     * @return ModelCriteria
     */
    protected function createQuery(): ModelCriteria
    {
        return ContentArchiveQuery::create();
    }

    /**
     * @param PageEntityInterface|ContentArchive $entity
     */
    public function restore(ContentEntityInterface $entity){
        $newPage = new Content();
        $newPage->populateFromArchive($entity);
        $newPage->save();
        $entity->delete();
    }
}