<?php

namespace Diamond\Infrastructure\Models\Rule\Map;

use Diamond\Infrastructure\Models\Rule\Rule;
use Diamond\Infrastructure\Models\Rule\RuleQuery;
use Propel\Runtime\Propel;
use Propel\Runtime\ActiveQuery\Criteria;
use Propel\Runtime\ActiveQuery\InstancePoolTrait;
use Propel\Runtime\Connection\ConnectionInterface;
use Propel\Runtime\DataFetcher\DataFetcherInterface;
use Propel\Runtime\Exception\PropelException;
use Propel\Runtime\Map\RelationMap;
use Propel\Runtime\Map\TableMap;
use Propel\Runtime\Map\TableMapTrait;


/**
 * This class defines the structure of the '_rules' table.
 *
 *
 *
 * This map class is used by Propel to do runtime db structure discovery.
 * For example, the createSelectSql() method checks the type of a given column used in an
 * ORDER BY clause to know whether it needs to apply SQL to make the ORDER BY case-insensitive
 * (i.e. if it's a text column type).
 */
class RuleTableMap extends TableMap
{
    use InstancePoolTrait;
    use TableMapTrait;

    /**
     * The (dot-path) name of this class
     */
    public const CLASS_NAME = 'Diamond.Infrastructure.Models.Rule.Map.RuleTableMap';

    /**
     * The default database name for this class
     */
    public const DATABASE_NAME = 'default';

    /**
     * The table name for this class
     */
    public const TABLE_NAME = '_rules';

    /**
     * The related Propel class for this table
     */
    public const OM_CLASS = '\\Diamond\\Infrastructure\\Models\\Rule\\Rule';

    /**
     * A class that can be returned by this tableMap
     */
    public const CLASS_DEFAULT = 'Diamond.Infrastructure.Models.Rule.Rule';

    /**
     * The total number of columns
     */
    public const NUM_COLUMNS = 7;

    /**
     * The number of lazy-loaded columns
     */
    public const NUM_LAZY_LOAD_COLUMNS = 0;

    /**
     * The number of columns to hydrate (NUM_COLUMNS - NUM_LAZY_LOAD_COLUMNS)
     */
    public const NUM_HYDRATE_COLUMNS = 7;

    /**
     * the column name for the id field
     */
    public const COL_ID = '_rules.id';

    /**
     * the column name for the group field
     */
    public const COL_GROUP = '_rules.group';

    /**
     * the column name for the user field
     */
    public const COL_USER = '_rules.user';

    /**
     * the column name for the opr_id field
     */
    public const COL_OPR_ID = '_rules.opr_id';

    /**
     * the column name for the object field
     */
    public const COL_OBJECT = '_rules.object';

    /**
     * the column name for the object_id field
     */
    public const COL_OBJECT_ID = '_rules.object_id';

    /**
     * the column name for the rls_access field
     */
    public const COL_RLS_ACCESS = '_rules.rls_access';

    /**
     * The default string format for model objects of the related table
     */
    public const DEFAULT_STRING_FORMAT = 'YAML';

    /**
     * holds an array of fieldnames
     *
     * first dimension keys are the type constants
     * e.g. self::$fieldNames[self::TYPE_PHPNAME][0] = 'Id'
     *
     * @var array<string, mixed>
     */
    protected static $fieldNames = [
        self::TYPE_PHPNAME       => ['Id', 'Group', 'User', 'OprId', 'Object', 'ObjectId', 'RlsAccess', ],
        self::TYPE_CAMELNAME     => ['id', 'group', 'user', 'oprId', 'object', 'objectId', 'rlsAccess', ],
        self::TYPE_COLNAME       => [RuleTableMap::COL_ID, RuleTableMap::COL_GROUP, RuleTableMap::COL_USER, RuleTableMap::COL_OPR_ID, RuleTableMap::COL_OBJECT, RuleTableMap::COL_OBJECT_ID, RuleTableMap::COL_RLS_ACCESS, ],
        self::TYPE_FIELDNAME     => ['id', 'group', 'user', 'opr_id', 'object', 'object_id', 'rls_access', ],
        self::TYPE_NUM           => [0, 1, 2, 3, 4, 5, 6, ]
    ];

    /**
     * holds an array of keys for quick access to the fieldnames array
     *
     * first dimension keys are the type constants
     * e.g. self::$fieldKeys[self::TYPE_PHPNAME]['Id'] = 0
     *
     * @var array<string, mixed>
     */
    protected static $fieldKeys = [
        self::TYPE_PHPNAME       => ['Id' => 0, 'Group' => 1, 'User' => 2, 'OprId' => 3, 'Object' => 4, 'ObjectId' => 5, 'RlsAccess' => 6, ],
        self::TYPE_CAMELNAME     => ['id' => 0, 'group' => 1, 'user' => 2, 'oprId' => 3, 'object' => 4, 'objectId' => 5, 'rlsAccess' => 6, ],
        self::TYPE_COLNAME       => [RuleTableMap::COL_ID => 0, RuleTableMap::COL_GROUP => 1, RuleTableMap::COL_USER => 2, RuleTableMap::COL_OPR_ID => 3, RuleTableMap::COL_OBJECT => 4, RuleTableMap::COL_OBJECT_ID => 5, RuleTableMap::COL_RLS_ACCESS => 6, ],
        self::TYPE_FIELDNAME     => ['id' => 0, 'group' => 1, 'user' => 2, 'opr_id' => 3, 'object' => 4, 'object_id' => 5, 'rls_access' => 6, ],
        self::TYPE_NUM           => [0, 1, 2, 3, 4, 5, 6, ]
    ];

    /**
     * Holds a list of column names and their normalized version.
     *
     * @var array<string>
     */
    protected $normalizedColumnNameMap = [
        'Id' => 'ID',
        'Rule.Id' => 'ID',
        'id' => 'ID',
        'rule.id' => 'ID',
        'RuleTableMap::COL_ID' => 'ID',
        'COL_ID' => 'ID',
        '_rules.id' => 'ID',
        'Group' => 'GROUP',
        'Rule.Group' => 'GROUP',
        'group' => 'GROUP',
        'rule.group' => 'GROUP',
        'RuleTableMap::COL_GROUP' => 'GROUP',
        'COL_GROUP' => 'GROUP',
        '_rules.group' => 'GROUP',
        'User' => 'USER',
        'Rule.User' => 'USER',
        'user' => 'USER',
        'rule.user' => 'USER',
        'RuleTableMap::COL_USER' => 'USER',
        'COL_USER' => 'USER',
        '_rules.user' => 'USER',
        'OprId' => 'OPR_ID',
        'Rule.OprId' => 'OPR_ID',
        'oprId' => 'OPR_ID',
        'rule.oprId' => 'OPR_ID',
        'RuleTableMap::COL_OPR_ID' => 'OPR_ID',
        'COL_OPR_ID' => 'OPR_ID',
        'opr_id' => 'OPR_ID',
        '_rules.opr_id' => 'OPR_ID',
        'Object' => 'OBJECT',
        'Rule.Object' => 'OBJECT',
        'object' => 'OBJECT',
        'rule.object' => 'OBJECT',
        'RuleTableMap::COL_OBJECT' => 'OBJECT',
        'COL_OBJECT' => 'OBJECT',
        '_rules.object' => 'OBJECT',
        'ObjectId' => 'OBJECT_ID',
        'Rule.ObjectId' => 'OBJECT_ID',
        'objectId' => 'OBJECT_ID',
        'rule.objectId' => 'OBJECT_ID',
        'RuleTableMap::COL_OBJECT_ID' => 'OBJECT_ID',
        'COL_OBJECT_ID' => 'OBJECT_ID',
        'object_id' => 'OBJECT_ID',
        '_rules.object_id' => 'OBJECT_ID',
        'RlsAccess' => 'RLS_ACCESS',
        'Rule.RlsAccess' => 'RLS_ACCESS',
        'rlsAccess' => 'RLS_ACCESS',
        'rule.rlsAccess' => 'RLS_ACCESS',
        'RuleTableMap::COL_RLS_ACCESS' => 'RLS_ACCESS',
        'COL_RLS_ACCESS' => 'RLS_ACCESS',
        'rls_access' => 'RLS_ACCESS',
        '_rules.rls_access' => 'RLS_ACCESS',
    ];

    /**
     * Initialize the table attributes and columns
     * Relations are not initialized by this method since they are lazy loaded
     *
     * @return void
     * @throws \Propel\Runtime\Exception\PropelException
     */
    public function initialize(): void
    {
        // attributes
        $this->setName('_rules');
        $this->setPhpName('Rule');
        $this->setIdentifierQuoting(true);
        $this->setClassName('\\Diamond\\Infrastructure\\Models\\Rule\\Rule');
        $this->setPackage('Diamond.Infrastructure.Models.Rule');
        $this->setUseIdGenerator(true);
        // columns
        $this->addPrimaryKey('id', 'Id', 'INTEGER', true, null, null);
        $this->addColumn('group', 'Group', 'CHAR', false, 50, '%');
        $this->addColumn('user', 'User', 'CHAR', false, 50, '%');
        $this->addColumn('opr_id', 'OprId', 'INTEGER', false, null, 1);
        $this->addColumn('object', 'Object', 'CHAR', false, 50, '%');
        $this->addColumn('object_id', 'ObjectId', 'CHAR', false, 50, '%');
        $this->addColumn('rls_access', 'RlsAccess', 'CHAR', false, null, 'Y');
    }

    /**
     * Build the RelationMap objects for this table relationships
     *
     * @return void
     */
    public function buildRelations(): void
    {
    }

    /**
     * Retrieves a string version of the primary key from the DB resultset row that can be used to uniquely identify a row in this table.
     *
     * For tables with a single-column primary key, that simple pkey value will be returned.  For tables with
     * a multi-column primary key, a serialize()d version of the primary key will be returned.
     *
     * @param array $row Resultset row.
     * @param int $offset The 0-based offset for reading from the resultset row.
     * @param string $indexType One of the class type constants TableMap::TYPE_PHPNAME, TableMap::TYPE_CAMELNAME
     *                           TableMap::TYPE_COLNAME, TableMap::TYPE_FIELDNAME, TableMap::TYPE_NUM
     *
     * @return string|null The primary key hash of the row
     */
    public static function getPrimaryKeyHashFromRow(array $row, int $offset = 0, string $indexType = TableMap::TYPE_NUM): ?string
    {
        // If the PK cannot be derived from the row, return NULL.
        if ($row[TableMap::TYPE_NUM == $indexType ? 0 + $offset : static::translateFieldName('Id', TableMap::TYPE_PHPNAME, $indexType)] === null) {
            return null;
        }

        return null === $row[TableMap::TYPE_NUM == $indexType ? 0 + $offset : static::translateFieldName('Id', TableMap::TYPE_PHPNAME, $indexType)] || is_scalar($row[TableMap::TYPE_NUM == $indexType ? 0 + $offset : static::translateFieldName('Id', TableMap::TYPE_PHPNAME, $indexType)]) || is_callable([$row[TableMap::TYPE_NUM == $indexType ? 0 + $offset : static::translateFieldName('Id', TableMap::TYPE_PHPNAME, $indexType)], '__toString']) ? (string) $row[TableMap::TYPE_NUM == $indexType ? 0 + $offset : static::translateFieldName('Id', TableMap::TYPE_PHPNAME, $indexType)] : $row[TableMap::TYPE_NUM == $indexType ? 0 + $offset : static::translateFieldName('Id', TableMap::TYPE_PHPNAME, $indexType)];
    }

    /**
     * Retrieves the primary key from the DB resultset row
     * For tables with a single-column primary key, that simple pkey value will be returned.  For tables with
     * a multi-column primary key, an array of the primary key columns will be returned.
     *
     * @param array $row Resultset row.
     * @param int $offset The 0-based offset for reading from the resultset row.
     * @param string $indexType One of the class type constants TableMap::TYPE_PHPNAME, TableMap::TYPE_CAMELNAME
     *                           TableMap::TYPE_COLNAME, TableMap::TYPE_FIELDNAME, TableMap::TYPE_NUM
     *
     * @return mixed The primary key of the row
     */
    public static function getPrimaryKeyFromRow(array $row, int $offset = 0, string $indexType = TableMap::TYPE_NUM)
    {
        return (int) $row[
            $indexType == TableMap::TYPE_NUM
                ? 0 + $offset
                : self::translateFieldName('Id', TableMap::TYPE_PHPNAME, $indexType)
        ];
    }

    /**
     * The class that the tableMap will make instances of.
     *
     * If $withPrefix is true, the returned path
     * uses a dot-path notation which is translated into a path
     * relative to a location on the PHP include_path.
     * (e.g. path.to.MyClass -> 'path/to/MyClass.php')
     *
     * @param bool $withPrefix Whether to return the path with the class name
     * @return string path.to.ClassName
     */
    public static function getOMClass(bool $withPrefix = true): string
    {
        return $withPrefix ? RuleTableMap::CLASS_DEFAULT : RuleTableMap::OM_CLASS;
    }

    /**
     * Populates an object of the default type or an object that inherit from the default.
     *
     * @param array $row Row returned by DataFetcher->fetch().
     * @param int $offset The 0-based offset for reading from the resultset row.
     * @param string $indexType The index type of $row. Mostly DataFetcher->getIndexType().
                                 One of the class type constants TableMap::TYPE_PHPNAME, TableMap::TYPE_CAMELNAME
     *                           TableMap::TYPE_COLNAME, TableMap::TYPE_FIELDNAME, TableMap::TYPE_NUM.
     *
     * @throws \Propel\Runtime\Exception\PropelException Any exceptions caught during processing will be
     *                         rethrown wrapped into a PropelException.
     * @return array (Rule object, last column rank)
     */
    public static function populateObject(array $row, int $offset = 0, string $indexType = TableMap::TYPE_NUM): array
    {
        $key = RuleTableMap::getPrimaryKeyHashFromRow($row, $offset, $indexType);
        if (null !== ($obj = RuleTableMap::getInstanceFromPool($key))) {
            // We no longer rehydrate the object, since this can cause data loss.
            // See http://www.propelorm.org/ticket/509
            // $obj->hydrate($row, $offset, true); // rehydrate
            $col = $offset + RuleTableMap::NUM_HYDRATE_COLUMNS;
        } else {
            $cls = RuleTableMap::OM_CLASS;
            /** @var Rule $obj */
            $obj = new $cls();
            $col = $obj->hydrate($row, $offset, false, $indexType);
            RuleTableMap::addInstanceToPool($obj, $key);
        }

        return array($obj, $col);
    }

    /**
     * The returned array will contain objects of the default type or
     * objects that inherit from the default.
     *
     * @param DataFetcherInterface $dataFetcher
     * @return array<object>
     * @throws \Propel\Runtime\Exception\PropelException Any exceptions caught during processing will be
     *                         rethrown wrapped into a PropelException.
     */
    public static function populateObjects(DataFetcherInterface $dataFetcher): array
    {
        $results = [];

        // set the class once to avoid overhead in the loop
        $cls = static::getOMClass(false);
        // populate the object(s)
        while ($row = $dataFetcher->fetch()) {
            $key = RuleTableMap::getPrimaryKeyHashFromRow($row, 0, $dataFetcher->getIndexType());
            if (null !== ($obj = RuleTableMap::getInstanceFromPool($key))) {
                // We no longer rehydrate the object, since this can cause data loss.
                // See http://www.propelorm.org/ticket/509
                // $obj->hydrate($row, 0, true); // rehydrate
                $results[] = $obj;
            } else {
                /** @var Rule $obj */
                $obj = new $cls();
                $obj->hydrate($row);
                $results[] = $obj;
                RuleTableMap::addInstanceToPool($obj, $key);
            } // if key exists
        }

        return $results;
    }
    /**
     * Add all the columns needed to create a new object.
     *
     * Note: any columns that were marked with lazyLoad="true" in the
     * XML schema will not be added to the select list and only loaded
     * on demand.
     *
     * @param Criteria $criteria Object containing the columns to add.
     * @param string|null $alias Optional table alias
     * @throws \Propel\Runtime\Exception\PropelException Any exceptions caught during processing will be
     *                         rethrown wrapped into a PropelException.
     * @return void
     */
    public static function addSelectColumns(Criteria $criteria, ?string $alias = null): void
    {
        if (null === $alias) {
            $criteria->addSelectColumn(RuleTableMap::COL_ID);
            $criteria->addSelectColumn(RuleTableMap::COL_GROUP);
            $criteria->addSelectColumn(RuleTableMap::COL_USER);
            $criteria->addSelectColumn(RuleTableMap::COL_OPR_ID);
            $criteria->addSelectColumn(RuleTableMap::COL_OBJECT);
            $criteria->addSelectColumn(RuleTableMap::COL_OBJECT_ID);
            $criteria->addSelectColumn(RuleTableMap::COL_RLS_ACCESS);
        } else {
            $criteria->addSelectColumn($alias . '.id');
            $criteria->addSelectColumn($alias . '.group');
            $criteria->addSelectColumn($alias . '.user');
            $criteria->addSelectColumn($alias . '.opr_id');
            $criteria->addSelectColumn($alias . '.object');
            $criteria->addSelectColumn($alias . '.object_id');
            $criteria->addSelectColumn($alias . '.rls_access');
        }
    }

    /**
     * Remove all the columns needed to create a new object.
     *
     * Note: any columns that were marked with lazyLoad="true" in the
     * XML schema will not be removed as they are only loaded on demand.
     *
     * @param Criteria $criteria Object containing the columns to remove.
     * @param string|null $alias Optional table alias
     * @throws \Propel\Runtime\Exception\PropelException Any exceptions caught during processing will be
     *                         rethrown wrapped into a PropelException.
     * @return void
     */
    public static function removeSelectColumns(Criteria $criteria, ?string $alias = null): void
    {
        if (null === $alias) {
            $criteria->removeSelectColumn(RuleTableMap::COL_ID);
            $criteria->removeSelectColumn(RuleTableMap::COL_GROUP);
            $criteria->removeSelectColumn(RuleTableMap::COL_USER);
            $criteria->removeSelectColumn(RuleTableMap::COL_OPR_ID);
            $criteria->removeSelectColumn(RuleTableMap::COL_OBJECT);
            $criteria->removeSelectColumn(RuleTableMap::COL_OBJECT_ID);
            $criteria->removeSelectColumn(RuleTableMap::COL_RLS_ACCESS);
        } else {
            $criteria->removeSelectColumn($alias . '.id');
            $criteria->removeSelectColumn($alias . '.group');
            $criteria->removeSelectColumn($alias . '.user');
            $criteria->removeSelectColumn($alias . '.opr_id');
            $criteria->removeSelectColumn($alias . '.object');
            $criteria->removeSelectColumn($alias . '.object_id');
            $criteria->removeSelectColumn($alias . '.rls_access');
        }
    }

    /**
     * Returns the TableMap related to this object.
     * This method is not needed for general use but a specific application could have a need.
     * @return TableMap
     * @throws \Propel\Runtime\Exception\PropelException Any exceptions caught during processing will be
     *                         rethrown wrapped into a PropelException.
     */
    public static function getTableMap(): TableMap
    {
        return Propel::getServiceContainer()->getDatabaseMap(RuleTableMap::DATABASE_NAME)->getTable(RuleTableMap::TABLE_NAME);
    }

    /**
     * Performs a DELETE on the database, given a Rule or Criteria object OR a primary key value.
     *
     * @param mixed $values Criteria or Rule object or primary key or array of primary keys
     *              which is used to create the DELETE statement
     * @param ConnectionInterface $con the connection to use
     * @return int The number of affected rows (if supported by underlying database driver).  This includes CASCADE-related rows
     *                         if supported by native driver or if emulated using Propel.
     * @throws \Propel\Runtime\Exception\PropelException Any exceptions caught during processing will be
     *                         rethrown wrapped into a PropelException.
     */
     public static function doDelete($values, ?ConnectionInterface $con = null): int
     {
        if (null === $con) {
            $con = Propel::getServiceContainer()->getWriteConnection(RuleTableMap::DATABASE_NAME);
        }

        if ($values instanceof Criteria) {
            // rename for clarity
            $criteria = $values;
        } elseif ($values instanceof \Diamond\Infrastructure\Models\Rule\Rule) { // it's a model object
            // create criteria based on pk values
            $criteria = $values->buildPkeyCriteria();
        } else { // it's a primary key, or an array of pks
            $criteria = new Criteria(RuleTableMap::DATABASE_NAME);
            $criteria->add(RuleTableMap::COL_ID, (array) $values, Criteria::IN);
        }

        $query = RuleQuery::create()->mergeWith($criteria);

        if ($values instanceof Criteria) {
            RuleTableMap::clearInstancePool();
        } elseif (!is_object($values)) { // it's a primary key, or an array of pks
            foreach ((array) $values as $singleval) {
                RuleTableMap::removeInstanceFromPool($singleval);
            }
        }

        return $query->delete($con);
    }

    /**
     * Deletes all rows from the _rules table.
     *
     * @param ConnectionInterface $con the connection to use
     * @return int The number of affected rows (if supported by underlying database driver).
     */
    public static function doDeleteAll(?ConnectionInterface $con = null): int
    {
        return RuleQuery::create()->doDeleteAll($con);
    }

    /**
     * Performs an INSERT on the database, given a Rule or Criteria object.
     *
     * @param mixed $criteria Criteria or Rule object containing data that is used to create the INSERT statement.
     * @param ConnectionInterface $con the ConnectionInterface connection to use
     * @return mixed The new primary key.
     * @throws \Propel\Runtime\Exception\PropelException Any exceptions caught during processing will be
     *                         rethrown wrapped into a PropelException.
     */
    public static function doInsert($criteria, ?ConnectionInterface $con = null)
    {
        if (null === $con) {
            $con = Propel::getServiceContainer()->getWriteConnection(RuleTableMap::DATABASE_NAME);
        }

        if ($criteria instanceof Criteria) {
            $criteria = clone $criteria; // rename for clarity
        } else {
            $criteria = $criteria->buildCriteria(); // build Criteria from Rule object
        }

        if ($criteria->containsKey(RuleTableMap::COL_ID) && $criteria->keyContainsValue(RuleTableMap::COL_ID) ) {
            throw new PropelException('Cannot insert a value for auto-increment primary key ('.RuleTableMap::COL_ID.')');
        }


        // Set the correct dbName
        $query = RuleQuery::create()->mergeWith($criteria);

        // use transaction because $criteria could contain info
        // for more than one table (I guess, conceivably)
        return $con->transaction(function () use ($con, $query) {
            return $query->doInsert($con);
        });
    }

}
