<?php

namespace Diamond\Infrastructure\Models\Menu\Map;

use Diamond\Infrastructure\Models\Menu\Menu;
use Diamond\Infrastructure\Models\Menu\MenuQuery;
use Propel\Runtime\Propel;
use Propel\Runtime\ActiveQuery\Criteria;
use Propel\Runtime\ActiveQuery\InstancePoolTrait;
use Propel\Runtime\Connection\ConnectionInterface;
use Propel\Runtime\DataFetcher\DataFetcherInterface;
use Propel\Runtime\Exception\PropelException;
use Propel\Runtime\Map\RelationMap;
use Propel\Runtime\Map\TableMap;
use Propel\Runtime\Map\TableMapTrait;


/**
 * This class defines the structure of the '_menu' table.
 *
 *
 *
 * This map class is used by Propel to do runtime db structure discovery.
 * For example, the createSelectSql() method checks the type of a given column used in an
 * ORDER BY clause to know whether it needs to apply SQL to make the ORDER BY case-insensitive
 * (i.e. if it's a text column type).
 */
class MenuTableMap extends TableMap
{
    use InstancePoolTrait;
    use TableMapTrait;

    /**
     * The (dot-path) name of this class
     */
    public const CLASS_NAME = 'Diamond.Infrastructure.Models.Menu.Map.MenuTableMap';

    /**
     * The default database name for this class
     */
    public const DATABASE_NAME = 'default';

    /**
     * The table name for this class
     */
    public const TABLE_NAME = '_menu';

    /**
     * The related Propel class for this table
     */
    public const OM_CLASS = '\\Diamond\\Infrastructure\\Models\\Menu\\Menu';

    /**
     * A class that can be returned by this tableMap
     */
    public const CLASS_DEFAULT = 'Diamond.Infrastructure.Models.Menu.Menu';

    /**
     * The total number of columns
     */
    public const NUM_COLUMNS = 10;

    /**
     * The number of lazy-loaded columns
     */
    public const NUM_LAZY_LOAD_COLUMNS = 0;

    /**
     * The number of columns to hydrate (NUM_COLUMNS - NUM_LAZY_LOAD_COLUMNS)
     */
    public const NUM_HYDRATE_COLUMNS = 10;

    /**
     * the column name for the id field
     */
    public const COL_ID = '_menu.id';

    /**
     * the column name for the title field
     */
    public const COL_TITLE = '_menu.title';

    /**
     * the column name for the url field
     */
    public const COL_URL = '_menu.url';

    /**
     * the column name for the parent_id field
     */
    public const COL_PARENT_ID = '_menu.parent_id';

    /**
     * the column name for the name field
     */
    public const COL_NAME = '_menu.name';

    /**
     * the column name for the position field
     */
    public const COL_POSITION = '_menu.position';

    /**
     * the column name for the code field
     */
    public const COL_CODE = '_menu.code';

    /**
     * the column name for the description field
     */
    public const COL_DESCRIPTION = '_menu.description';

    /**
     * the column name for the active field
     */
    public const COL_ACTIVE = '_menu.active';

    /**
     * the column name for the domain_id field
     */
    public const COL_DOMAIN_ID = '_menu.domain_id';

    /**
     * The default string format for model objects of the related table
     */
    public const DEFAULT_STRING_FORMAT = 'YAML';

    /**
     * holds an array of fieldnames
     *
     * first dimension keys are the type constants
     * e.g. self::$fieldNames[self::TYPE_PHPNAME][0] = 'Id'
     *
     * @var array<string, mixed>
     */
    protected static $fieldNames = [
        self::TYPE_PHPNAME       => ['Id', 'Title', 'Url', 'ParentId', 'Name', 'Position', 'Code', 'Desc', 'Active', 'DomainId', ],
        self::TYPE_CAMELNAME     => ['id', 'title', 'url', 'parentId', 'name', 'position', 'code', 'desc', 'active', 'domainId', ],
        self::TYPE_COLNAME       => [MenuTableMap::COL_ID, MenuTableMap::COL_TITLE, MenuTableMap::COL_URL, MenuTableMap::COL_PARENT_ID, MenuTableMap::COL_NAME, MenuTableMap::COL_POSITION, MenuTableMap::COL_CODE, MenuTableMap::COL_DESCRIPTION, MenuTableMap::COL_ACTIVE, MenuTableMap::COL_DOMAIN_ID, ],
        self::TYPE_FIELDNAME     => ['id', 'title', 'url', 'parent_id', 'name', 'position', 'code', 'description', 'active', 'domain_id', ],
        self::TYPE_NUM           => [0, 1, 2, 3, 4, 5, 6, 7, 8, 9, ]
    ];

    /**
     * holds an array of keys for quick access to the fieldnames array
     *
     * first dimension keys are the type constants
     * e.g. self::$fieldKeys[self::TYPE_PHPNAME]['Id'] = 0
     *
     * @var array<string, mixed>
     */
    protected static $fieldKeys = [
        self::TYPE_PHPNAME       => ['Id' => 0, 'Title' => 1, 'Url' => 2, 'ParentId' => 3, 'Name' => 4, 'Position' => 5, 'Code' => 6, 'Desc' => 7, 'Active' => 8, 'DomainId' => 9, ],
        self::TYPE_CAMELNAME     => ['id' => 0, 'title' => 1, 'url' => 2, 'parentId' => 3, 'name' => 4, 'position' => 5, 'code' => 6, 'desc' => 7, 'active' => 8, 'domainId' => 9, ],
        self::TYPE_COLNAME       => [MenuTableMap::COL_ID => 0, MenuTableMap::COL_TITLE => 1, MenuTableMap::COL_URL => 2, MenuTableMap::COL_PARENT_ID => 3, MenuTableMap::COL_NAME => 4, MenuTableMap::COL_POSITION => 5, MenuTableMap::COL_CODE => 6, MenuTableMap::COL_DESCRIPTION => 7, MenuTableMap::COL_ACTIVE => 8, MenuTableMap::COL_DOMAIN_ID => 9, ],
        self::TYPE_FIELDNAME     => ['id' => 0, 'title' => 1, 'url' => 2, 'parent_id' => 3, 'name' => 4, 'position' => 5, 'code' => 6, 'description' => 7, 'active' => 8, 'domain_id' => 9, ],
        self::TYPE_NUM           => [0, 1, 2, 3, 4, 5, 6, 7, 8, 9, ]
    ];

    /**
     * Holds a list of column names and their normalized version.
     *
     * @var array<string>
     */
    protected $normalizedColumnNameMap = [
        'Id' => 'ID',
        'Menu.Id' => 'ID',
        'id' => 'ID',
        'menu.id' => 'ID',
        'MenuTableMap::COL_ID' => 'ID',
        'COL_ID' => 'ID',
        '_menu.id' => 'ID',
        'Title' => 'TITLE',
        'Menu.Title' => 'TITLE',
        'title' => 'TITLE',
        'menu.title' => 'TITLE',
        'MenuTableMap::COL_TITLE' => 'TITLE',
        'COL_TITLE' => 'TITLE',
        '_menu.title' => 'TITLE',
        'Url' => 'URL',
        'Menu.Url' => 'URL',
        'url' => 'URL',
        'menu.url' => 'URL',
        'MenuTableMap::COL_URL' => 'URL',
        'COL_URL' => 'URL',
        '_menu.url' => 'URL',
        'ParentId' => 'PARENT_ID',
        'Menu.ParentId' => 'PARENT_ID',
        'parentId' => 'PARENT_ID',
        'menu.parentId' => 'PARENT_ID',
        'MenuTableMap::COL_PARENT_ID' => 'PARENT_ID',
        'COL_PARENT_ID' => 'PARENT_ID',
        'parent_id' => 'PARENT_ID',
        '_menu.parent_id' => 'PARENT_ID',
        'Name' => 'NAME',
        'Menu.Name' => 'NAME',
        'name' => 'NAME',
        'menu.name' => 'NAME',
        'MenuTableMap::COL_NAME' => 'NAME',
        'COL_NAME' => 'NAME',
        '_menu.name' => 'NAME',
        'Position' => 'POSITION',
        'Menu.Position' => 'POSITION',
        'position' => 'POSITION',
        'menu.position' => 'POSITION',
        'MenuTableMap::COL_POSITION' => 'POSITION',
        'COL_POSITION' => 'POSITION',
        '_menu.position' => 'POSITION',
        'Code' => 'CODE',
        'Menu.Code' => 'CODE',
        'code' => 'CODE',
        'menu.code' => 'CODE',
        'MenuTableMap::COL_CODE' => 'CODE',
        'COL_CODE' => 'CODE',
        '_menu.code' => 'CODE',
        'Desc' => 'DESCRIPTION',
        'Menu.Desc' => 'DESCRIPTION',
        'desc' => 'DESCRIPTION',
        'menu.desc' => 'DESCRIPTION',
        'MenuTableMap::COL_DESCRIPTION' => 'DESCRIPTION',
        'COL_DESCRIPTION' => 'DESCRIPTION',
        'description' => 'DESCRIPTION',
        '_menu.description' => 'DESCRIPTION',
        'Active' => 'ACTIVE',
        'Menu.Active' => 'ACTIVE',
        'active' => 'ACTIVE',
        'menu.active' => 'ACTIVE',
        'MenuTableMap::COL_ACTIVE' => 'ACTIVE',
        'COL_ACTIVE' => 'ACTIVE',
        '_menu.active' => 'ACTIVE',
        'DomainId' => 'DOMAIN_ID',
        'Menu.DomainId' => 'DOMAIN_ID',
        'domainId' => 'DOMAIN_ID',
        'menu.domainId' => 'DOMAIN_ID',
        'MenuTableMap::COL_DOMAIN_ID' => 'DOMAIN_ID',
        'COL_DOMAIN_ID' => 'DOMAIN_ID',
        'domain_id' => 'DOMAIN_ID',
        '_menu.domain_id' => 'DOMAIN_ID',
    ];

    /**
     * Initialize the table attributes and columns
     * Relations are not initialized by this method since they are lazy loaded
     *
     * @return void
     * @throws \Propel\Runtime\Exception\PropelException
     */
    public function initialize(): void
    {
        // attributes
        $this->setName('_menu');
        $this->setPhpName('Menu');
        $this->setIdentifierQuoting(true);
        $this->setClassName('\\Diamond\\Infrastructure\\Models\\Menu\\Menu');
        $this->setPackage('Diamond.Infrastructure.Models.Menu');
        $this->setUseIdGenerator(true);
        // columns
        $this->addPrimaryKey('id', 'Id', 'INTEGER', true, null, null);
        $this->addColumn('title', 'Title', 'VARCHAR', true, 120, null);
        $this->addColumn('url', 'Url', 'VARCHAR', true, 255, null);
        $this->addColumn('parent_id', 'ParentId', 'INTEGER', false, null, null);
        $this->addColumn('name', 'Name', 'VARCHAR', false, 50, null);
        $this->addColumn('position', 'Position', 'INTEGER', true, null, 0);
        $this->addColumn('code', 'Code', 'VARCHAR', false, 50, null);
        $this->addColumn('description', 'Desc', 'VARCHAR', false, 255, null);
        $this->addColumn('active', 'Active', 'CHAR', false, null, 'Y');
        $this->addForeignKey('domain_id', 'DomainId', 'INTEGER', '_domains', 'id', true, null, null);
    }

    /**
     * Build the RelationMap objects for this table relationships
     *
     * @return void
     */
    public function buildRelations(): void
    {
        $this->addRelation('Domain', '\\Diamond\\Infrastructure\\Models\\Domain\\Domain', RelationMap::MANY_TO_ONE, array (
  0 =>
  array (
    0 => ':domain_id',
    1 => ':id',
  ),
), null, null, null, false);
    }

    /**
     *
     * Gets the list of behaviors registered for this table
     *
     * @return array<string, array> Associative array (name => parameters) of behaviors
     */
    public function getBehaviors(): array
    {
        return [
            'archivable' => ['archive_table' => '', 'archive_phpname' => NULL, 'archive_class' => '', 'log_archived_at' => 'true', 'archived_at_column' => 'archived_at', 'archive_on_insert' => 'false', 'archive_on_update' => 'false', 'archive_on_delete' => 'true'],
        ];
    }

    /**
     * Retrieves a string version of the primary key from the DB resultset row that can be used to uniquely identify a row in this table.
     *
     * For tables with a single-column primary key, that simple pkey value will be returned.  For tables with
     * a multi-column primary key, a serialize()d version of the primary key will be returned.
     *
     * @param array $row Resultset row.
     * @param int $offset The 0-based offset for reading from the resultset row.
     * @param string $indexType One of the class type constants TableMap::TYPE_PHPNAME, TableMap::TYPE_CAMELNAME
     *                           TableMap::TYPE_COLNAME, TableMap::TYPE_FIELDNAME, TableMap::TYPE_NUM
     *
     * @return string|null The primary key hash of the row
     */
    public static function getPrimaryKeyHashFromRow(array $row, int $offset = 0, string $indexType = TableMap::TYPE_NUM): ?string
    {
        // If the PK cannot be derived from the row, return NULL.
        if ($row[TableMap::TYPE_NUM == $indexType ? 0 + $offset : static::translateFieldName('Id', TableMap::TYPE_PHPNAME, $indexType)] === null) {
            return null;
        }

        return null === $row[TableMap::TYPE_NUM == $indexType ? 0 + $offset : static::translateFieldName('Id', TableMap::TYPE_PHPNAME, $indexType)] || is_scalar($row[TableMap::TYPE_NUM == $indexType ? 0 + $offset : static::translateFieldName('Id', TableMap::TYPE_PHPNAME, $indexType)]) || is_callable([$row[TableMap::TYPE_NUM == $indexType ? 0 + $offset : static::translateFieldName('Id', TableMap::TYPE_PHPNAME, $indexType)], '__toString']) ? (string) $row[TableMap::TYPE_NUM == $indexType ? 0 + $offset : static::translateFieldName('Id', TableMap::TYPE_PHPNAME, $indexType)] : $row[TableMap::TYPE_NUM == $indexType ? 0 + $offset : static::translateFieldName('Id', TableMap::TYPE_PHPNAME, $indexType)];
    }

    /**
     * Retrieves the primary key from the DB resultset row
     * For tables with a single-column primary key, that simple pkey value will be returned.  For tables with
     * a multi-column primary key, an array of the primary key columns will be returned.
     *
     * @param array $row Resultset row.
     * @param int $offset The 0-based offset for reading from the resultset row.
     * @param string $indexType One of the class type constants TableMap::TYPE_PHPNAME, TableMap::TYPE_CAMELNAME
     *                           TableMap::TYPE_COLNAME, TableMap::TYPE_FIELDNAME, TableMap::TYPE_NUM
     *
     * @return mixed The primary key of the row
     */
    public static function getPrimaryKeyFromRow(array $row, int $offset = 0, string $indexType = TableMap::TYPE_NUM)
    {
        return (int) $row[
            $indexType == TableMap::TYPE_NUM
                ? 0 + $offset
                : self::translateFieldName('Id', TableMap::TYPE_PHPNAME, $indexType)
        ];
    }

    /**
     * The class that the tableMap will make instances of.
     *
     * If $withPrefix is true, the returned path
     * uses a dot-path notation which is translated into a path
     * relative to a location on the PHP include_path.
     * (e.g. path.to.MyClass -> 'path/to/MyClass.php')
     *
     * @param bool $withPrefix Whether to return the path with the class name
     * @return string path.to.ClassName
     */
    public static function getOMClass(bool $withPrefix = true): string
    {
        return $withPrefix ? MenuTableMap::CLASS_DEFAULT : MenuTableMap::OM_CLASS;
    }

    /**
     * Populates an object of the default type or an object that inherit from the default.
     *
     * @param array $row Row returned by DataFetcher->fetch().
     * @param int $offset The 0-based offset for reading from the resultset row.
     * @param string $indexType The index type of $row. Mostly DataFetcher->getIndexType().
                                 One of the class type constants TableMap::TYPE_PHPNAME, TableMap::TYPE_CAMELNAME
     *                           TableMap::TYPE_COLNAME, TableMap::TYPE_FIELDNAME, TableMap::TYPE_NUM.
     *
     * @throws \Propel\Runtime\Exception\PropelException Any exceptions caught during processing will be
     *                         rethrown wrapped into a PropelException.
     * @return array (Menu object, last column rank)
     */
    public static function populateObject(array $row, int $offset = 0, string $indexType = TableMap::TYPE_NUM): array
    {
        $key = MenuTableMap::getPrimaryKeyHashFromRow($row, $offset, $indexType);
        if (null !== ($obj = MenuTableMap::getInstanceFromPool($key))) {
            // We no longer rehydrate the object, since this can cause data loss.
            // See http://www.propelorm.org/ticket/509
            // $obj->hydrate($row, $offset, true); // rehydrate
            $col = $offset + MenuTableMap::NUM_HYDRATE_COLUMNS;
        } else {
            $cls = MenuTableMap::OM_CLASS;
            /** @var Menu $obj */
            $obj = new $cls();
            $col = $obj->hydrate($row, $offset, false, $indexType);
            MenuTableMap::addInstanceToPool($obj, $key);
        }

        return array($obj, $col);
    }

    /**
     * The returned array will contain objects of the default type or
     * objects that inherit from the default.
     *
     * @param DataFetcherInterface $dataFetcher
     * @return array<object>
     * @throws \Propel\Runtime\Exception\PropelException Any exceptions caught during processing will be
     *                         rethrown wrapped into a PropelException.
     */
    public static function populateObjects(DataFetcherInterface $dataFetcher): array
    {
        $results = [];

        // set the class once to avoid overhead in the loop
        $cls = static::getOMClass(false);
        // populate the object(s)
        while ($row = $dataFetcher->fetch()) {
            $key = MenuTableMap::getPrimaryKeyHashFromRow($row, 0, $dataFetcher->getIndexType());
            if (null !== ($obj = MenuTableMap::getInstanceFromPool($key))) {
                // We no longer rehydrate the object, since this can cause data loss.
                // See http://www.propelorm.org/ticket/509
                // $obj->hydrate($row, 0, true); // rehydrate
                $results[] = $obj;
            } else {
                /** @var Menu $obj */
                $obj = new $cls();
                $obj->hydrate($row);
                $results[] = $obj;
                MenuTableMap::addInstanceToPool($obj, $key);
            } // if key exists
        }

        return $results;
    }
    /**
     * Add all the columns needed to create a new object.
     *
     * Note: any columns that were marked with lazyLoad="true" in the
     * XML schema will not be added to the select list and only loaded
     * on demand.
     *
     * @param Criteria $criteria Object containing the columns to add.
     * @param string|null $alias Optional table alias
     * @throws \Propel\Runtime\Exception\PropelException Any exceptions caught during processing will be
     *                         rethrown wrapped into a PropelException.
     * @return void
     */
    public static function addSelectColumns(Criteria $criteria, ?string $alias = null): void
    {
        if (null === $alias) {
            $criteria->addSelectColumn(MenuTableMap::COL_ID);
            $criteria->addSelectColumn(MenuTableMap::COL_TITLE);
            $criteria->addSelectColumn(MenuTableMap::COL_URL);
            $criteria->addSelectColumn(MenuTableMap::COL_PARENT_ID);
            $criteria->addSelectColumn(MenuTableMap::COL_NAME);
            $criteria->addSelectColumn(MenuTableMap::COL_POSITION);
            $criteria->addSelectColumn(MenuTableMap::COL_CODE);
            $criteria->addSelectColumn(MenuTableMap::COL_DESCRIPTION);
            $criteria->addSelectColumn(MenuTableMap::COL_ACTIVE);
            $criteria->addSelectColumn(MenuTableMap::COL_DOMAIN_ID);
        } else {
            $criteria->addSelectColumn($alias . '.id');
            $criteria->addSelectColumn($alias . '.title');
            $criteria->addSelectColumn($alias . '.url');
            $criteria->addSelectColumn($alias . '.parent_id');
            $criteria->addSelectColumn($alias . '.name');
            $criteria->addSelectColumn($alias . '.position');
            $criteria->addSelectColumn($alias . '.code');
            $criteria->addSelectColumn($alias . '.description');
            $criteria->addSelectColumn($alias . '.active');
            $criteria->addSelectColumn($alias . '.domain_id');
        }
    }

    /**
     * Remove all the columns needed to create a new object.
     *
     * Note: any columns that were marked with lazyLoad="true" in the
     * XML schema will not be removed as they are only loaded on demand.
     *
     * @param Criteria $criteria Object containing the columns to remove.
     * @param string|null $alias Optional table alias
     * @throws \Propel\Runtime\Exception\PropelException Any exceptions caught during processing will be
     *                         rethrown wrapped into a PropelException.
     * @return void
     */
    public static function removeSelectColumns(Criteria $criteria, ?string $alias = null): void
    {
        if (null === $alias) {
            $criteria->removeSelectColumn(MenuTableMap::COL_ID);
            $criteria->removeSelectColumn(MenuTableMap::COL_TITLE);
            $criteria->removeSelectColumn(MenuTableMap::COL_URL);
            $criteria->removeSelectColumn(MenuTableMap::COL_PARENT_ID);
            $criteria->removeSelectColumn(MenuTableMap::COL_NAME);
            $criteria->removeSelectColumn(MenuTableMap::COL_POSITION);
            $criteria->removeSelectColumn(MenuTableMap::COL_CODE);
            $criteria->removeSelectColumn(MenuTableMap::COL_DESCRIPTION);
            $criteria->removeSelectColumn(MenuTableMap::COL_ACTIVE);
            $criteria->removeSelectColumn(MenuTableMap::COL_DOMAIN_ID);
        } else {
            $criteria->removeSelectColumn($alias . '.id');
            $criteria->removeSelectColumn($alias . '.title');
            $criteria->removeSelectColumn($alias . '.url');
            $criteria->removeSelectColumn($alias . '.parent_id');
            $criteria->removeSelectColumn($alias . '.name');
            $criteria->removeSelectColumn($alias . '.position');
            $criteria->removeSelectColumn($alias . '.code');
            $criteria->removeSelectColumn($alias . '.description');
            $criteria->removeSelectColumn($alias . '.active');
            $criteria->removeSelectColumn($alias . '.domain_id');
        }
    }

    /**
     * Returns the TableMap related to this object.
     * This method is not needed for general use but a specific application could have a need.
     * @return TableMap
     * @throws \Propel\Runtime\Exception\PropelException Any exceptions caught during processing will be
     *                         rethrown wrapped into a PropelException.
     */
    public static function getTableMap(): TableMap
    {
        return Propel::getServiceContainer()->getDatabaseMap(MenuTableMap::DATABASE_NAME)->getTable(MenuTableMap::TABLE_NAME);
    }

    /**
     * Performs a DELETE on the database, given a Menu or Criteria object OR a primary key value.
     *
     * @param mixed $values Criteria or Menu object or primary key or array of primary keys
     *              which is used to create the DELETE statement
     * @param ConnectionInterface $con the connection to use
     * @return int The number of affected rows (if supported by underlying database driver).  This includes CASCADE-related rows
     *                         if supported by native driver or if emulated using Propel.
     * @throws \Propel\Runtime\Exception\PropelException Any exceptions caught during processing will be
     *                         rethrown wrapped into a PropelException.
     */
     public static function doDelete($values, ?ConnectionInterface $con = null): int
     {
        if (null === $con) {
            $con = Propel::getServiceContainer()->getWriteConnection(MenuTableMap::DATABASE_NAME);
        }

        if ($values instanceof Criteria) {
            // rename for clarity
            $criteria = $values;
        } elseif ($values instanceof \Diamond\Infrastructure\Models\Menu\Menu) { // it's a model object
            // create criteria based on pk values
            $criteria = $values->buildPkeyCriteria();
        } else { // it's a primary key, or an array of pks
            $criteria = new Criteria(MenuTableMap::DATABASE_NAME);
            $criteria->add(MenuTableMap::COL_ID, (array) $values, Criteria::IN);
        }

        $query = MenuQuery::create()->mergeWith($criteria);

        if ($values instanceof Criteria) {
            MenuTableMap::clearInstancePool();
        } elseif (!is_object($values)) { // it's a primary key, or an array of pks
            foreach ((array) $values as $singleval) {
                MenuTableMap::removeInstanceFromPool($singleval);
            }
        }

        return $query->delete($con);
    }

    /**
     * Deletes all rows from the _menu table.
     *
     * @param ConnectionInterface $con the connection to use
     * @return int The number of affected rows (if supported by underlying database driver).
     */
    public static function doDeleteAll(?ConnectionInterface $con = null): int
    {
        return MenuQuery::create()->doDeleteAll($con);
    }

    /**
     * Performs an INSERT on the database, given a Menu or Criteria object.
     *
     * @param mixed $criteria Criteria or Menu object containing data that is used to create the INSERT statement.
     * @param ConnectionInterface $con the ConnectionInterface connection to use
     * @return mixed The new primary key.
     * @throws \Propel\Runtime\Exception\PropelException Any exceptions caught during processing will be
     *                         rethrown wrapped into a PropelException.
     */
    public static function doInsert($criteria, ?ConnectionInterface $con = null)
    {
        if (null === $con) {
            $con = Propel::getServiceContainer()->getWriteConnection(MenuTableMap::DATABASE_NAME);
        }

        if ($criteria instanceof Criteria) {
            $criteria = clone $criteria; // rename for clarity
        } else {
            $criteria = $criteria->buildCriteria(); // build Criteria from Menu object
        }

        if ($criteria->containsKey(MenuTableMap::COL_ID) && $criteria->keyContainsValue(MenuTableMap::COL_ID) ) {
            throw new PropelException('Cannot insert a value for auto-increment primary key ('.MenuTableMap::COL_ID.')');
        }


        // Set the correct dbName
        $query = MenuQuery::create()->mergeWith($criteria);

        // use transaction because $criteria could contain info
        // for more than one table (I guess, conceivably)
        return $con->transaction(function () use ($con, $query) {
            return $query->doInsert($con);
        });
    }

}
