<?php

namespace Diamond\Infrastructure\Models\MailingRequestRecipient\Base;

use \Exception;
use \PDO;
use Diamond\Infrastructure\Models\MailingRequest\MailingRequest;
use Diamond\Infrastructure\Models\MailingRequestRecipient\MailingRequestRecipient as ChildMailingRequestRecipient;
use Diamond\Infrastructure\Models\MailingRequestRecipient\MailingRequestRecipientQuery as ChildMailingRequestRecipientQuery;
use Diamond\Infrastructure\Models\MailingRequestRecipient\Map\MailingRequestRecipientTableMap;
use Propel\Runtime\Propel;
use Propel\Runtime\ActiveQuery\Criteria;
use Propel\Runtime\ActiveQuery\ModelCriteria;
use Propel\Runtime\ActiveQuery\ModelJoin;
use Propel\Runtime\Collection\Collection;
use Propel\Runtime\Collection\ObjectCollection;
use Propel\Runtime\Connection\ConnectionInterface;
use Propel\Runtime\Exception\PropelException;

/**
 * Base class that represents a query for the '_mailing_request_recipients' table.
 *
 *
 *
 * @method     ChildMailingRequestRecipientQuery orderById($order = Criteria::ASC) Order by the id column
 * @method     ChildMailingRequestRecipientQuery orderByEmail($order = Criteria::ASC) Order by the email column
 * @method     ChildMailingRequestRecipientQuery orderByRequestId($order = Criteria::ASC) Order by the request_id column
 * @method     ChildMailingRequestRecipientQuery orderByCreatedAt($order = Criteria::ASC) Order by the created_at column
 * @method     ChildMailingRequestRecipientQuery orderBySendingAt($order = Criteria::ASC) Order by the sending_at column
 * @method     ChildMailingRequestRecipientQuery orderByViewedAt($order = Criteria::ASC) Order by the viewed_at column
 * @method     ChildMailingRequestRecipientQuery orderByStatus($order = Criteria::ASC) Order by the status column
 *
 * @method     ChildMailingRequestRecipientQuery groupById() Group by the id column
 * @method     ChildMailingRequestRecipientQuery groupByEmail() Group by the email column
 * @method     ChildMailingRequestRecipientQuery groupByRequestId() Group by the request_id column
 * @method     ChildMailingRequestRecipientQuery groupByCreatedAt() Group by the created_at column
 * @method     ChildMailingRequestRecipientQuery groupBySendingAt() Group by the sending_at column
 * @method     ChildMailingRequestRecipientQuery groupByViewedAt() Group by the viewed_at column
 * @method     ChildMailingRequestRecipientQuery groupByStatus() Group by the status column
 *
 * @method     ChildMailingRequestRecipientQuery leftJoin($relation) Adds a LEFT JOIN clause to the query
 * @method     ChildMailingRequestRecipientQuery rightJoin($relation) Adds a RIGHT JOIN clause to the query
 * @method     ChildMailingRequestRecipientQuery innerJoin($relation) Adds a INNER JOIN clause to the query
 *
 * @method     ChildMailingRequestRecipientQuery leftJoinWith($relation) Adds a LEFT JOIN clause and with to the query
 * @method     ChildMailingRequestRecipientQuery rightJoinWith($relation) Adds a RIGHT JOIN clause and with to the query
 * @method     ChildMailingRequestRecipientQuery innerJoinWith($relation) Adds a INNER JOIN clause and with to the query
 *
 * @method     ChildMailingRequestRecipientQuery leftJoinMailingRequest($relationAlias = null) Adds a LEFT JOIN clause to the query using the MailingRequest relation
 * @method     ChildMailingRequestRecipientQuery rightJoinMailingRequest($relationAlias = null) Adds a RIGHT JOIN clause to the query using the MailingRequest relation
 * @method     ChildMailingRequestRecipientQuery innerJoinMailingRequest($relationAlias = null) Adds a INNER JOIN clause to the query using the MailingRequest relation
 *
 * @method     ChildMailingRequestRecipientQuery joinWithMailingRequest($joinType = Criteria::INNER_JOIN) Adds a join clause and with to the query using the MailingRequest relation
 *
 * @method     ChildMailingRequestRecipientQuery leftJoinWithMailingRequest() Adds a LEFT JOIN clause and with to the query using the MailingRequest relation
 * @method     ChildMailingRequestRecipientQuery rightJoinWithMailingRequest() Adds a RIGHT JOIN clause and with to the query using the MailingRequest relation
 * @method     ChildMailingRequestRecipientQuery innerJoinWithMailingRequest() Adds a INNER JOIN clause and with to the query using the MailingRequest relation
 *
 * @method     \Diamond\Infrastructure\Models\MailingRequest\MailingRequestQuery endUse() Finalizes a secondary criteria and merges it with its primary Criteria
 *
 * @method     ChildMailingRequestRecipient|null findOne(?ConnectionInterface $con = null) Return the first ChildMailingRequestRecipient matching the query
 * @method     ChildMailingRequestRecipient findOneOrCreate(?ConnectionInterface $con = null) Return the first ChildMailingRequestRecipient matching the query, or a new ChildMailingRequestRecipient object populated from the query conditions when no match is found
 *
 * @method     ChildMailingRequestRecipient|null findOneById(int $id) Return the first ChildMailingRequestRecipient filtered by the id column
 * @method     ChildMailingRequestRecipient|null findOneByEmail(string $email) Return the first ChildMailingRequestRecipient filtered by the email column
 * @method     ChildMailingRequestRecipient|null findOneByRequestId(int $request_id) Return the first ChildMailingRequestRecipient filtered by the request_id column
 * @method     ChildMailingRequestRecipient|null findOneByCreatedAt(string $created_at) Return the first ChildMailingRequestRecipient filtered by the created_at column
 * @method     ChildMailingRequestRecipient|null findOneBySendingAt(string $sending_at) Return the first ChildMailingRequestRecipient filtered by the sending_at column
 * @method     ChildMailingRequestRecipient|null findOneByViewedAt(string $viewed_at) Return the first ChildMailingRequestRecipient filtered by the viewed_at column
 * @method     ChildMailingRequestRecipient|null findOneByStatus(string $status) Return the first ChildMailingRequestRecipient filtered by the status column *

 * @method     ChildMailingRequestRecipient requirePk($key, ?ConnectionInterface $con = null) Return the ChildMailingRequestRecipient by primary key and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildMailingRequestRecipient requireOne(?ConnectionInterface $con = null) Return the first ChildMailingRequestRecipient matching the query and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 *
 * @method     ChildMailingRequestRecipient requireOneById(int $id) Return the first ChildMailingRequestRecipient filtered by the id column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildMailingRequestRecipient requireOneByEmail(string $email) Return the first ChildMailingRequestRecipient filtered by the email column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildMailingRequestRecipient requireOneByRequestId(int $request_id) Return the first ChildMailingRequestRecipient filtered by the request_id column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildMailingRequestRecipient requireOneByCreatedAt(string $created_at) Return the first ChildMailingRequestRecipient filtered by the created_at column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildMailingRequestRecipient requireOneBySendingAt(string $sending_at) Return the first ChildMailingRequestRecipient filtered by the sending_at column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildMailingRequestRecipient requireOneByViewedAt(string $viewed_at) Return the first ChildMailingRequestRecipient filtered by the viewed_at column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildMailingRequestRecipient requireOneByStatus(string $status) Return the first ChildMailingRequestRecipient filtered by the status column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 *
 * @method     ChildMailingRequestRecipient[]|Collection find(?ConnectionInterface $con = null) Return ChildMailingRequestRecipient objects based on current ModelCriteria
 * @psalm-method Collection&\Traversable<ChildMailingRequestRecipient> find(?ConnectionInterface $con = null) Return ChildMailingRequestRecipient objects based on current ModelCriteria
 * @method     ChildMailingRequestRecipient[]|Collection findById(int $id) Return ChildMailingRequestRecipient objects filtered by the id column
 * @psalm-method Collection&\Traversable<ChildMailingRequestRecipient> findById(int $id) Return ChildMailingRequestRecipient objects filtered by the id column
 * @method     ChildMailingRequestRecipient[]|Collection findByEmail(string $email) Return ChildMailingRequestRecipient objects filtered by the email column
 * @psalm-method Collection&\Traversable<ChildMailingRequestRecipient> findByEmail(string $email) Return ChildMailingRequestRecipient objects filtered by the email column
 * @method     ChildMailingRequestRecipient[]|Collection findByRequestId(int $request_id) Return ChildMailingRequestRecipient objects filtered by the request_id column
 * @psalm-method Collection&\Traversable<ChildMailingRequestRecipient> findByRequestId(int $request_id) Return ChildMailingRequestRecipient objects filtered by the request_id column
 * @method     ChildMailingRequestRecipient[]|Collection findByCreatedAt(string $created_at) Return ChildMailingRequestRecipient objects filtered by the created_at column
 * @psalm-method Collection&\Traversable<ChildMailingRequestRecipient> findByCreatedAt(string $created_at) Return ChildMailingRequestRecipient objects filtered by the created_at column
 * @method     ChildMailingRequestRecipient[]|Collection findBySendingAt(string $sending_at) Return ChildMailingRequestRecipient objects filtered by the sending_at column
 * @psalm-method Collection&\Traversable<ChildMailingRequestRecipient> findBySendingAt(string $sending_at) Return ChildMailingRequestRecipient objects filtered by the sending_at column
 * @method     ChildMailingRequestRecipient[]|Collection findByViewedAt(string $viewed_at) Return ChildMailingRequestRecipient objects filtered by the viewed_at column
 * @psalm-method Collection&\Traversable<ChildMailingRequestRecipient> findByViewedAt(string $viewed_at) Return ChildMailingRequestRecipient objects filtered by the viewed_at column
 * @method     ChildMailingRequestRecipient[]|Collection findByStatus(string $status) Return ChildMailingRequestRecipient objects filtered by the status column
 * @psalm-method Collection&\Traversable<ChildMailingRequestRecipient> findByStatus(string $status) Return ChildMailingRequestRecipient objects filtered by the status column
 * @method     ChildMailingRequestRecipient[]|\Propel\Runtime\Util\PropelModelPager paginate($page = 1, $maxPerPage = 10, ?ConnectionInterface $con = null) Issue a SELECT query based on the current ModelCriteria and uses a page and a maximum number of results per page to compute an offset and a limit
 * @psalm-method \Propel\Runtime\Util\PropelModelPager&\Traversable<ChildMailingRequestRecipient> paginate($page = 1, $maxPerPage = 10, ?ConnectionInterface $con = null) Issue a SELECT query based on the current ModelCriteria and uses a page and a maximum number of results per page to compute an offset and a limit
 *
 */
abstract class MailingRequestRecipientQuery extends ModelCriteria
{
    protected $entityNotFoundExceptionClass = '\\Propel\\Runtime\\Exception\\EntityNotFoundException';

    /**
     * Initializes internal state of \Diamond\Infrastructure\Models\MailingRequestRecipient\Base\MailingRequestRecipientQuery object.
     *
     * @param string $dbName The database name
     * @param string $modelName The phpName of a model, e.g. 'Book'
     * @param string $modelAlias The alias for the model in this query, e.g. 'b'
     */
    public function __construct($dbName = 'default', $modelName = '\\Diamond\\Infrastructure\\Models\\MailingRequestRecipient\\MailingRequestRecipient', $modelAlias = null)
    {
        parent::__construct($dbName, $modelName, $modelAlias);
    }

    /**
     * Returns a new ChildMailingRequestRecipientQuery object.
     *
     * @param string $modelAlias The alias of a model in the query
     * @param Criteria $criteria Optional Criteria to build the query from
     *
     * @return ChildMailingRequestRecipientQuery
     */
    public static function create(?string $modelAlias = null, ?Criteria $criteria = null): Criteria
    {
        if ($criteria instanceof ChildMailingRequestRecipientQuery) {
            return $criteria;
        }
        $query = new ChildMailingRequestRecipientQuery();
        if (null !== $modelAlias) {
            $query->setModelAlias($modelAlias);
        }
        if ($criteria instanceof Criteria) {
            $query->mergeWith($criteria);
        }

        return $query;
    }

    /**
     * Find object by primary key.
     * Propel uses the instance pool to skip the database if the object exists.
     * Go fast if the query is untouched.
     *
     * <code>
     * $obj  = $c->findPk(12, $con);
     * </code>
     *
     * @param mixed $key Primary key to use for the query
     * @param ConnectionInterface $con an optional connection object
     *
     * @return ChildMailingRequestRecipient|array|mixed the result, formatted by the current formatter
     */
    public function findPk($key, ?ConnectionInterface $con = null)
    {
        if ($key === null) {
            return null;
        }

        if ($con === null) {
            $con = Propel::getServiceContainer()->getReadConnection(MailingRequestRecipientTableMap::DATABASE_NAME);
        }

        $this->basePreSelect($con);

        if (
            $this->formatter || $this->modelAlias || $this->with || $this->select
            || $this->selectColumns || $this->asColumns || $this->selectModifiers
            || $this->map || $this->having || $this->joins
        ) {
            return $this->findPkComplex($key, $con);
        }

        if ((null !== ($obj = MailingRequestRecipientTableMap::getInstanceFromPool(null === $key || is_scalar($key) || is_callable([$key, '__toString']) ? (string) $key : $key)))) {
            // the object is already in the instance pool
            return $obj;
        }

        return $this->findPkSimple($key, $con);
    }

    /**
     * Find object by primary key using raw SQL to go fast.
     * Bypass doSelect() and the object formatter by using generated code.
     *
     * @param mixed $key Primary key to use for the query
     * @param ConnectionInterface $con A connection object
     *
     * @throws \Propel\Runtime\Exception\PropelException
     *
     * @return ChildMailingRequestRecipient A model object, or null if the key is not found
     */
    protected function findPkSimple($key, ConnectionInterface $con)
    {
        $sql = 'SELECT `id`, `email`, `request_id`, `created_at`, `sending_at`, `viewed_at`, `status` FROM `_mailing_request_recipients` WHERE `id` = :p0';
        try {
            $stmt = $con->prepare($sql);
            $stmt->bindValue(':p0', $key, PDO::PARAM_INT);
            $stmt->execute();
        } catch (Exception $e) {
            Propel::log($e->getMessage(), Propel::LOG_ERR);
            throw new PropelException(sprintf('Unable to execute SELECT statement [%s]', $sql), 0, $e);
        }
        $obj = null;
        if ($row = $stmt->fetch(\PDO::FETCH_NUM)) {
            /** @var ChildMailingRequestRecipient $obj */
            $obj = new ChildMailingRequestRecipient();
            $obj->hydrate($row);
            MailingRequestRecipientTableMap::addInstanceToPool($obj, null === $key || is_scalar($key) || is_callable([$key, '__toString']) ? (string) $key : $key);
        }
        $stmt->closeCursor();

        return $obj;
    }

    /**
     * Find object by primary key.
     *
     * @param mixed $key Primary key to use for the query
     * @param ConnectionInterface $con A connection object
     *
     * @return ChildMailingRequestRecipient|array|mixed the result, formatted by the current formatter
     */
    protected function findPkComplex($key, ConnectionInterface $con)
    {
        // As the query uses a PK condition, no limit(1) is necessary.
        $criteria = $this->isKeepQuery() ? clone $this : $this;
        $dataFetcher = $criteria
            ->filterByPrimaryKey($key)
            ->doSelect($con);

        return $criteria->getFormatter()->init($criteria)->formatOne($dataFetcher);
    }

    /**
     * Find objects by primary key
     * <code>
     * $objs = $c->findPks(array(12, 56, 832), $con);
     * </code>
     * @param array $keys Primary keys to use for the query
     * @param ConnectionInterface $con an optional connection object
     *
     * @return Collection|array|mixed the list of results, formatted by the current formatter
     */
    public function findPks($keys, ?ConnectionInterface $con = null)
    {
        if (null === $con) {
            $con = Propel::getServiceContainer()->getReadConnection($this->getDbName());
        }
        $this->basePreSelect($con);
        $criteria = $this->isKeepQuery() ? clone $this : $this;
        $dataFetcher = $criteria
            ->filterByPrimaryKeys($keys)
            ->doSelect($con);

        return $criteria->getFormatter()->init($criteria)->format($dataFetcher);
    }

    /**
     * Filter the query by primary key
     *
     * @param mixed $key Primary key to use for the query
     *
     * @return $this The current query, for fluid interface
     */
    public function filterByPrimaryKey($key)
    {

        $this->addUsingAlias(MailingRequestRecipientTableMap::COL_ID, $key, Criteria::EQUAL);

        return $this;
    }

    /**
     * Filter the query by a list of primary keys
     *
     * @param array|int $keys The list of primary key to use for the query
     *
     * @return $this The current query, for fluid interface
     */
    public function filterByPrimaryKeys($keys)
    {

        $this->addUsingAlias(MailingRequestRecipientTableMap::COL_ID, $keys, Criteria::IN);

        return $this;
    }

    /**
     * Filter the query on the id column
     *
     * Example usage:
     * <code>
     * $query->filterById(1234); // WHERE id = 1234
     * $query->filterById(array(12, 34)); // WHERE id IN (12, 34)
     * $query->filterById(array('min' => 12)); // WHERE id > 12
     * </code>
     *
     * @param mixed $id The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param string|null $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this The current query, for fluid interface
     */
    public function filterById($id = null, ?string $comparison = null)
    {
        if (is_array($id)) {
            $useMinMax = false;
            if (isset($id['min'])) {
                $this->addUsingAlias(MailingRequestRecipientTableMap::COL_ID, $id['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($id['max'])) {
                $this->addUsingAlias(MailingRequestRecipientTableMap::COL_ID, $id['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        $this->addUsingAlias(MailingRequestRecipientTableMap::COL_ID, $id, $comparison);

        return $this;
    }

    /**
     * Filter the query on the email column
     *
     * Example usage:
     * <code>
     * $query->filterByEmail('fooValue');   // WHERE email = 'fooValue'
     * $query->filterByEmail('%fooValue%', Criteria::LIKE); // WHERE email LIKE '%fooValue%'
     * $query->filterByEmail(['foo', 'bar']); // WHERE email IN ('foo', 'bar')
     * </code>
     *
     * @param string|string[] $email The value to use as filter.
     * @param string|null $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this The current query, for fluid interface
     */
    public function filterByEmail($email = null, ?string $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($email)) {
                $comparison = Criteria::IN;
            }
        }

        $this->addUsingAlias(MailingRequestRecipientTableMap::COL_EMAIL, $email, $comparison);

        return $this;
    }

    /**
     * Filter the query on the request_id column
     *
     * Example usage:
     * <code>
     * $query->filterByRequestId(1234); // WHERE request_id = 1234
     * $query->filterByRequestId(array(12, 34)); // WHERE request_id IN (12, 34)
     * $query->filterByRequestId(array('min' => 12)); // WHERE request_id > 12
     * </code>
     *
     * @see       filterByMailingRequest()
     *
     * @param mixed $requestId The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param string|null $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this The current query, for fluid interface
     */
    public function filterByRequestId($requestId = null, ?string $comparison = null)
    {
        if (is_array($requestId)) {
            $useMinMax = false;
            if (isset($requestId['min'])) {
                $this->addUsingAlias(MailingRequestRecipientTableMap::COL_REQUEST_ID, $requestId['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($requestId['max'])) {
                $this->addUsingAlias(MailingRequestRecipientTableMap::COL_REQUEST_ID, $requestId['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        $this->addUsingAlias(MailingRequestRecipientTableMap::COL_REQUEST_ID, $requestId, $comparison);

        return $this;
    }

    /**
     * Filter the query on the created_at column
     *
     * Example usage:
     * <code>
     * $query->filterByCreatedAt('2011-03-14'); // WHERE created_at = '2011-03-14'
     * $query->filterByCreatedAt('now'); // WHERE created_at = '2011-03-14'
     * $query->filterByCreatedAt(array('max' => 'yesterday')); // WHERE created_at > '2011-03-13'
     * </code>
     *
     * @param mixed $createdAt The value to use as filter.
     *              Values can be integers (unix timestamps), DateTime objects, or strings.
     *              Empty strings are treated as NULL.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param string|null $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this The current query, for fluid interface
     */
    public function filterByCreatedAt($createdAt = null, ?string $comparison = null)
    {
        if (is_array($createdAt)) {
            $useMinMax = false;
            if (isset($createdAt['min'])) {
                $this->addUsingAlias(MailingRequestRecipientTableMap::COL_CREATED_AT, $createdAt['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($createdAt['max'])) {
                $this->addUsingAlias(MailingRequestRecipientTableMap::COL_CREATED_AT, $createdAt['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        $this->addUsingAlias(MailingRequestRecipientTableMap::COL_CREATED_AT, $createdAt, $comparison);

        return $this;
    }

    /**
     * Filter the query on the sending_at column
     *
     * Example usage:
     * <code>
     * $query->filterBySendingAt('2011-03-14'); // WHERE sending_at = '2011-03-14'
     * $query->filterBySendingAt('now'); // WHERE sending_at = '2011-03-14'
     * $query->filterBySendingAt(array('max' => 'yesterday')); // WHERE sending_at > '2011-03-13'
     * </code>
     *
     * @param mixed $sendingAt The value to use as filter.
     *              Values can be integers (unix timestamps), DateTime objects, or strings.
     *              Empty strings are treated as NULL.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param string|null $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this The current query, for fluid interface
     */
    public function filterBySendingAt($sendingAt = null, ?string $comparison = null)
    {
        if (is_array($sendingAt)) {
            $useMinMax = false;
            if (isset($sendingAt['min'])) {
                $this->addUsingAlias(MailingRequestRecipientTableMap::COL_SENDING_AT, $sendingAt['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($sendingAt['max'])) {
                $this->addUsingAlias(MailingRequestRecipientTableMap::COL_SENDING_AT, $sendingAt['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        $this->addUsingAlias(MailingRequestRecipientTableMap::COL_SENDING_AT, $sendingAt, $comparison);

        return $this;
    }

    /**
     * Filter the query on the viewed_at column
     *
     * Example usage:
     * <code>
     * $query->filterByViewedAt('2011-03-14'); // WHERE viewed_at = '2011-03-14'
     * $query->filterByViewedAt('now'); // WHERE viewed_at = '2011-03-14'
     * $query->filterByViewedAt(array('max' => 'yesterday')); // WHERE viewed_at > '2011-03-13'
     * </code>
     *
     * @param mixed $viewedAt The value to use as filter.
     *              Values can be integers (unix timestamps), DateTime objects, or strings.
     *              Empty strings are treated as NULL.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param string|null $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this The current query, for fluid interface
     */
    public function filterByViewedAt($viewedAt = null, ?string $comparison = null)
    {
        if (is_array($viewedAt)) {
            $useMinMax = false;
            if (isset($viewedAt['min'])) {
                $this->addUsingAlias(MailingRequestRecipientTableMap::COL_VIEWED_AT, $viewedAt['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($viewedAt['max'])) {
                $this->addUsingAlias(MailingRequestRecipientTableMap::COL_VIEWED_AT, $viewedAt['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        $this->addUsingAlias(MailingRequestRecipientTableMap::COL_VIEWED_AT, $viewedAt, $comparison);

        return $this;
    }

    /**
     * Filter the query on the status column
     *
     * Example usage:
     * <code>
     * $query->filterByStatus('fooValue');   // WHERE status = 'fooValue'
     * $query->filterByStatus('%fooValue%', Criteria::LIKE); // WHERE status LIKE '%fooValue%'
     * $query->filterByStatus(['foo', 'bar']); // WHERE status IN ('foo', 'bar')
     * </code>
     *
     * @param string|string[] $status The value to use as filter.
     * @param string|null $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this The current query, for fluid interface
     */
    public function filterByStatus($status = null, ?string $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($status)) {
                $comparison = Criteria::IN;
            }
        }

        $this->addUsingAlias(MailingRequestRecipientTableMap::COL_STATUS, $status, $comparison);

        return $this;
    }

    /**
     * Filter the query by a related \Diamond\Infrastructure\Models\MailingRequest\MailingRequest object
     *
     * @param \Diamond\Infrastructure\Models\MailingRequest\MailingRequest|ObjectCollection $mailingRequest The related object(s) to use as filter
     * @param string|null $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @throws \Propel\Runtime\Exception\PropelException
     *
     * @return $this The current query, for fluid interface
     */
    public function filterByMailingRequest($mailingRequest, ?string $comparison = null)
    {
        if ($mailingRequest instanceof \Diamond\Infrastructure\Models\MailingRequest\MailingRequest) {
            return $this
                ->addUsingAlias(MailingRequestRecipientTableMap::COL_REQUEST_ID, $mailingRequest->getId(), $comparison);
        } elseif ($mailingRequest instanceof ObjectCollection) {
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }

            $this
                ->addUsingAlias(MailingRequestRecipientTableMap::COL_REQUEST_ID, $mailingRequest->toKeyValue('PrimaryKey', 'Id'), $comparison);

            return $this;
        } else {
            throw new PropelException('filterByMailingRequest() only accepts arguments of type \Diamond\Infrastructure\Models\MailingRequest\MailingRequest or Collection');
        }
    }

    /**
     * Adds a JOIN clause to the query using the MailingRequest relation
     *
     * @param string|null $relationAlias Optional alias for the relation
     * @param string|null $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return $this The current query, for fluid interface
     */
    public function joinMailingRequest(?string $relationAlias = null, ?string $joinType = Criteria::INNER_JOIN)
    {
        $tableMap = $this->getTableMap();
        $relationMap = $tableMap->getRelation('MailingRequest');

        // create a ModelJoin object for this join
        $join = new ModelJoin();
        $join->setJoinType($joinType);
        $join->setRelationMap($relationMap, $this->useAliasInSQL ? $this->getModelAlias() : null, $relationAlias);
        if ($previousJoin = $this->getPreviousJoin()) {
            $join->setPreviousJoin($previousJoin);
        }

        // add the ModelJoin to the current object
        if ($relationAlias) {
            $this->addAlias($relationAlias, $relationMap->getRightTable()->getName());
            $this->addJoinObject($join, $relationAlias);
        } else {
            $this->addJoinObject($join, 'MailingRequest');
        }

        return $this;
    }

    /**
     * Use the MailingRequest relation MailingRequest object
     *
     * @see useQuery()
     *
     * @param string $relationAlias optional alias for the relation,
     *                                   to be used as main alias in the secondary query
     * @param string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return \Diamond\Infrastructure\Models\MailingRequest\MailingRequestQuery A secondary query class using the current class as primary query
     */
    public function useMailingRequestQuery($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        return $this
            ->joinMailingRequest($relationAlias, $joinType)
            ->useQuery($relationAlias ? $relationAlias : 'MailingRequest', '\Diamond\Infrastructure\Models\MailingRequest\MailingRequestQuery');
    }

    /**
     * Use the MailingRequest relation MailingRequest object
     *
     * @param callable(\Diamond\Infrastructure\Models\MailingRequest\MailingRequestQuery):\Diamond\Infrastructure\Models\MailingRequest\MailingRequestQuery $callable A function working on the related query
     *
     * @param string|null $relationAlias optional alias for the relation
     *
     * @param string|null $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return $this
     */
    public function withMailingRequestQuery(
        callable $callable,
        string $relationAlias = null,
        ?string $joinType = Criteria::INNER_JOIN
    ) {
        $relatedQuery = $this->useMailingRequestQuery(
            $relationAlias,
            $joinType
        );
        $callable($relatedQuery);
        $relatedQuery->endUse();

        return $this;
    }
    /**
     * Use the relation to MailingRequest table for an EXISTS query.
     *
     * @see \Propel\Runtime\ActiveQuery\ModelCriteria::useExistsQuery()
     *
     * @param string|null $queryClass Allows to use a custom query class for the exists query, like ExtendedBookQuery::class
     * @param string|null $modelAlias sets an alias for the nested query
     * @param string $typeOfExists Either ExistsCriterion::TYPE_EXISTS or ExistsCriterion::TYPE_NOT_EXISTS
     *
     * @return \Diamond\Infrastructure\Models\MailingRequest\MailingRequestQuery The inner query object of the EXISTS statement
     */
    public function useMailingRequestExistsQuery($modelAlias = null, $queryClass = null, $typeOfExists = 'EXISTS')
    {
        return $this->useExistsQuery('MailingRequest', $modelAlias, $queryClass, $typeOfExists);
    }

    /**
     * Use the relation to MailingRequest table for a NOT EXISTS query.
     *
     * @see useMailingRequestExistsQuery()
     *
     * @param string|null $modelAlias sets an alias for the nested query
     * @param string|null $queryClass Allows to use a custom query class for the exists query, like ExtendedBookQuery::class
     *
     * @return \Diamond\Infrastructure\Models\MailingRequest\MailingRequestQuery The inner query object of the NOT EXISTS statement
     */
    public function useMailingRequestNotExistsQuery($modelAlias = null, $queryClass = null)
    {
        return $this->useExistsQuery('MailingRequest', $modelAlias, $queryClass, 'NOT EXISTS');
    }
    /**
     * Exclude object from result
     *
     * @param ChildMailingRequestRecipient $mailingRequestRecipient Object to remove from the list of results
     *
     * @return $this The current query, for fluid interface
     */
    public function prune($mailingRequestRecipient = null)
    {
        if ($mailingRequestRecipient) {
            $this->addUsingAlias(MailingRequestRecipientTableMap::COL_ID, $mailingRequestRecipient->getId(), Criteria::NOT_EQUAL);
        }

        return $this;
    }

    /**
     * Deletes all rows from the _mailing_request_recipients table.
     *
     * @param ConnectionInterface $con the connection to use
     * @return int The number of affected rows (if supported by underlying database driver).
     */
    public function doDeleteAll(?ConnectionInterface $con = null): int
    {
        if (null === $con) {
            $con = Propel::getServiceContainer()->getWriteConnection(MailingRequestRecipientTableMap::DATABASE_NAME);
        }

        // use transaction because $criteria could contain info
        // for more than one table or we could emulating ON DELETE CASCADE, etc.
        return $con->transaction(function () use ($con) {
            $affectedRows = 0; // initialize var to track total num of affected rows
            $affectedRows += parent::doDeleteAll($con);
            // Because this db requires some delete cascade/set null emulation, we have to
            // clear the cached instance *after* the emulation has happened (since
            // instances get re-added by the select statement contained therein).
            MailingRequestRecipientTableMap::clearInstancePool();
            MailingRequestRecipientTableMap::clearRelatedInstancePool();

            return $affectedRows;
        });
    }

    /**
     * Performs a DELETE on the database based on the current ModelCriteria
     *
     * @param ConnectionInterface $con the connection to use
     * @return int The number of affected rows (if supported by underlying database driver).  This includes CASCADE-related rows
     *                         if supported by native driver or if emulated using Propel.
     * @throws \Propel\Runtime\Exception\PropelException Any exceptions caught during processing will be
     *                         rethrown wrapped into a PropelException.
     */
    public function delete(?ConnectionInterface $con = null): int
    {
        if (null === $con) {
            $con = Propel::getServiceContainer()->getWriteConnection(MailingRequestRecipientTableMap::DATABASE_NAME);
        }

        $criteria = $this;

        // Set the correct dbName
        $criteria->setDbName(MailingRequestRecipientTableMap::DATABASE_NAME);

        // use transaction because $criteria could contain info
        // for more than one table or we could emulating ON DELETE CASCADE, etc.
        return $con->transaction(function () use ($con, $criteria) {
            $affectedRows = 0; // initialize var to track total num of affected rows

            MailingRequestRecipientTableMap::removeInstanceFromPool($criteria);

            $affectedRows += ModelCriteria::delete($con);
            MailingRequestRecipientTableMap::clearRelatedInstancePool();

            return $affectedRows;
        });
    }

}
