<?php

namespace Diamond\Infrastructure\Models\MailingMessage\Base;

use \Exception;
use \PDO;
use Diamond\Infrastructure\Models\MailingMessage\MailingMessageQuery as ChildMailingMessageQuery;
use Diamond\Infrastructure\Models\MailingMessage\Map\MailingMessageTableMap;
use Diamond\Infrastructure\Models\MailingSubscriber\MailingSubscriber;
use Diamond\Infrastructure\Models\MailingSubscriber\MailingSubscriberQuery;
use Diamond\Infrastructure\Models\MailingTemplate\MailingTemplate;
use Diamond\Infrastructure\Models\MailingTemplate\MailingTemplateQuery;
use Propel\Runtime\Propel;
use Propel\Runtime\ActiveQuery\Criteria;
use Propel\Runtime\ActiveQuery\ModelCriteria;
use Propel\Runtime\ActiveRecord\ActiveRecordInterface;
use Propel\Runtime\Collection\Collection;
use Propel\Runtime\Connection\ConnectionInterface;
use Propel\Runtime\Exception\BadMethodCallException;
use Propel\Runtime\Exception\LogicException;
use Propel\Runtime\Exception\PropelException;
use Propel\Runtime\Map\TableMap;
use Propel\Runtime\Parser\AbstractParser;

/**
 * Base class that represents a row from the '_mailing_messages' table.
 *
 *
 *
 * @package    propel.generator.Diamond.Infrastructure.Models.MailingMessage.Base
 */
abstract class MailingMessage implements ActiveRecordInterface
{
    /**
     * TableMap class name
     *
     * @var string
     */
    public const TABLE_MAP = '\\Diamond\\Infrastructure\\Models\\MailingMessage\\Map\\MailingMessageTableMap';


    /**
     * attribute to determine if this object has previously been saved.
     * @var bool
     */
    protected $new = true;

    /**
     * attribute to determine whether this object has been deleted.
     * @var bool
     */
    protected $deleted = false;

    /**
     * The columns that have been modified in current object.
     * Tracking modified columns allows us to only update modified columns.
     * @var array
     */
    protected $modifiedColumns = [];

    /**
     * The (virtual) columns that are added at runtime
     * The formatters can add supplementary columns based on a resultset
     * @var array
     */
    protected $virtualColumns = [];

    /**
     * The value for the id field.
     *
     * @var        int
     */
    protected $id;

    /**
     * The value for the to_email field.
     *
     * @var        string|null
     */
    protected $to_email;

    /**
     * The value for the to_name field.
     *
     * @var        string|null
     */
    protected $to_name;

    /**
     * The value for the from_email field.
     *
     * @var        string|null
     */
    protected $from_email;

    /**
     * The value for the from_name field.
     *
     * @var        string|null
     */
    protected $from_name;

    /**
     * The value for the mat_id field.
     *
     * @var        int|null
     */
    protected $mat_id;

    /**
     * The value for the sub_id field.
     *
     * @var        int|null
     */
    protected $sub_id;

    /**
     * The value for the mal_test_mail field.
     *
     * @var        string|null
     */
    protected $mal_test_mail;

    /**
     * @var        MailingSubscriber
     */
    protected $aMailingSubscriber;

    /**
     * @var        MailingTemplate
     */
    protected $aMailingTemplate;

    /**
     * Flag to prevent endless save loop, if this object is referenced
     * by another object which falls in this transaction.
     *
     * @var bool
     */
    protected $alreadyInSave = false;

    /**
     * Initializes internal state of Diamond\Infrastructure\Models\MailingMessage\Base\MailingMessage object.
     */
    public function __construct()
    {
    }

    /**
     * Returns whether the object has been modified.
     *
     * @return bool True if the object has been modified.
     */
    public function isModified(): bool
    {
        return !!$this->modifiedColumns;
    }

    /**
     * Has specified column been modified?
     *
     * @param string $col column fully qualified name (TableMap::TYPE_COLNAME), e.g. Book::AUTHOR_ID
     * @return bool True if $col has been modified.
     */
    public function isColumnModified(string $col): bool
    {
        return $this->modifiedColumns && isset($this->modifiedColumns[$col]);
    }

    /**
     * Get the columns that have been modified in this object.
     * @return array A unique list of the modified column names for this object.
     */
    public function getModifiedColumns(): array
    {
        return $this->modifiedColumns ? array_keys($this->modifiedColumns) : [];
    }

    /**
     * Returns whether the object has ever been saved.  This will
     * be false, if the object was retrieved from storage or was created
     * and then saved.
     *
     * @return bool True, if the object has never been persisted.
     */
    public function isNew(): bool
    {
        return $this->new;
    }

    /**
     * Setter for the isNew attribute.  This method will be called
     * by Propel-generated children and objects.
     *
     * @param bool $b the state of the object.
     */
    public function setNew(bool $b): void
    {
        $this->new = $b;
    }

    /**
     * Whether this object has been deleted.
     * @return bool The deleted state of this object.
     */
    public function isDeleted(): bool
    {
        return $this->deleted;
    }

    /**
     * Specify whether this object has been deleted.
     * @param bool $b The deleted state of this object.
     * @return void
     */
    public function setDeleted(bool $b): void
    {
        $this->deleted = $b;
    }

    /**
     * Sets the modified state for the object to be false.
     * @param string $col If supplied, only the specified column is reset.
     * @return void
     */
    public function resetModified(?string $col = null): void
    {
        if (null !== $col) {
            unset($this->modifiedColumns[$col]);
        } else {
            $this->modifiedColumns = [];
        }
    }

    /**
     * Compares this with another <code>MailingMessage</code> instance.  If
     * <code>obj</code> is an instance of <code>MailingMessage</code>, delegates to
     * <code>equals(MailingMessage)</code>.  Otherwise, returns <code>false</code>.
     *
     * @param mixed $obj The object to compare to.
     * @return bool Whether equal to the object specified.
     */
    public function equals($obj): bool
    {
        if (!$obj instanceof static) {
            return false;
        }

        if ($this === $obj) {
            return true;
        }

        if (null === $this->getPrimaryKey() || null === $obj->getPrimaryKey()) {
            return false;
        }

        return $this->getPrimaryKey() === $obj->getPrimaryKey();
    }

    /**
     * Get the associative array of the virtual columns in this object
     *
     * @return array
     */
    public function getVirtualColumns(): array
    {
        return $this->virtualColumns;
    }

    /**
     * Checks the existence of a virtual column in this object
     *
     * @param string $name The virtual column name
     * @return bool
     */
    public function hasVirtualColumn(string $name): bool
    {
        return array_key_exists($name, $this->virtualColumns);
    }

    /**
     * Get the value of a virtual column in this object
     *
     * @param string $name The virtual column name
     * @return mixed
     *
     * @throws \Propel\Runtime\Exception\PropelException
     */
    public function getVirtualColumn(string $name)
    {
        if (!$this->hasVirtualColumn($name)) {
            throw new PropelException(sprintf('Cannot get value of nonexistent virtual column `%s`.', $name));
        }

        return $this->virtualColumns[$name];
    }

    /**
     * Set the value of a virtual column in this object
     *
     * @param string $name The virtual column name
     * @param mixed $value The value to give to the virtual column
     *
     * @return $this The current object, for fluid interface
     */
    public function setVirtualColumn(string $name, $value)
    {
        $this->virtualColumns[$name] = $value;

        return $this;
    }

    /**
     * Logs a message using Propel::log().
     *
     * @param string $msg
     * @param int $priority One of the Propel::LOG_* logging levels
     * @return void
     */
    protected function log(string $msg, int $priority = Propel::LOG_INFO): void
    {
        Propel::log(get_class($this) . ': ' . $msg, $priority);
    }

    /**
     * Export the current object properties to a string, using a given parser format
     * <code>
     * $book = BookQuery::create()->findPk(9012);
     * echo $book->exportTo('JSON');
     *  => {"Id":9012,"Title":"Don Juan","ISBN":"0140422161","Price":12.99,"PublisherId":1234,"AuthorId":5678}');
     * </code>
     *
     * @param \Propel\Runtime\Parser\AbstractParser|string $parser An AbstractParser instance, or a format name ('XML', 'YAML', 'JSON', 'CSV')
     * @param bool $includeLazyLoadColumns (optional) Whether to include lazy load(ed) columns. Defaults to TRUE.
     * @param string $keyType (optional) One of the class type constants TableMap::TYPE_PHPNAME, TableMap::TYPE_CAMELNAME, TableMap::TYPE_COLNAME, TableMap::TYPE_FIELDNAME, TableMap::TYPE_NUM. Defaults to TableMap::TYPE_PHPNAME.
     * @return string The exported data
     */
    public function exportTo($parser, bool $includeLazyLoadColumns = true, string $keyType = TableMap::TYPE_PHPNAME): string
    {
        if (!$parser instanceof AbstractParser) {
            $parser = AbstractParser::getParser($parser);
        }

        return $parser->fromArray($this->toArray($keyType, $includeLazyLoadColumns, array(), true));
    }

    /**
     * Clean up internal collections prior to serializing
     * Avoids recursive loops that turn into segmentation faults when serializing
     *
     * @return array<string>
     */
    public function __sleep(): array
    {
        $this->clearAllReferences();

        $cls = new \ReflectionClass($this);
        $propertyNames = [];
        $serializableProperties = array_diff($cls->getProperties(), $cls->getProperties(\ReflectionProperty::IS_STATIC));

        foreach($serializableProperties as $property) {
            $propertyNames[] = $property->getName();
        }

        return $propertyNames;
    }

    /**
     * Get the [id] column value.
     *
     * @return int
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Get the [to_email] column value.
     *
     * @return string|null
     */
    public function getToEmail()
    {
        return $this->to_email;
    }

    /**
     * Get the [to_name] column value.
     *
     * @return string|null
     */
    public function getToName()
    {
        return $this->to_name;
    }

    /**
     * Get the [from_email] column value.
     *
     * @return string|null
     */
    public function getFromEmail()
    {
        return $this->from_email;
    }

    /**
     * Get the [from_name] column value.
     *
     * @return string|null
     */
    public function getFromName()
    {
        return $this->from_name;
    }

    /**
     * Get the [mat_id] column value.
     *
     * @return int|null
     */
    public function getMatId()
    {
        return $this->mat_id;
    }

    /**
     * Get the [sub_id] column value.
     *
     * @return int|null
     */
    public function getSubId()
    {
        return $this->sub_id;
    }

    /**
     * Get the [mal_test_mail] column value.
     *
     * @return string|null
     */
    public function getMalTestMail()
    {
        return $this->mal_test_mail;
    }

    /**
     * Set the value of [id] column.
     *
     * @param int $v New value
     * @return $this The current object (for fluent API support)
     */
    public function setId($v)
    {
        if ($v !== null) {
            $v = (int) $v;
        }

        if ($this->id !== $v) {
            $this->id = $v;
            $this->modifiedColumns[MailingMessageTableMap::COL_ID] = true;
        }

        return $this;
    }

    /**
     * Set the value of [to_email] column.
     *
     * @param string|null $v New value
     * @return $this The current object (for fluent API support)
     */
    public function setToEmail($v)
    {
        if ($v !== null) {
            $v = (string) $v;
        }

        if ($this->to_email !== $v) {
            $this->to_email = $v;
            $this->modifiedColumns[MailingMessageTableMap::COL_TO_EMAIL] = true;
        }

        return $this;
    }

    /**
     * Set the value of [to_name] column.
     *
     * @param string|null $v New value
     * @return $this The current object (for fluent API support)
     */
    public function setToName($v)
    {
        if ($v !== null) {
            $v = (string) $v;
        }

        if ($this->to_name !== $v) {
            $this->to_name = $v;
            $this->modifiedColumns[MailingMessageTableMap::COL_TO_NAME] = true;
        }

        return $this;
    }

    /**
     * Set the value of [from_email] column.
     *
     * @param string|null $v New value
     * @return $this The current object (for fluent API support)
     */
    public function setFromEmail($v)
    {
        if ($v !== null) {
            $v = (string) $v;
        }

        if ($this->from_email !== $v) {
            $this->from_email = $v;
            $this->modifiedColumns[MailingMessageTableMap::COL_FROM_EMAIL] = true;
        }

        return $this;
    }

    /**
     * Set the value of [from_name] column.
     *
     * @param string|null $v New value
     * @return $this The current object (for fluent API support)
     */
    public function setFromName($v)
    {
        if ($v !== null) {
            $v = (string) $v;
        }

        if ($this->from_name !== $v) {
            $this->from_name = $v;
            $this->modifiedColumns[MailingMessageTableMap::COL_FROM_NAME] = true;
        }

        return $this;
    }

    /**
     * Set the value of [mat_id] column.
     *
     * @param int|null $v New value
     * @return $this The current object (for fluent API support)
     */
    public function setMatId($v)
    {
        if ($v !== null) {
            $v = (int) $v;
        }

        if ($this->mat_id !== $v) {
            $this->mat_id = $v;
            $this->modifiedColumns[MailingMessageTableMap::COL_MAT_ID] = true;
        }

        if ($this->aMailingTemplate !== null && $this->aMailingTemplate->getId() !== $v) {
            $this->aMailingTemplate = null;
        }

        return $this;
    }

    /**
     * Set the value of [sub_id] column.
     *
     * @param int|null $v New value
     * @return $this The current object (for fluent API support)
     */
    public function setSubId($v)
    {
        if ($v !== null) {
            $v = (int) $v;
        }

        if ($this->sub_id !== $v) {
            $this->sub_id = $v;
            $this->modifiedColumns[MailingMessageTableMap::COL_SUB_ID] = true;
        }

        if ($this->aMailingSubscriber !== null && $this->aMailingSubscriber->getId() !== $v) {
            $this->aMailingSubscriber = null;
        }

        return $this;
    }

    /**
     * Set the value of [mal_test_mail] column.
     *
     * @param string|null $v New value
     * @return $this The current object (for fluent API support)
     */
    public function setMalTestMail($v)
    {
        if ($v !== null) {
            $v = (string) $v;
        }

        if ($this->mal_test_mail !== $v) {
            $this->mal_test_mail = $v;
            $this->modifiedColumns[MailingMessageTableMap::COL_MAL_TEST_MAIL] = true;
        }

        return $this;
    }

    /**
     * Indicates whether the columns in this object are only set to default values.
     *
     * This method can be used in conjunction with isModified() to indicate whether an object is both
     * modified _and_ has some values set which are non-default.
     *
     * @return bool Whether the columns in this object are only been set with default values.
     */
    public function hasOnlyDefaultValues(): bool
    {
        // otherwise, everything was equal, so return TRUE
        return true;
    }

    /**
     * Hydrates (populates) the object variables with values from the database resultset.
     *
     * An offset (0-based "start column") is specified so that objects can be hydrated
     * with a subset of the columns in the resultset rows.  This is needed, for example,
     * for results of JOIN queries where the resultset row includes columns from two or
     * more tables.
     *
     * @param array $row The row returned by DataFetcher->fetch().
     * @param int $startcol 0-based offset column which indicates which resultset column to start with.
     * @param bool $rehydrate Whether this object is being re-hydrated from the database.
     * @param string $indexType The index type of $row. Mostly DataFetcher->getIndexType().
                                  One of the class type constants TableMap::TYPE_PHPNAME, TableMap::TYPE_CAMELNAME
     *                            TableMap::TYPE_COLNAME, TableMap::TYPE_FIELDNAME, TableMap::TYPE_NUM.
     *
     * @return int next starting column
     * @throws \Propel\Runtime\Exception\PropelException - Any caught Exception will be rewrapped as a PropelException.
     */
    public function hydrate(array $row, int $startcol = 0, bool $rehydrate = false, string $indexType = TableMap::TYPE_NUM): int
    {
        try {

            $col = $row[TableMap::TYPE_NUM == $indexType ? 0 + $startcol : MailingMessageTableMap::translateFieldName('Id', TableMap::TYPE_PHPNAME, $indexType)];
            $this->id = (null !== $col) ? (int) $col : null;

            $col = $row[TableMap::TYPE_NUM == $indexType ? 1 + $startcol : MailingMessageTableMap::translateFieldName('ToEmail', TableMap::TYPE_PHPNAME, $indexType)];
            $this->to_email = (null !== $col) ? (string) $col : null;

            $col = $row[TableMap::TYPE_NUM == $indexType ? 2 + $startcol : MailingMessageTableMap::translateFieldName('ToName', TableMap::TYPE_PHPNAME, $indexType)];
            $this->to_name = (null !== $col) ? (string) $col : null;

            $col = $row[TableMap::TYPE_NUM == $indexType ? 3 + $startcol : MailingMessageTableMap::translateFieldName('FromEmail', TableMap::TYPE_PHPNAME, $indexType)];
            $this->from_email = (null !== $col) ? (string) $col : null;

            $col = $row[TableMap::TYPE_NUM == $indexType ? 4 + $startcol : MailingMessageTableMap::translateFieldName('FromName', TableMap::TYPE_PHPNAME, $indexType)];
            $this->from_name = (null !== $col) ? (string) $col : null;

            $col = $row[TableMap::TYPE_NUM == $indexType ? 5 + $startcol : MailingMessageTableMap::translateFieldName('MatId', TableMap::TYPE_PHPNAME, $indexType)];
            $this->mat_id = (null !== $col) ? (int) $col : null;

            $col = $row[TableMap::TYPE_NUM == $indexType ? 6 + $startcol : MailingMessageTableMap::translateFieldName('SubId', TableMap::TYPE_PHPNAME, $indexType)];
            $this->sub_id = (null !== $col) ? (int) $col : null;

            $col = $row[TableMap::TYPE_NUM == $indexType ? 7 + $startcol : MailingMessageTableMap::translateFieldName('MalTestMail', TableMap::TYPE_PHPNAME, $indexType)];
            $this->mal_test_mail = (null !== $col) ? (string) $col : null;
            $this->resetModified();

            $this->setNew(false);

            if ($rehydrate) {
                $this->ensureConsistency();
            }

            return $startcol + 8; // 8 = MailingMessageTableMap::NUM_HYDRATE_COLUMNS.

        } catch (Exception $e) {
            throw new PropelException(sprintf('Error populating %s object', '\\Diamond\\Infrastructure\\Models\\MailingMessage\\MailingMessage'), 0, $e);
        }
    }

    /**
     * Checks and repairs the internal consistency of the object.
     *
     * This method is executed after an already-instantiated object is re-hydrated
     * from the database.  It exists to check any foreign keys to make sure that
     * the objects related to the current object are correct based on foreign key.
     *
     * You can override this method in the stub class, but you should always invoke
     * the base method from the overridden method (i.e. parent::ensureConsistency()),
     * in case your model changes.
     *
     * @throws \Propel\Runtime\Exception\PropelException
     * @return void
     */
    public function ensureConsistency(): void
    {
        if ($this->aMailingTemplate !== null && $this->mat_id !== $this->aMailingTemplate->getId()) {
            $this->aMailingTemplate = null;
        }
        if ($this->aMailingSubscriber !== null && $this->sub_id !== $this->aMailingSubscriber->getId()) {
            $this->aMailingSubscriber = null;
        }
    }

    /**
     * Reloads this object from datastore based on primary key and (optionally) resets all associated objects.
     *
     * This will only work if the object has been saved and has a valid primary key set.
     *
     * @param bool $deep (optional) Whether to also de-associated any related objects.
     * @param ConnectionInterface $con (optional) The ConnectionInterface connection to use.
     * @return void
     * @throws \Propel\Runtime\Exception\PropelException - if this object is deleted, unsaved or doesn't have pk match in db
     */
    public function reload(bool $deep = false, ?ConnectionInterface $con = null): void
    {
        if ($this->isDeleted()) {
            throw new PropelException("Cannot reload a deleted object.");
        }

        if ($this->isNew()) {
            throw new PropelException("Cannot reload an unsaved object.");
        }

        if ($con === null) {
            $con = Propel::getServiceContainer()->getReadConnection(MailingMessageTableMap::DATABASE_NAME);
        }

        // We don't need to alter the object instance pool; we're just modifying this instance
        // already in the pool.

        $dataFetcher = ChildMailingMessageQuery::create(null, $this->buildPkeyCriteria())->setFormatter(ModelCriteria::FORMAT_STATEMENT)->find($con);
        $row = $dataFetcher->fetch();
        $dataFetcher->close();
        if (!$row) {
            throw new PropelException('Cannot find matching row in the database to reload object values.');
        }
        $this->hydrate($row, 0, true, $dataFetcher->getIndexType()); // rehydrate

        if ($deep) {  // also de-associate any related objects?

            $this->aMailingSubscriber = null;
            $this->aMailingTemplate = null;
        } // if (deep)
    }

    /**
     * Removes this object from datastore and sets delete attribute.
     *
     * @param ConnectionInterface $con
     * @return void
     * @throws \Propel\Runtime\Exception\PropelException
     * @see MailingMessage::setDeleted()
     * @see MailingMessage::isDeleted()
     */
    public function delete(?ConnectionInterface $con = null): void
    {
        if ($this->isDeleted()) {
            throw new PropelException("This object has already been deleted.");
        }

        if ($con === null) {
            $con = Propel::getServiceContainer()->getWriteConnection(MailingMessageTableMap::DATABASE_NAME);
        }

        $con->transaction(function () use ($con) {
            $deleteQuery = ChildMailingMessageQuery::create()
                ->filterByPrimaryKey($this->getPrimaryKey());
            $ret = $this->preDelete($con);
            if ($ret) {
                $deleteQuery->delete($con);
                $this->postDelete($con);
                $this->setDeleted(true);
            }
        });
    }

    /**
     * Persists this object to the database.
     *
     * If the object is new, it inserts it; otherwise an update is performed.
     * All modified related objects will also be persisted in the doSave()
     * method.  This method wraps all precipitate database operations in a
     * single transaction.
     *
     * @param ConnectionInterface $con
     * @return int The number of rows affected by this insert/update and any referring fk objects' save() operations.
     * @throws \Propel\Runtime\Exception\PropelException
     * @see doSave()
     */
    public function save(?ConnectionInterface $con = null): int
    {
        if ($this->isDeleted()) {
            throw new PropelException("You cannot save an object that has been deleted.");
        }

        if ($this->alreadyInSave) {
            return 0;
        }

        if ($con === null) {
            $con = Propel::getServiceContainer()->getWriteConnection(MailingMessageTableMap::DATABASE_NAME);
        }

        return $con->transaction(function () use ($con) {
            $ret = $this->preSave($con);
            $isInsert = $this->isNew();
            if ($isInsert) {
                $ret = $ret && $this->preInsert($con);
            } else {
                $ret = $ret && $this->preUpdate($con);
            }
            if ($ret) {
                $affectedRows = $this->doSave($con);
                if ($isInsert) {
                    $this->postInsert($con);
                } else {
                    $this->postUpdate($con);
                }
                $this->postSave($con);
                MailingMessageTableMap::addInstanceToPool($this);
            } else {
                $affectedRows = 0;
            }

            return $affectedRows;
        });
    }

    /**
     * Performs the work of inserting or updating the row in the database.
     *
     * If the object is new, it inserts it; otherwise an update is performed.
     * All related objects are also updated in this method.
     *
     * @param ConnectionInterface $con
     * @return int The number of rows affected by this insert/update and any referring fk objects' save() operations.
     * @throws \Propel\Runtime\Exception\PropelException
     * @see save()
     */
    protected function doSave(ConnectionInterface $con): int
    {
        $affectedRows = 0; // initialize var to track total num of affected rows
        if (!$this->alreadyInSave) {
            $this->alreadyInSave = true;

            // We call the save method on the following object(s) if they
            // were passed to this object by their corresponding set
            // method.  This object relates to these object(s) by a
            // foreign key reference.

            if ($this->aMailingSubscriber !== null) {
                if ($this->aMailingSubscriber->isModified() || $this->aMailingSubscriber->isNew()) {
                    $affectedRows += $this->aMailingSubscriber->save($con);
                }
                $this->setMailingSubscriber($this->aMailingSubscriber);
            }

            if ($this->aMailingTemplate !== null) {
                if ($this->aMailingTemplate->isModified() || $this->aMailingTemplate->isNew()) {
                    $affectedRows += $this->aMailingTemplate->save($con);
                }
                $this->setMailingTemplate($this->aMailingTemplate);
            }

            if ($this->isNew() || $this->isModified()) {
                // persist changes
                if ($this->isNew()) {
                    $this->doInsert($con);
                    $affectedRows += 1;
                } else {
                    $affectedRows += $this->doUpdate($con);
                }
                $this->resetModified();
            }

            $this->alreadyInSave = false;

        }

        return $affectedRows;
    }

    /**
     * Insert the row in the database.
     *
     * @param ConnectionInterface $con
     *
     * @throws \Propel\Runtime\Exception\PropelException
     * @see doSave()
     */
    protected function doInsert(ConnectionInterface $con): void
    {
        $modifiedColumns = [];
        $index = 0;

        $this->modifiedColumns[MailingMessageTableMap::COL_ID] = true;
        if (null !== $this->id) {
            throw new PropelException('Cannot insert a value for auto-increment primary key (' . MailingMessageTableMap::COL_ID . ')');
        }

         // check the columns in natural order for more readable SQL queries
        if ($this->isColumnModified(MailingMessageTableMap::COL_ID)) {
            $modifiedColumns[':p' . $index++]  = '`id`';
        }
        if ($this->isColumnModified(MailingMessageTableMap::COL_TO_EMAIL)) {
            $modifiedColumns[':p' . $index++]  = '`to_email`';
        }
        if ($this->isColumnModified(MailingMessageTableMap::COL_TO_NAME)) {
            $modifiedColumns[':p' . $index++]  = '`to_name`';
        }
        if ($this->isColumnModified(MailingMessageTableMap::COL_FROM_EMAIL)) {
            $modifiedColumns[':p' . $index++]  = '`from_email`';
        }
        if ($this->isColumnModified(MailingMessageTableMap::COL_FROM_NAME)) {
            $modifiedColumns[':p' . $index++]  = '`from_name`';
        }
        if ($this->isColumnModified(MailingMessageTableMap::COL_MAT_ID)) {
            $modifiedColumns[':p' . $index++]  = '`mat_id`';
        }
        if ($this->isColumnModified(MailingMessageTableMap::COL_SUB_ID)) {
            $modifiedColumns[':p' . $index++]  = '`sub_id`';
        }
        if ($this->isColumnModified(MailingMessageTableMap::COL_MAL_TEST_MAIL)) {
            $modifiedColumns[':p' . $index++]  = '`mal_test_mail`';
        }

        $sql = sprintf(
            'INSERT INTO `_mailing_messages` (%s) VALUES (%s)',
            implode(', ', $modifiedColumns),
            implode(', ', array_keys($modifiedColumns))
        );

        try {
            $stmt = $con->prepare($sql);
            foreach ($modifiedColumns as $identifier => $columnName) {
                switch ($columnName) {
                    case '`id`':
                        $stmt->bindValue($identifier, $this->id, PDO::PARAM_INT);
                        break;
                    case '`to_email`':
                        $stmt->bindValue($identifier, $this->to_email, PDO::PARAM_STR);
                        break;
                    case '`to_name`':
                        $stmt->bindValue($identifier, $this->to_name, PDO::PARAM_STR);
                        break;
                    case '`from_email`':
                        $stmt->bindValue($identifier, $this->from_email, PDO::PARAM_STR);
                        break;
                    case '`from_name`':
                        $stmt->bindValue($identifier, $this->from_name, PDO::PARAM_STR);
                        break;
                    case '`mat_id`':
                        $stmt->bindValue($identifier, $this->mat_id, PDO::PARAM_INT);
                        break;
                    case '`sub_id`':
                        $stmt->bindValue($identifier, $this->sub_id, PDO::PARAM_INT);
                        break;
                    case '`mal_test_mail`':
                        $stmt->bindValue($identifier, $this->mal_test_mail, PDO::PARAM_STR);
                        break;
                }
            }
            $stmt->execute();
        } catch (Exception $e) {
            Propel::log($e->getMessage(), Propel::LOG_ERR);
            throw new PropelException(sprintf('Unable to execute INSERT statement [%s]', $sql), 0, $e);
        }

        try {
            $pk = $con->lastInsertId();
        } catch (Exception $e) {
            throw new PropelException('Unable to get autoincrement id.', 0, $e);
        }
        $this->setId($pk);

        $this->setNew(false);
    }

    /**
     * Update the row in the database.
     *
     * @param ConnectionInterface $con
     *
     * @return int Number of updated rows
     * @see doSave()
     */
    protected function doUpdate(ConnectionInterface $con): int
    {
        $selectCriteria = $this->buildPkeyCriteria();
        $valuesCriteria = $this->buildCriteria();

        return $selectCriteria->doUpdate($valuesCriteria, $con);
    }

    /**
     * Retrieves a field from the object by name passed in as a string.
     *
     * @param string $name name
     * @param string $type The type of fieldname the $name is of:
     *                     one of the class type constants TableMap::TYPE_PHPNAME, TableMap::TYPE_CAMELNAME
     *                     TableMap::TYPE_COLNAME, TableMap::TYPE_FIELDNAME, TableMap::TYPE_NUM.
     *                     Defaults to TableMap::TYPE_PHPNAME.
     * @return mixed Value of field.
     */
    public function getByName(string $name, string $type = TableMap::TYPE_PHPNAME)
    {
        $pos = MailingMessageTableMap::translateFieldName($name, $type, TableMap::TYPE_NUM);
        $field = $this->getByPosition($pos);

        return $field;
    }

    /**
     * Retrieves a field from the object by Position as specified in the xml schema.
     * Zero-based.
     *
     * @param int $pos Position in XML schema
     * @return mixed Value of field at $pos
     */
    public function getByPosition(int $pos)
    {
        switch ($pos) {
            case 0:
                return $this->getId();

            case 1:
                return $this->getToEmail();

            case 2:
                return $this->getToName();

            case 3:
                return $this->getFromEmail();

            case 4:
                return $this->getFromName();

            case 5:
                return $this->getMatId();

            case 6:
                return $this->getSubId();

            case 7:
                return $this->getMalTestMail();

            default:
                return null;
        } // switch()
    }

    /**
     * Exports the object as an array.
     *
     * You can specify the key type of the array by passing one of the class
     * type constants.
     *
     * @param string $keyType (optional) One of the class type constants TableMap::TYPE_PHPNAME, TableMap::TYPE_CAMELNAME,
     *                    TableMap::TYPE_COLNAME, TableMap::TYPE_FIELDNAME, TableMap::TYPE_NUM.
     *                    Defaults to TableMap::TYPE_PHPNAME.
     * @param bool $includeLazyLoadColumns (optional) Whether to include lazy loaded columns. Defaults to TRUE.
     * @param array $alreadyDumpedObjects List of objects to skip to avoid recursion
     * @param bool $includeForeignObjects (optional) Whether to include hydrated related objects. Default to FALSE.
     *
     * @return array An associative array containing the field names (as keys) and field values
     */
    public function toArray(string $keyType = TableMap::TYPE_PHPNAME, bool $includeLazyLoadColumns = true, array $alreadyDumpedObjects = [], bool $includeForeignObjects = false): array
    {
        if (isset($alreadyDumpedObjects['MailingMessage'][$this->hashCode()])) {
            return ['*RECURSION*'];
        }
        $alreadyDumpedObjects['MailingMessage'][$this->hashCode()] = true;
        $keys = MailingMessageTableMap::getFieldNames($keyType);
        $result = [
            $keys[0] => $this->getId(),
            $keys[1] => $this->getToEmail(),
            $keys[2] => $this->getToName(),
            $keys[3] => $this->getFromEmail(),
            $keys[4] => $this->getFromName(),
            $keys[5] => $this->getMatId(),
            $keys[6] => $this->getSubId(),
            $keys[7] => $this->getMalTestMail(),
        ];
        $virtualColumns = $this->virtualColumns;
        foreach ($virtualColumns as $key => $virtualColumn) {
            $result[$key] = $virtualColumn;
        }

        if ($includeForeignObjects) {
            if (null !== $this->aMailingSubscriber) {

                switch ($keyType) {
                    case TableMap::TYPE_CAMELNAME:
                        $key = 'mailingSubscriber';
                        break;
                    case TableMap::TYPE_FIELDNAME:
                        $key = '_mailing_subscribers';
                        break;
                    default:
                        $key = 'MailingSubscriber';
                }

                $result[$key] = $this->aMailingSubscriber->toArray($keyType, $includeLazyLoadColumns,  $alreadyDumpedObjects, true);
            }
            if (null !== $this->aMailingTemplate) {

                switch ($keyType) {
                    case TableMap::TYPE_CAMELNAME:
                        $key = 'mailingTemplate';
                        break;
                    case TableMap::TYPE_FIELDNAME:
                        $key = '_mailing_template';
                        break;
                    default:
                        $key = 'MailingTemplate';
                }

                $result[$key] = $this->aMailingTemplate->toArray($keyType, $includeLazyLoadColumns,  $alreadyDumpedObjects, true);
            }
        }

        return $result;
    }

    /**
     * Sets a field from the object by name passed in as a string.
     *
     * @param string $name
     * @param mixed $value field value
     * @param string $type The type of fieldname the $name is of:
     *                one of the class type constants TableMap::TYPE_PHPNAME, TableMap::TYPE_CAMELNAME
     *                TableMap::TYPE_COLNAME, TableMap::TYPE_FIELDNAME, TableMap::TYPE_NUM.
     *                Defaults to TableMap::TYPE_PHPNAME.
     * @return $this
     */
    public function setByName(string $name, $value, string $type = TableMap::TYPE_PHPNAME)
    {
        $pos = MailingMessageTableMap::translateFieldName($name, $type, TableMap::TYPE_NUM);

        $this->setByPosition($pos, $value);

        return $this;
    }

    /**
     * Sets a field from the object by Position as specified in the xml schema.
     * Zero-based.
     *
     * @param int $pos position in xml schema
     * @param mixed $value field value
     * @return $this
     */
    public function setByPosition(int $pos, $value)
    {
        switch ($pos) {
            case 0:
                $this->setId($value);
                break;
            case 1:
                $this->setToEmail($value);
                break;
            case 2:
                $this->setToName($value);
                break;
            case 3:
                $this->setFromEmail($value);
                break;
            case 4:
                $this->setFromName($value);
                break;
            case 5:
                $this->setMatId($value);
                break;
            case 6:
                $this->setSubId($value);
                break;
            case 7:
                $this->setMalTestMail($value);
                break;
        } // switch()

        return $this;
    }

    /**
     * Populates the object using an array.
     *
     * This is particularly useful when populating an object from one of the
     * request arrays (e.g. $_POST).  This method goes through the column
     * names, checking to see whether a matching key exists in populated
     * array. If so the setByName() method is called for that column.
     *
     * You can specify the key type of the array by additionally passing one
     * of the class type constants TableMap::TYPE_PHPNAME, TableMap::TYPE_CAMELNAME,
     * TableMap::TYPE_COLNAME, TableMap::TYPE_FIELDNAME, TableMap::TYPE_NUM.
     * The default key type is the column's TableMap::TYPE_PHPNAME.
     *
     * @param array $arr An array to populate the object from.
     * @param string $keyType The type of keys the array uses.
     * @return $this
     */
    public function fromArray(array $arr, string $keyType = TableMap::TYPE_PHPNAME)
    {
        $keys = MailingMessageTableMap::getFieldNames($keyType);

        if (array_key_exists($keys[0], $arr)) {
            $this->setId($arr[$keys[0]]);
        }
        if (array_key_exists($keys[1], $arr)) {
            $this->setToEmail($arr[$keys[1]]);
        }
        if (array_key_exists($keys[2], $arr)) {
            $this->setToName($arr[$keys[2]]);
        }
        if (array_key_exists($keys[3], $arr)) {
            $this->setFromEmail($arr[$keys[3]]);
        }
        if (array_key_exists($keys[4], $arr)) {
            $this->setFromName($arr[$keys[4]]);
        }
        if (array_key_exists($keys[5], $arr)) {
            $this->setMatId($arr[$keys[5]]);
        }
        if (array_key_exists($keys[6], $arr)) {
            $this->setSubId($arr[$keys[6]]);
        }
        if (array_key_exists($keys[7], $arr)) {
            $this->setMalTestMail($arr[$keys[7]]);
        }

        return $this;
    }

     /**
     * Populate the current object from a string, using a given parser format
     * <code>
     * $book = new Book();
     * $book->importFrom('JSON', '{"Id":9012,"Title":"Don Juan","ISBN":"0140422161","Price":12.99,"PublisherId":1234,"AuthorId":5678}');
     * </code>
     *
     * You can specify the key type of the array by additionally passing one
     * of the class type constants TableMap::TYPE_PHPNAME, TableMap::TYPE_CAMELNAME,
     * TableMap::TYPE_COLNAME, TableMap::TYPE_FIELDNAME, TableMap::TYPE_NUM.
     * The default key type is the column's TableMap::TYPE_PHPNAME.
     *
     * @param mixed $parser A AbstractParser instance,
     *                       or a format name ('XML', 'YAML', 'JSON', 'CSV')
     * @param string $data The source data to import from
     * @param string $keyType The type of keys the array uses.
     *
     * @return $this The current object, for fluid interface
     */
    public function importFrom($parser, string $data, string $keyType = TableMap::TYPE_PHPNAME)
    {
        if (!$parser instanceof AbstractParser) {
            $parser = AbstractParser::getParser($parser);
        }

        $this->fromArray($parser->toArray($data), $keyType);

        return $this;
    }

    /**
     * Build a Criteria object containing the values of all modified columns in this object.
     *
     * @return \Propel\Runtime\ActiveQuery\Criteria The Criteria object containing all modified values.
     */
    public function buildCriteria(): Criteria
    {
        $criteria = new Criteria(MailingMessageTableMap::DATABASE_NAME);

        if ($this->isColumnModified(MailingMessageTableMap::COL_ID)) {
            $criteria->add(MailingMessageTableMap::COL_ID, $this->id);
        }
        if ($this->isColumnModified(MailingMessageTableMap::COL_TO_EMAIL)) {
            $criteria->add(MailingMessageTableMap::COL_TO_EMAIL, $this->to_email);
        }
        if ($this->isColumnModified(MailingMessageTableMap::COL_TO_NAME)) {
            $criteria->add(MailingMessageTableMap::COL_TO_NAME, $this->to_name);
        }
        if ($this->isColumnModified(MailingMessageTableMap::COL_FROM_EMAIL)) {
            $criteria->add(MailingMessageTableMap::COL_FROM_EMAIL, $this->from_email);
        }
        if ($this->isColumnModified(MailingMessageTableMap::COL_FROM_NAME)) {
            $criteria->add(MailingMessageTableMap::COL_FROM_NAME, $this->from_name);
        }
        if ($this->isColumnModified(MailingMessageTableMap::COL_MAT_ID)) {
            $criteria->add(MailingMessageTableMap::COL_MAT_ID, $this->mat_id);
        }
        if ($this->isColumnModified(MailingMessageTableMap::COL_SUB_ID)) {
            $criteria->add(MailingMessageTableMap::COL_SUB_ID, $this->sub_id);
        }
        if ($this->isColumnModified(MailingMessageTableMap::COL_MAL_TEST_MAIL)) {
            $criteria->add(MailingMessageTableMap::COL_MAL_TEST_MAIL, $this->mal_test_mail);
        }

        return $criteria;
    }

    /**
     * Builds a Criteria object containing the primary key for this object.
     *
     * Unlike buildCriteria() this method includes the primary key values regardless
     * of whether they have been modified.
     *
     * @throws LogicException if no primary key is defined
     *
     * @return \Propel\Runtime\ActiveQuery\Criteria The Criteria object containing value(s) for primary key(s).
     */
    public function buildPkeyCriteria(): Criteria
    {
        $criteria = ChildMailingMessageQuery::create();
        $criteria->add(MailingMessageTableMap::COL_ID, $this->id);

        return $criteria;
    }

    /**
     * If the primary key is not null, return the hashcode of the
     * primary key. Otherwise, return the hash code of the object.
     *
     * @return int|string Hashcode
     */
    public function hashCode()
    {
        $validPk = null !== $this->getId();

        $validPrimaryKeyFKs = 0;
        $primaryKeyFKs = [];

        if ($validPk) {
            return crc32(json_encode($this->getPrimaryKey(), JSON_UNESCAPED_UNICODE));
        } elseif ($validPrimaryKeyFKs) {
            return crc32(json_encode($primaryKeyFKs, JSON_UNESCAPED_UNICODE));
        }

        return spl_object_hash($this);
    }

    /**
     * Returns the primary key for this object (row).
     * @return int
     */
    public function getPrimaryKey()
    {
        return $this->getId();
    }

    /**
     * Generic method to set the primary key (id column).
     *
     * @param int|null $key Primary key.
     * @return void
     */
    public function setPrimaryKey(?int $key = null): void
    {
        $this->setId($key);
    }

    /**
     * Returns true if the primary key for this object is null.
     *
     * @return bool
     */
    public function isPrimaryKeyNull(): bool
    {
        return null === $this->getId();
    }

    /**
     * Sets contents of passed object to values from current object.
     *
     * If desired, this method can also make copies of all associated (fkey referrers)
     * objects.
     *
     * @param object $copyObj An object of \Diamond\Infrastructure\Models\MailingMessage\MailingMessage (or compatible) type.
     * @param bool $deepCopy Whether to also copy all rows that refer (by fkey) to the current row.
     * @param bool $makeNew Whether to reset autoincrement PKs and make the object new.
     * @throws \Propel\Runtime\Exception\PropelException
     * @return void
     */
    public function copyInto(object $copyObj, bool $deepCopy = false, bool $makeNew = true): void
    {
        $copyObj->setToEmail($this->getToEmail());
        $copyObj->setToName($this->getToName());
        $copyObj->setFromEmail($this->getFromEmail());
        $copyObj->setFromName($this->getFromName());
        $copyObj->setMatId($this->getMatId());
        $copyObj->setSubId($this->getSubId());
        $copyObj->setMalTestMail($this->getMalTestMail());
        if ($makeNew) {
            $copyObj->setNew(true);
            $copyObj->setId(NULL); // this is a auto-increment column, so set to default value
        }
    }

    /**
     * Makes a copy of this object that will be inserted as a new row in table when saved.
     * It creates a new object filling in the simple attributes, but skipping any primary
     * keys that are defined for the table.
     *
     * If desired, this method can also make copies of all associated (fkey referrers)
     * objects.
     *
     * @param bool $deepCopy Whether to also copy all rows that refer (by fkey) to the current row.
     * @return \Diamond\Infrastructure\Models\MailingMessage\MailingMessage Clone of current object.
     * @throws \Propel\Runtime\Exception\PropelException
     */
    public function copy(bool $deepCopy = false)
    {
        // we use get_class(), because this might be a subclass
        $clazz = get_class($this);
        $copyObj = new $clazz();
        $this->copyInto($copyObj, $deepCopy);

        return $copyObj;
    }

    /**
     * Declares an association between this object and a MailingSubscriber object.
     *
     * @param MailingSubscriber|null $v
     * @return $this The current object (for fluent API support)
     * @throws \Propel\Runtime\Exception\PropelException
     */
    public function setMailingSubscriber(MailingSubscriber $v = null)
    {
        if ($v === null) {
            $this->setSubId(NULL);
        } else {
            $this->setSubId($v->getId());
        }

        $this->aMailingSubscriber = $v;

        // Add binding for other direction of this n:n relationship.
        // If this object has already been added to the MailingSubscriber object, it will not be re-added.
        if ($v !== null) {
            $v->addMailingMessage($this);
        }


        return $this;
    }


    /**
     * Get the associated MailingSubscriber object
     *
     * @param ConnectionInterface $con Optional Connection object.
     * @return MailingSubscriber|null The associated MailingSubscriber object.
     * @throws \Propel\Runtime\Exception\PropelException
     */
    public function getMailingSubscriber(?ConnectionInterface $con = null)
    {
        if ($this->aMailingSubscriber === null && ($this->sub_id != 0)) {
            $this->aMailingSubscriber = MailingSubscriberQuery::create()->findPk($this->sub_id, $con);
            /* The following can be used additionally to
                guarantee the related object contains a reference
                to this object.  This level of coupling may, however, be
                undesirable since it could result in an only partially populated collection
                in the referenced object.
                $this->aMailingSubscriber->addMailingMessages($this);
             */
        }

        return $this->aMailingSubscriber;
    }

    /**
     * Declares an association between this object and a MailingTemplate object.
     *
     * @param MailingTemplate|null $v
     * @return $this The current object (for fluent API support)
     * @throws \Propel\Runtime\Exception\PropelException
     */
    public function setMailingTemplate(MailingTemplate $v = null)
    {
        if ($v === null) {
            $this->setMatId(NULL);
        } else {
            $this->setMatId($v->getId());
        }

        $this->aMailingTemplate = $v;

        // Add binding for other direction of this n:n relationship.
        // If this object has already been added to the MailingTemplate object, it will not be re-added.
        if ($v !== null) {
            $v->addMailingMessage($this);
        }


        return $this;
    }


    /**
     * Get the associated MailingTemplate object
     *
     * @param ConnectionInterface $con Optional Connection object.
     * @return MailingTemplate|null The associated MailingTemplate object.
     * @throws \Propel\Runtime\Exception\PropelException
     */
    public function getMailingTemplate(?ConnectionInterface $con = null)
    {
        if ($this->aMailingTemplate === null && ($this->mat_id != 0)) {
            $this->aMailingTemplate = MailingTemplateQuery::create()->findPk($this->mat_id, $con);
            /* The following can be used additionally to
                guarantee the related object contains a reference
                to this object.  This level of coupling may, however, be
                undesirable since it could result in an only partially populated collection
                in the referenced object.
                $this->aMailingTemplate->addMailingMessages($this);
             */
        }

        return $this->aMailingTemplate;
    }

    /**
     * Clears the current object, sets all attributes to their default values and removes
     * outgoing references as well as back-references (from other objects to this one. Results probably in a database
     * change of those foreign objects when you call `save` there).
     *
     * @return $this
     */
    public function clear()
    {
        if (null !== $this->aMailingSubscriber) {
            $this->aMailingSubscriber->removeMailingMessage($this);
        }
        if (null !== $this->aMailingTemplate) {
            $this->aMailingTemplate->removeMailingMessage($this);
        }
        $this->id = null;
        $this->to_email = null;
        $this->to_name = null;
        $this->from_email = null;
        $this->from_name = null;
        $this->mat_id = null;
        $this->sub_id = null;
        $this->mal_test_mail = null;
        $this->alreadyInSave = false;
        $this->clearAllReferences();
        $this->resetModified();
        $this->setNew(true);
        $this->setDeleted(false);

        return $this;
    }

    /**
     * Resets all references and back-references to other model objects or collections of model objects.
     *
     * This method is used to reset all php object references (not the actual reference in the database).
     * Necessary for object serialisation.
     *
     * @param bool $deep Whether to also clear the references on all referrer objects.
     * @return $this
     */
    public function clearAllReferences(bool $deep = false)
    {
        if ($deep) {
        } // if ($deep)

        $this->aMailingSubscriber = null;
        $this->aMailingTemplate = null;
        return $this;
    }

    /**
     * Return the string representation of this object
     *
     * @return string
     */
    public function __toString()
    {
        return (string) $this->exportTo(MailingMessageTableMap::DEFAULT_STRING_FORMAT);
    }

    /**
     * Code to be run before persisting the object
     * @param ConnectionInterface|null $con
     * @return bool
     */
    public function preSave(?ConnectionInterface $con = null): bool
    {
                return true;
    }

    /**
     * Code to be run after persisting the object
     * @param ConnectionInterface|null $con
     * @return void
     */
    public function postSave(?ConnectionInterface $con = null): void
    {
            }

    /**
     * Code to be run before inserting to database
     * @param ConnectionInterface|null $con
     * @return bool
     */
    public function preInsert(?ConnectionInterface $con = null): bool
    {
                return true;
    }

    /**
     * Code to be run after inserting to database
     * @param ConnectionInterface|null $con
     * @return void
     */
    public function postInsert(?ConnectionInterface $con = null): void
    {
            }

    /**
     * Code to be run before updating the object in database
     * @param ConnectionInterface|null $con
     * @return bool
     */
    public function preUpdate(?ConnectionInterface $con = null): bool
    {
                return true;
    }

    /**
     * Code to be run after updating the object in database
     * @param ConnectionInterface|null $con
     * @return void
     */
    public function postUpdate(?ConnectionInterface $con = null): void
    {
            }

    /**
     * Code to be run before deleting the object in database
     * @param ConnectionInterface|null $con
     * @return bool
     */
    public function preDelete(?ConnectionInterface $con = null): bool
    {
                return true;
    }

    /**
     * Code to be run after deleting the object in database
     * @param ConnectionInterface|null $con
     * @return void
     */
    public function postDelete(?ConnectionInterface $con = null): void
    {
            }


    /**
     * Derived method to catches calls to undefined methods.
     *
     * Provides magic import/export method support (fromXML()/toXML(), fromYAML()/toYAML(), etc.).
     * Allows to define default __call() behavior if you overwrite __call()
     *
     * @param string $name
     * @param mixed $params
     *
     * @return array|string
     */
    public function __call($name, $params)
    {
        if (0 === strpos($name, 'get')) {
            $virtualColumn = substr($name, 3);
            if ($this->hasVirtualColumn($virtualColumn)) {
                return $this->getVirtualColumn($virtualColumn);
            }

            $virtualColumn = lcfirst($virtualColumn);
            if ($this->hasVirtualColumn($virtualColumn)) {
                return $this->getVirtualColumn($virtualColumn);
            }
        }

        if (0 === strpos($name, 'from')) {
            $format = substr($name, 4);
            $inputData = $params[0];
            $keyType = $params[1] ?? TableMap::TYPE_PHPNAME;

            return $this->importFrom($format, $inputData, $keyType);
        }

        if (0 === strpos($name, 'to')) {
            $format = substr($name, 2);
            $includeLazyLoadColumns = $params[0] ?? true;
            $keyType = $params[1] ?? TableMap::TYPE_PHPNAME;

            return $this->exportTo($format, $includeLazyLoadColumns, $keyType);
        }

        throw new BadMethodCallException(sprintf('Call to undefined method: %s.', $name));
    }

}
