<?php

namespace Diamond\Infrastructure\Models\ImageSlider\Map;

use Diamond\Infrastructure\Models\ImageSlider\ImageSlider;
use Diamond\Infrastructure\Models\ImageSlider\ImageSliderQuery;
use Propel\Runtime\Propel;
use Propel\Runtime\ActiveQuery\Criteria;
use Propel\Runtime\ActiveQuery\InstancePoolTrait;
use Propel\Runtime\Connection\ConnectionInterface;
use Propel\Runtime\DataFetcher\DataFetcherInterface;
use Propel\Runtime\Exception\PropelException;
use Propel\Runtime\Map\RelationMap;
use Propel\Runtime\Map\TableMap;
use Propel\Runtime\Map\TableMapTrait;


/**
 * This class defines the structure of the '_slider_images' table.
 *
 *
 *
 * This map class is used by Propel to do runtime db structure discovery.
 * For example, the createSelectSql() method checks the type of a given column used in an
 * ORDER BY clause to know whether it needs to apply SQL to make the ORDER BY case-insensitive
 * (i.e. if it's a text column type).
 */
class ImageSliderTableMap extends TableMap
{
    use InstancePoolTrait;
    use TableMapTrait;

    /**
     * The (dot-path) name of this class
     */
    public const CLASS_NAME = 'Diamond.Infrastructure.Models.ImageSlider.Map.ImageSliderTableMap';

    /**
     * The default database name for this class
     */
    public const DATABASE_NAME = 'default';

    /**
     * The table name for this class
     */
    public const TABLE_NAME = '_slider_images';

    /**
     * The related Propel class for this table
     */
    public const OM_CLASS = '\\Diamond\\Infrastructure\\Models\\ImageSlider\\ImageSlider';

    /**
     * A class that can be returned by this tableMap
     */
    public const CLASS_DEFAULT = 'Diamond.Infrastructure.Models.ImageSlider.ImageSlider';

    /**
     * The total number of columns
     */
    public const NUM_COLUMNS = 8;

    /**
     * The number of lazy-loaded columns
     */
    public const NUM_LAZY_LOAD_COLUMNS = 0;

    /**
     * The number of columns to hydrate (NUM_COLUMNS - NUM_LAZY_LOAD_COLUMNS)
     */
    public const NUM_HYDRATE_COLUMNS = 8;

    /**
     * the column name for the id field
     */
    public const COL_ID = '_slider_images.id';

    /**
     * the column name for the code field
     */
    public const COL_CODE = '_slider_images.code';

    /**
     * the column name for the title field
     */
    public const COL_TITLE = '_slider_images.title';

    /**
     * the column name for the active field
     */
    public const COL_ACTIVE = '_slider_images.active';

    /**
     * the column name for the bigimage field
     */
    public const COL_BIGIMAGE = '_slider_images.bigimage';

    /**
     * the column name for the middleimage field
     */
    public const COL_MIDDLEIMAGE = '_slider_images.middleimage';

    /**
     * the column name for the link field
     */
    public const COL_LINK = '_slider_images.link';

    /**
     * the column name for the domain_id field
     */
    public const COL_DOMAIN_ID = '_slider_images.domain_id';

    /**
     * The default string format for model objects of the related table
     */
    public const DEFAULT_STRING_FORMAT = 'YAML';

    /**
     * holds an array of fieldnames
     *
     * first dimension keys are the type constants
     * e.g. self::$fieldNames[self::TYPE_PHPNAME][0] = 'Id'
     *
     * @var array<string, mixed>
     */
    protected static $fieldNames = [
        self::TYPE_PHPNAME       => ['Id', 'Code', 'Title', 'Active', 'BigImage', 'MiddleImage', 'Link', 'DomainId', ],
        self::TYPE_CAMELNAME     => ['id', 'code', 'title', 'active', 'bigImage', 'middleImage', 'link', 'domainId', ],
        self::TYPE_COLNAME       => [ImageSliderTableMap::COL_ID, ImageSliderTableMap::COL_CODE, ImageSliderTableMap::COL_TITLE, ImageSliderTableMap::COL_ACTIVE, ImageSliderTableMap::COL_BIGIMAGE, ImageSliderTableMap::COL_MIDDLEIMAGE, ImageSliderTableMap::COL_LINK, ImageSliderTableMap::COL_DOMAIN_ID, ],
        self::TYPE_FIELDNAME     => ['id', 'code', 'title', 'active', 'bigimage', 'middleimage', 'link', 'domain_id', ],
        self::TYPE_NUM           => [0, 1, 2, 3, 4, 5, 6, 7, ]
    ];

    /**
     * holds an array of keys for quick access to the fieldnames array
     *
     * first dimension keys are the type constants
     * e.g. self::$fieldKeys[self::TYPE_PHPNAME]['Id'] = 0
     *
     * @var array<string, mixed>
     */
    protected static $fieldKeys = [
        self::TYPE_PHPNAME       => ['Id' => 0, 'Code' => 1, 'Title' => 2, 'Active' => 3, 'BigImage' => 4, 'MiddleImage' => 5, 'Link' => 6, 'DomainId' => 7, ],
        self::TYPE_CAMELNAME     => ['id' => 0, 'code' => 1, 'title' => 2, 'active' => 3, 'bigImage' => 4, 'middleImage' => 5, 'link' => 6, 'domainId' => 7, ],
        self::TYPE_COLNAME       => [ImageSliderTableMap::COL_ID => 0, ImageSliderTableMap::COL_CODE => 1, ImageSliderTableMap::COL_TITLE => 2, ImageSliderTableMap::COL_ACTIVE => 3, ImageSliderTableMap::COL_BIGIMAGE => 4, ImageSliderTableMap::COL_MIDDLEIMAGE => 5, ImageSliderTableMap::COL_LINK => 6, ImageSliderTableMap::COL_DOMAIN_ID => 7, ],
        self::TYPE_FIELDNAME     => ['id' => 0, 'code' => 1, 'title' => 2, 'active' => 3, 'bigimage' => 4, 'middleimage' => 5, 'link' => 6, 'domain_id' => 7, ],
        self::TYPE_NUM           => [0, 1, 2, 3, 4, 5, 6, 7, ]
    ];

    /**
     * Holds a list of column names and their normalized version.
     *
     * @var array<string>
     */
    protected $normalizedColumnNameMap = [
        'Id' => 'ID',
        'ImageSlider.Id' => 'ID',
        'id' => 'ID',
        'imageSlider.id' => 'ID',
        'ImageSliderTableMap::COL_ID' => 'ID',
        'COL_ID' => 'ID',
        '_slider_images.id' => 'ID',
        'Code' => 'CODE',
        'ImageSlider.Code' => 'CODE',
        'code' => 'CODE',
        'imageSlider.code' => 'CODE',
        'ImageSliderTableMap::COL_CODE' => 'CODE',
        'COL_CODE' => 'CODE',
        '_slider_images.code' => 'CODE',
        'Title' => 'TITLE',
        'ImageSlider.Title' => 'TITLE',
        'title' => 'TITLE',
        'imageSlider.title' => 'TITLE',
        'ImageSliderTableMap::COL_TITLE' => 'TITLE',
        'COL_TITLE' => 'TITLE',
        '_slider_images.title' => 'TITLE',
        'Active' => 'ACTIVE',
        'ImageSlider.Active' => 'ACTIVE',
        'active' => 'ACTIVE',
        'imageSlider.active' => 'ACTIVE',
        'ImageSliderTableMap::COL_ACTIVE' => 'ACTIVE',
        'COL_ACTIVE' => 'ACTIVE',
        '_slider_images.active' => 'ACTIVE',
        'BigImage' => 'BIGIMAGE',
        'ImageSlider.BigImage' => 'BIGIMAGE',
        'bigImage' => 'BIGIMAGE',
        'imageSlider.bigImage' => 'BIGIMAGE',
        'ImageSliderTableMap::COL_BIGIMAGE' => 'BIGIMAGE',
        'COL_BIGIMAGE' => 'BIGIMAGE',
        'bigimage' => 'BIGIMAGE',
        '_slider_images.bigimage' => 'BIGIMAGE',
        'MiddleImage' => 'MIDDLEIMAGE',
        'ImageSlider.MiddleImage' => 'MIDDLEIMAGE',
        'middleImage' => 'MIDDLEIMAGE',
        'imageSlider.middleImage' => 'MIDDLEIMAGE',
        'ImageSliderTableMap::COL_MIDDLEIMAGE' => 'MIDDLEIMAGE',
        'COL_MIDDLEIMAGE' => 'MIDDLEIMAGE',
        'middleimage' => 'MIDDLEIMAGE',
        '_slider_images.middleimage' => 'MIDDLEIMAGE',
        'Link' => 'LINK',
        'ImageSlider.Link' => 'LINK',
        'link' => 'LINK',
        'imageSlider.link' => 'LINK',
        'ImageSliderTableMap::COL_LINK' => 'LINK',
        'COL_LINK' => 'LINK',
        '_slider_images.link' => 'LINK',
        'DomainId' => 'DOMAIN_ID',
        'ImageSlider.DomainId' => 'DOMAIN_ID',
        'domainId' => 'DOMAIN_ID',
        'imageSlider.domainId' => 'DOMAIN_ID',
        'ImageSliderTableMap::COL_DOMAIN_ID' => 'DOMAIN_ID',
        'COL_DOMAIN_ID' => 'DOMAIN_ID',
        'domain_id' => 'DOMAIN_ID',
        '_slider_images.domain_id' => 'DOMAIN_ID',
    ];

    /**
     * Initialize the table attributes and columns
     * Relations are not initialized by this method since they are lazy loaded
     *
     * @return void
     * @throws \Propel\Runtime\Exception\PropelException
     */
    public function initialize(): void
    {
        // attributes
        $this->setName('_slider_images');
        $this->setPhpName('ImageSlider');
        $this->setIdentifierQuoting(true);
        $this->setClassName('\\Diamond\\Infrastructure\\Models\\ImageSlider\\ImageSlider');
        $this->setPackage('Diamond.Infrastructure.Models.ImageSlider');
        $this->setUseIdGenerator(true);
        // columns
        $this->addPrimaryKey('id', 'Id', 'INTEGER', true, null, null);
        $this->addColumn('code', 'Code', 'VARCHAR', false, 100, null);
        $this->addColumn('title', 'Title', 'VARCHAR', false, 255, null);
        $this->addColumn('active', 'Active', 'TINYINT', true, null, 1);
        $this->addColumn('bigimage', 'BigImage', 'VARCHAR', false, 255, null);
        $this->addColumn('middleimage', 'MiddleImage', 'VARCHAR', false, 255, null);
        $this->addColumn('link', 'Link', 'VARCHAR', false, 255, null);
        $this->addForeignKey('domain_id', 'DomainId', 'INTEGER', '_domains', 'id', false, null, null);
    }

    /**
     * Build the RelationMap objects for this table relationships
     *
     * @return void
     */
    public function buildRelations(): void
    {
        $this->addRelation('Domain', '\\Diamond\\Infrastructure\\Models\\Domain\\Domain', RelationMap::MANY_TO_ONE, array (
  0 =>
  array (
    0 => ':domain_id',
    1 => ':id',
  ),
), null, null, null, false);
    }

    /**
     * Retrieves a string version of the primary key from the DB resultset row that can be used to uniquely identify a row in this table.
     *
     * For tables with a single-column primary key, that simple pkey value will be returned.  For tables with
     * a multi-column primary key, a serialize()d version of the primary key will be returned.
     *
     * @param array $row Resultset row.
     * @param int $offset The 0-based offset for reading from the resultset row.
     * @param string $indexType One of the class type constants TableMap::TYPE_PHPNAME, TableMap::TYPE_CAMELNAME
     *                           TableMap::TYPE_COLNAME, TableMap::TYPE_FIELDNAME, TableMap::TYPE_NUM
     *
     * @return string|null The primary key hash of the row
     */
    public static function getPrimaryKeyHashFromRow(array $row, int $offset = 0, string $indexType = TableMap::TYPE_NUM): ?string
    {
        // If the PK cannot be derived from the row, return NULL.
        if ($row[TableMap::TYPE_NUM == $indexType ? 0 + $offset : static::translateFieldName('Id', TableMap::TYPE_PHPNAME, $indexType)] === null) {
            return null;
        }

        return null === $row[TableMap::TYPE_NUM == $indexType ? 0 + $offset : static::translateFieldName('Id', TableMap::TYPE_PHPNAME, $indexType)] || is_scalar($row[TableMap::TYPE_NUM == $indexType ? 0 + $offset : static::translateFieldName('Id', TableMap::TYPE_PHPNAME, $indexType)]) || is_callable([$row[TableMap::TYPE_NUM == $indexType ? 0 + $offset : static::translateFieldName('Id', TableMap::TYPE_PHPNAME, $indexType)], '__toString']) ? (string) $row[TableMap::TYPE_NUM == $indexType ? 0 + $offset : static::translateFieldName('Id', TableMap::TYPE_PHPNAME, $indexType)] : $row[TableMap::TYPE_NUM == $indexType ? 0 + $offset : static::translateFieldName('Id', TableMap::TYPE_PHPNAME, $indexType)];
    }

    /**
     * Retrieves the primary key from the DB resultset row
     * For tables with a single-column primary key, that simple pkey value will be returned.  For tables with
     * a multi-column primary key, an array of the primary key columns will be returned.
     *
     * @param array $row Resultset row.
     * @param int $offset The 0-based offset for reading from the resultset row.
     * @param string $indexType One of the class type constants TableMap::TYPE_PHPNAME, TableMap::TYPE_CAMELNAME
     *                           TableMap::TYPE_COLNAME, TableMap::TYPE_FIELDNAME, TableMap::TYPE_NUM
     *
     * @return mixed The primary key of the row
     */
    public static function getPrimaryKeyFromRow(array $row, int $offset = 0, string $indexType = TableMap::TYPE_NUM)
    {
        return (int) $row[
            $indexType == TableMap::TYPE_NUM
                ? 0 + $offset
                : self::translateFieldName('Id', TableMap::TYPE_PHPNAME, $indexType)
        ];
    }

    /**
     * The class that the tableMap will make instances of.
     *
     * If $withPrefix is true, the returned path
     * uses a dot-path notation which is translated into a path
     * relative to a location on the PHP include_path.
     * (e.g. path.to.MyClass -> 'path/to/MyClass.php')
     *
     * @param bool $withPrefix Whether to return the path with the class name
     * @return string path.to.ClassName
     */
    public static function getOMClass(bool $withPrefix = true): string
    {
        return $withPrefix ? ImageSliderTableMap::CLASS_DEFAULT : ImageSliderTableMap::OM_CLASS;
    }

    /**
     * Populates an object of the default type or an object that inherit from the default.
     *
     * @param array $row Row returned by DataFetcher->fetch().
     * @param int $offset The 0-based offset for reading from the resultset row.
     * @param string $indexType The index type of $row. Mostly DataFetcher->getIndexType().
                                 One of the class type constants TableMap::TYPE_PHPNAME, TableMap::TYPE_CAMELNAME
     *                           TableMap::TYPE_COLNAME, TableMap::TYPE_FIELDNAME, TableMap::TYPE_NUM.
     *
     * @throws \Propel\Runtime\Exception\PropelException Any exceptions caught during processing will be
     *                         rethrown wrapped into a PropelException.
     * @return array (ImageSlider object, last column rank)
     */
    public static function populateObject(array $row, int $offset = 0, string $indexType = TableMap::TYPE_NUM): array
    {
        $key = ImageSliderTableMap::getPrimaryKeyHashFromRow($row, $offset, $indexType);
        if (null !== ($obj = ImageSliderTableMap::getInstanceFromPool($key))) {
            // We no longer rehydrate the object, since this can cause data loss.
            // See http://www.propelorm.org/ticket/509
            // $obj->hydrate($row, $offset, true); // rehydrate
            $col = $offset + ImageSliderTableMap::NUM_HYDRATE_COLUMNS;
        } else {
            $cls = ImageSliderTableMap::OM_CLASS;
            /** @var ImageSlider $obj */
            $obj = new $cls();
            $col = $obj->hydrate($row, $offset, false, $indexType);
            ImageSliderTableMap::addInstanceToPool($obj, $key);
        }

        return array($obj, $col);
    }

    /**
     * The returned array will contain objects of the default type or
     * objects that inherit from the default.
     *
     * @param DataFetcherInterface $dataFetcher
     * @return array<object>
     * @throws \Propel\Runtime\Exception\PropelException Any exceptions caught during processing will be
     *                         rethrown wrapped into a PropelException.
     */
    public static function populateObjects(DataFetcherInterface $dataFetcher): array
    {
        $results = [];

        // set the class once to avoid overhead in the loop
        $cls = static::getOMClass(false);
        // populate the object(s)
        while ($row = $dataFetcher->fetch()) {
            $key = ImageSliderTableMap::getPrimaryKeyHashFromRow($row, 0, $dataFetcher->getIndexType());
            if (null !== ($obj = ImageSliderTableMap::getInstanceFromPool($key))) {
                // We no longer rehydrate the object, since this can cause data loss.
                // See http://www.propelorm.org/ticket/509
                // $obj->hydrate($row, 0, true); // rehydrate
                $results[] = $obj;
            } else {
                /** @var ImageSlider $obj */
                $obj = new $cls();
                $obj->hydrate($row);
                $results[] = $obj;
                ImageSliderTableMap::addInstanceToPool($obj, $key);
            } // if key exists
        }

        return $results;
    }
    /**
     * Add all the columns needed to create a new object.
     *
     * Note: any columns that were marked with lazyLoad="true" in the
     * XML schema will not be added to the select list and only loaded
     * on demand.
     *
     * @param Criteria $criteria Object containing the columns to add.
     * @param string|null $alias Optional table alias
     * @throws \Propel\Runtime\Exception\PropelException Any exceptions caught during processing will be
     *                         rethrown wrapped into a PropelException.
     * @return void
     */
    public static function addSelectColumns(Criteria $criteria, ?string $alias = null): void
    {
        if (null === $alias) {
            $criteria->addSelectColumn(ImageSliderTableMap::COL_ID);
            $criteria->addSelectColumn(ImageSliderTableMap::COL_CODE);
            $criteria->addSelectColumn(ImageSliderTableMap::COL_TITLE);
            $criteria->addSelectColumn(ImageSliderTableMap::COL_ACTIVE);
            $criteria->addSelectColumn(ImageSliderTableMap::COL_BIGIMAGE);
            $criteria->addSelectColumn(ImageSliderTableMap::COL_MIDDLEIMAGE);
            $criteria->addSelectColumn(ImageSliderTableMap::COL_LINK);
            $criteria->addSelectColumn(ImageSliderTableMap::COL_DOMAIN_ID);
        } else {
            $criteria->addSelectColumn($alias . '.id');
            $criteria->addSelectColumn($alias . '.code');
            $criteria->addSelectColumn($alias . '.title');
            $criteria->addSelectColumn($alias . '.active');
            $criteria->addSelectColumn($alias . '.bigimage');
            $criteria->addSelectColumn($alias . '.middleimage');
            $criteria->addSelectColumn($alias . '.link');
            $criteria->addSelectColumn($alias . '.domain_id');
        }
    }

    /**
     * Remove all the columns needed to create a new object.
     *
     * Note: any columns that were marked with lazyLoad="true" in the
     * XML schema will not be removed as they are only loaded on demand.
     *
     * @param Criteria $criteria Object containing the columns to remove.
     * @param string|null $alias Optional table alias
     * @throws \Propel\Runtime\Exception\PropelException Any exceptions caught during processing will be
     *                         rethrown wrapped into a PropelException.
     * @return void
     */
    public static function removeSelectColumns(Criteria $criteria, ?string $alias = null): void
    {
        if (null === $alias) {
            $criteria->removeSelectColumn(ImageSliderTableMap::COL_ID);
            $criteria->removeSelectColumn(ImageSliderTableMap::COL_CODE);
            $criteria->removeSelectColumn(ImageSliderTableMap::COL_TITLE);
            $criteria->removeSelectColumn(ImageSliderTableMap::COL_ACTIVE);
            $criteria->removeSelectColumn(ImageSliderTableMap::COL_BIGIMAGE);
            $criteria->removeSelectColumn(ImageSliderTableMap::COL_MIDDLEIMAGE);
            $criteria->removeSelectColumn(ImageSliderTableMap::COL_LINK);
            $criteria->removeSelectColumn(ImageSliderTableMap::COL_DOMAIN_ID);
        } else {
            $criteria->removeSelectColumn($alias . '.id');
            $criteria->removeSelectColumn($alias . '.code');
            $criteria->removeSelectColumn($alias . '.title');
            $criteria->removeSelectColumn($alias . '.active');
            $criteria->removeSelectColumn($alias . '.bigimage');
            $criteria->removeSelectColumn($alias . '.middleimage');
            $criteria->removeSelectColumn($alias . '.link');
            $criteria->removeSelectColumn($alias . '.domain_id');
        }
    }

    /**
     * Returns the TableMap related to this object.
     * This method is not needed for general use but a specific application could have a need.
     * @return TableMap
     * @throws \Propel\Runtime\Exception\PropelException Any exceptions caught during processing will be
     *                         rethrown wrapped into a PropelException.
     */
    public static function getTableMap(): TableMap
    {
        return Propel::getServiceContainer()->getDatabaseMap(ImageSliderTableMap::DATABASE_NAME)->getTable(ImageSliderTableMap::TABLE_NAME);
    }

    /**
     * Performs a DELETE on the database, given a ImageSlider or Criteria object OR a primary key value.
     *
     * @param mixed $values Criteria or ImageSlider object or primary key or array of primary keys
     *              which is used to create the DELETE statement
     * @param ConnectionInterface $con the connection to use
     * @return int The number of affected rows (if supported by underlying database driver).  This includes CASCADE-related rows
     *                         if supported by native driver or if emulated using Propel.
     * @throws \Propel\Runtime\Exception\PropelException Any exceptions caught during processing will be
     *                         rethrown wrapped into a PropelException.
     */
     public static function doDelete($values, ?ConnectionInterface $con = null): int
     {
        if (null === $con) {
            $con = Propel::getServiceContainer()->getWriteConnection(ImageSliderTableMap::DATABASE_NAME);
        }

        if ($values instanceof Criteria) {
            // rename for clarity
            $criteria = $values;
        } elseif ($values instanceof \Diamond\Infrastructure\Models\ImageSlider\ImageSlider) { // it's a model object
            // create criteria based on pk values
            $criteria = $values->buildPkeyCriteria();
        } else { // it's a primary key, or an array of pks
            $criteria = new Criteria(ImageSliderTableMap::DATABASE_NAME);
            $criteria->add(ImageSliderTableMap::COL_ID, (array) $values, Criteria::IN);
        }

        $query = ImageSliderQuery::create()->mergeWith($criteria);

        if ($values instanceof Criteria) {
            ImageSliderTableMap::clearInstancePool();
        } elseif (!is_object($values)) { // it's a primary key, or an array of pks
            foreach ((array) $values as $singleval) {
                ImageSliderTableMap::removeInstanceFromPool($singleval);
            }
        }

        return $query->delete($con);
    }

    /**
     * Deletes all rows from the _slider_images table.
     *
     * @param ConnectionInterface $con the connection to use
     * @return int The number of affected rows (if supported by underlying database driver).
     */
    public static function doDeleteAll(?ConnectionInterface $con = null): int
    {
        return ImageSliderQuery::create()->doDeleteAll($con);
    }

    /**
     * Performs an INSERT on the database, given a ImageSlider or Criteria object.
     *
     * @param mixed $criteria Criteria or ImageSlider object containing data that is used to create the INSERT statement.
     * @param ConnectionInterface $con the ConnectionInterface connection to use
     * @return mixed The new primary key.
     * @throws \Propel\Runtime\Exception\PropelException Any exceptions caught during processing will be
     *                         rethrown wrapped into a PropelException.
     */
    public static function doInsert($criteria, ?ConnectionInterface $con = null)
    {
        if (null === $con) {
            $con = Propel::getServiceContainer()->getWriteConnection(ImageSliderTableMap::DATABASE_NAME);
        }

        if ($criteria instanceof Criteria) {
            $criteria = clone $criteria; // rename for clarity
        } else {
            $criteria = $criteria->buildCriteria(); // build Criteria from ImageSlider object
        }

        if ($criteria->containsKey(ImageSliderTableMap::COL_ID) && $criteria->keyContainsValue(ImageSliderTableMap::COL_ID) ) {
            throw new PropelException('Cannot insert a value for auto-increment primary key ('.ImageSliderTableMap::COL_ID.')');
        }


        // Set the correct dbName
        $query = ImageSliderQuery::create()->mergeWith($criteria);

        // use transaction because $criteria could contain info
        // for more than one table (I guess, conceivably)
        return $con->transaction(function () use ($con, $query) {
            return $query->doInsert($con);
        });
    }

}
