<?php

namespace Diamond\Infrastructure\Models\AccessRule\Map;

use Diamond\Infrastructure\Models\AccessRule\AccessRule;
use Diamond\Infrastructure\Models\AccessRule\AccessRuleQuery;
use Propel\Runtime\Propel;
use Propel\Runtime\ActiveQuery\Criteria;
use Propel\Runtime\ActiveQuery\InstancePoolTrait;
use Propel\Runtime\Connection\ConnectionInterface;
use Propel\Runtime\DataFetcher\DataFetcherInterface;
use Propel\Runtime\Exception\PropelException;
use Propel\Runtime\Map\RelationMap;
use Propel\Runtime\Map\TableMap;
use Propel\Runtime\Map\TableMapTrait;


/**
 * This class defines the structure of the '_access_rules' table.
 *
 *
 *
 * This map class is used by Propel to do runtime db structure discovery.
 * For example, the createSelectSql() method checks the type of a given column used in an
 * ORDER BY clause to know whether it needs to apply SQL to make the ORDER BY case-insensitive
 * (i.e. if it's a text column type).
 */
class AccessRuleTableMap extends TableMap
{
    use InstancePoolTrait;
    use TableMapTrait;

    /**
     * The (dot-path) name of this class
     */
    public const CLASS_NAME = 'Diamond.Infrastructure.Models.AccessRule.Map.AccessRuleTableMap';

    /**
     * The default database name for this class
     */
    public const DATABASE_NAME = 'default';

    /**
     * The table name for this class
     */
    public const TABLE_NAME = '_access_rules';

    /**
     * The related Propel class for this table
     */
    public const OM_CLASS = '\\Diamond\\Infrastructure\\Models\\AccessRule\\AccessRule';

    /**
     * A class that can be returned by this tableMap
     */
    public const CLASS_DEFAULT = 'Diamond.Infrastructure.Models.AccessRule.AccessRule';

    /**
     * The total number of columns
     */
    public const NUM_COLUMNS = 6;

    /**
     * The number of lazy-loaded columns
     */
    public const NUM_LAZY_LOAD_COLUMNS = 0;

    /**
     * The number of columns to hydrate (NUM_COLUMNS - NUM_LAZY_LOAD_COLUMNS)
     */
    public const NUM_HYDRATE_COLUMNS = 6;

    /**
     * the column name for the id field
     */
    public const COL_ID = '_access_rules.id';

    /**
     * the column name for the object field
     */
    public const COL_OBJECT = '_access_rules.object';

    /**
     * the column name for the object_name field
     */
    public const COL_OBJECT_NAME = '_access_rules.object_name';

    /**
     * the column name for the read field
     */
    public const COL_READ = '_access_rules.read';

    /**
     * the column name for the create field
     */
    public const COL_CREATE = '_access_rules.create';

    /**
     * the column name for the update field
     */
    public const COL_UPDATE = '_access_rules.update';

    /**
     * The default string format for model objects of the related table
     */
    public const DEFAULT_STRING_FORMAT = 'YAML';

    /**
     * holds an array of fieldnames
     *
     * first dimension keys are the type constants
     * e.g. self::$fieldNames[self::TYPE_PHPNAME][0] = 'Id'
     *
     * @var array<string, mixed>
     */
    protected static $fieldNames = [
        self::TYPE_PHPNAME       => ['Id', 'Object', 'ObjectName', 'Read', 'Create', 'Update', ],
        self::TYPE_CAMELNAME     => ['id', 'object', 'objectName', 'read', 'create', 'update', ],
        self::TYPE_COLNAME       => [AccessRuleTableMap::COL_ID, AccessRuleTableMap::COL_OBJECT, AccessRuleTableMap::COL_OBJECT_NAME, AccessRuleTableMap::COL_READ, AccessRuleTableMap::COL_CREATE, AccessRuleTableMap::COL_UPDATE, ],
        self::TYPE_FIELDNAME     => ['id', 'object', 'object_name', 'read', 'create', 'update', ],
        self::TYPE_NUM           => [0, 1, 2, 3, 4, 5, ]
    ];

    /**
     * holds an array of keys for quick access to the fieldnames array
     *
     * first dimension keys are the type constants
     * e.g. self::$fieldKeys[self::TYPE_PHPNAME]['Id'] = 0
     *
     * @var array<string, mixed>
     */
    protected static $fieldKeys = [
        self::TYPE_PHPNAME       => ['Id' => 0, 'Object' => 1, 'ObjectName' => 2, 'Read' => 3, 'Create' => 4, 'Update' => 5, ],
        self::TYPE_CAMELNAME     => ['id' => 0, 'object' => 1, 'objectName' => 2, 'read' => 3, 'create' => 4, 'update' => 5, ],
        self::TYPE_COLNAME       => [AccessRuleTableMap::COL_ID => 0, AccessRuleTableMap::COL_OBJECT => 1, AccessRuleTableMap::COL_OBJECT_NAME => 2, AccessRuleTableMap::COL_READ => 3, AccessRuleTableMap::COL_CREATE => 4, AccessRuleTableMap::COL_UPDATE => 5, ],
        self::TYPE_FIELDNAME     => ['id' => 0, 'object' => 1, 'object_name' => 2, 'read' => 3, 'create' => 4, 'update' => 5, ],
        self::TYPE_NUM           => [0, 1, 2, 3, 4, 5, ]
    ];

    /**
     * Holds a list of column names and their normalized version.
     *
     * @var array<string>
     */
    protected $normalizedColumnNameMap = [
        'Id' => 'ID',
        'AccessRule.Id' => 'ID',
        'id' => 'ID',
        'accessRule.id' => 'ID',
        'AccessRuleTableMap::COL_ID' => 'ID',
        'COL_ID' => 'ID',
        '_access_rules.id' => 'ID',
        'Object' => 'OBJECT',
        'AccessRule.Object' => 'OBJECT',
        'object' => 'OBJECT',
        'accessRule.object' => 'OBJECT',
        'AccessRuleTableMap::COL_OBJECT' => 'OBJECT',
        'COL_OBJECT' => 'OBJECT',
        '_access_rules.object' => 'OBJECT',
        'ObjectName' => 'OBJECT_NAME',
        'AccessRule.ObjectName' => 'OBJECT_NAME',
        'objectName' => 'OBJECT_NAME',
        'accessRule.objectName' => 'OBJECT_NAME',
        'AccessRuleTableMap::COL_OBJECT_NAME' => 'OBJECT_NAME',
        'COL_OBJECT_NAME' => 'OBJECT_NAME',
        'object_name' => 'OBJECT_NAME',
        '_access_rules.object_name' => 'OBJECT_NAME',
        'Read' => 'READ',
        'AccessRule.Read' => 'READ',
        'read' => 'READ',
        'accessRule.read' => 'READ',
        'AccessRuleTableMap::COL_READ' => 'READ',
        'COL_READ' => 'READ',
        '_access_rules.read' => 'READ',
        'Create' => 'CREATE',
        'AccessRule.Create' => 'CREATE',
        'create' => 'CREATE',
        'accessRule.create' => 'CREATE',
        'AccessRuleTableMap::COL_CREATE' => 'CREATE',
        'COL_CREATE' => 'CREATE',
        '_access_rules.create' => 'CREATE',
        'Update' => 'UPDATE',
        'AccessRule.Update' => 'UPDATE',
        'update' => 'UPDATE',
        'accessRule.update' => 'UPDATE',
        'AccessRuleTableMap::COL_UPDATE' => 'UPDATE',
        'COL_UPDATE' => 'UPDATE',
        '_access_rules.update' => 'UPDATE',
    ];

    /**
     * Initialize the table attributes and columns
     * Relations are not initialized by this method since they are lazy loaded
     *
     * @return void
     * @throws \Propel\Runtime\Exception\PropelException
     */
    public function initialize(): void
    {
        // attributes
        $this->setName('_access_rules');
        $this->setPhpName('AccessRule');
        $this->setIdentifierQuoting(true);
        $this->setClassName('\\Diamond\\Infrastructure\\Models\\AccessRule\\AccessRule');
        $this->setPackage('Diamond.Infrastructure.Models.AccessRule');
        $this->setUseIdGenerator(true);
        // columns
        $this->addPrimaryKey('id', 'Id', 'INTEGER', true, null, null);
        $this->addColumn('object', 'Object', 'VARCHAR', true, 50, null);
        $this->addColumn('object_name', 'ObjectName', 'VARCHAR', true, 120, '%');
        $this->addColumn('read', 'Read', 'CHAR', true, null, 'N');
        $this->addColumn('create', 'Create', 'CHAR', true, null, 'N');
        $this->addColumn('update', 'Update', 'CHAR', true, null, 'N');
    }

    /**
     * Build the RelationMap objects for this table relationships
     *
     * @return void
     */
    public function buildRelations(): void
    {
    }

    /**
     *
     * Gets the list of behaviors registered for this table
     *
     * @return array<string, array> Associative array (name => parameters) of behaviors
     */
    public function getBehaviors(): array
    {
        return [
            'archivable' => ['archive_table' => '', 'archive_phpname' => NULL, 'archive_class' => '', 'log_archived_at' => 'true', 'archived_at_column' => 'archived_at', 'archive_on_insert' => 'false', 'archive_on_update' => 'false', 'archive_on_delete' => 'true'],
        ];
    }

    /**
     * Retrieves a string version of the primary key from the DB resultset row that can be used to uniquely identify a row in this table.
     *
     * For tables with a single-column primary key, that simple pkey value will be returned.  For tables with
     * a multi-column primary key, a serialize()d version of the primary key will be returned.
     *
     * @param array $row Resultset row.
     * @param int $offset The 0-based offset for reading from the resultset row.
     * @param string $indexType One of the class type constants TableMap::TYPE_PHPNAME, TableMap::TYPE_CAMELNAME
     *                           TableMap::TYPE_COLNAME, TableMap::TYPE_FIELDNAME, TableMap::TYPE_NUM
     *
     * @return string|null The primary key hash of the row
     */
    public static function getPrimaryKeyHashFromRow(array $row, int $offset = 0, string $indexType = TableMap::TYPE_NUM): ?string
    {
        // If the PK cannot be derived from the row, return NULL.
        if ($row[TableMap::TYPE_NUM == $indexType ? 0 + $offset : static::translateFieldName('Id', TableMap::TYPE_PHPNAME, $indexType)] === null) {
            return null;
        }

        return null === $row[TableMap::TYPE_NUM == $indexType ? 0 + $offset : static::translateFieldName('Id', TableMap::TYPE_PHPNAME, $indexType)] || is_scalar($row[TableMap::TYPE_NUM == $indexType ? 0 + $offset : static::translateFieldName('Id', TableMap::TYPE_PHPNAME, $indexType)]) || is_callable([$row[TableMap::TYPE_NUM == $indexType ? 0 + $offset : static::translateFieldName('Id', TableMap::TYPE_PHPNAME, $indexType)], '__toString']) ? (string) $row[TableMap::TYPE_NUM == $indexType ? 0 + $offset : static::translateFieldName('Id', TableMap::TYPE_PHPNAME, $indexType)] : $row[TableMap::TYPE_NUM == $indexType ? 0 + $offset : static::translateFieldName('Id', TableMap::TYPE_PHPNAME, $indexType)];
    }

    /**
     * Retrieves the primary key from the DB resultset row
     * For tables with a single-column primary key, that simple pkey value will be returned.  For tables with
     * a multi-column primary key, an array of the primary key columns will be returned.
     *
     * @param array $row Resultset row.
     * @param int $offset The 0-based offset for reading from the resultset row.
     * @param string $indexType One of the class type constants TableMap::TYPE_PHPNAME, TableMap::TYPE_CAMELNAME
     *                           TableMap::TYPE_COLNAME, TableMap::TYPE_FIELDNAME, TableMap::TYPE_NUM
     *
     * @return mixed The primary key of the row
     */
    public static function getPrimaryKeyFromRow(array $row, int $offset = 0, string $indexType = TableMap::TYPE_NUM)
    {
        return (int) $row[
            $indexType == TableMap::TYPE_NUM
                ? 0 + $offset
                : self::translateFieldName('Id', TableMap::TYPE_PHPNAME, $indexType)
        ];
    }

    /**
     * The class that the tableMap will make instances of.
     *
     * If $withPrefix is true, the returned path
     * uses a dot-path notation which is translated into a path
     * relative to a location on the PHP include_path.
     * (e.g. path.to.MyClass -> 'path/to/MyClass.php')
     *
     * @param bool $withPrefix Whether to return the path with the class name
     * @return string path.to.ClassName
     */
    public static function getOMClass(bool $withPrefix = true): string
    {
        return $withPrefix ? AccessRuleTableMap::CLASS_DEFAULT : AccessRuleTableMap::OM_CLASS;
    }

    /**
     * Populates an object of the default type or an object that inherit from the default.
     *
     * @param array $row Row returned by DataFetcher->fetch().
     * @param int $offset The 0-based offset for reading from the resultset row.
     * @param string $indexType The index type of $row. Mostly DataFetcher->getIndexType().
                                 One of the class type constants TableMap::TYPE_PHPNAME, TableMap::TYPE_CAMELNAME
     *                           TableMap::TYPE_COLNAME, TableMap::TYPE_FIELDNAME, TableMap::TYPE_NUM.
     *
     * @throws \Propel\Runtime\Exception\PropelException Any exceptions caught during processing will be
     *                         rethrown wrapped into a PropelException.
     * @return array (AccessRule object, last column rank)
     */
    public static function populateObject(array $row, int $offset = 0, string $indexType = TableMap::TYPE_NUM): array
    {
        $key = AccessRuleTableMap::getPrimaryKeyHashFromRow($row, $offset, $indexType);
        if (null !== ($obj = AccessRuleTableMap::getInstanceFromPool($key))) {
            // We no longer rehydrate the object, since this can cause data loss.
            // See http://www.propelorm.org/ticket/509
            // $obj->hydrate($row, $offset, true); // rehydrate
            $col = $offset + AccessRuleTableMap::NUM_HYDRATE_COLUMNS;
        } else {
            $cls = AccessRuleTableMap::OM_CLASS;
            /** @var AccessRule $obj */
            $obj = new $cls();
            $col = $obj->hydrate($row, $offset, false, $indexType);
            AccessRuleTableMap::addInstanceToPool($obj, $key);
        }

        return array($obj, $col);
    }

    /**
     * The returned array will contain objects of the default type or
     * objects that inherit from the default.
     *
     * @param DataFetcherInterface $dataFetcher
     * @return array<object>
     * @throws \Propel\Runtime\Exception\PropelException Any exceptions caught during processing will be
     *                         rethrown wrapped into a PropelException.
     */
    public static function populateObjects(DataFetcherInterface $dataFetcher): array
    {
        $results = [];

        // set the class once to avoid overhead in the loop
        $cls = static::getOMClass(false);
        // populate the object(s)
        while ($row = $dataFetcher->fetch()) {
            $key = AccessRuleTableMap::getPrimaryKeyHashFromRow($row, 0, $dataFetcher->getIndexType());
            if (null !== ($obj = AccessRuleTableMap::getInstanceFromPool($key))) {
                // We no longer rehydrate the object, since this can cause data loss.
                // See http://www.propelorm.org/ticket/509
                // $obj->hydrate($row, 0, true); // rehydrate
                $results[] = $obj;
            } else {
                /** @var AccessRule $obj */
                $obj = new $cls();
                $obj->hydrate($row);
                $results[] = $obj;
                AccessRuleTableMap::addInstanceToPool($obj, $key);
            } // if key exists
        }

        return $results;
    }
    /**
     * Add all the columns needed to create a new object.
     *
     * Note: any columns that were marked with lazyLoad="true" in the
     * XML schema will not be added to the select list and only loaded
     * on demand.
     *
     * @param Criteria $criteria Object containing the columns to add.
     * @param string|null $alias Optional table alias
     * @throws \Propel\Runtime\Exception\PropelException Any exceptions caught during processing will be
     *                         rethrown wrapped into a PropelException.
     * @return void
     */
    public static function addSelectColumns(Criteria $criteria, ?string $alias = null): void
    {
        if (null === $alias) {
            $criteria->addSelectColumn(AccessRuleTableMap::COL_ID);
            $criteria->addSelectColumn(AccessRuleTableMap::COL_OBJECT);
            $criteria->addSelectColumn(AccessRuleTableMap::COL_OBJECT_NAME);
            $criteria->addSelectColumn(AccessRuleTableMap::COL_READ);
            $criteria->addSelectColumn(AccessRuleTableMap::COL_CREATE);
            $criteria->addSelectColumn(AccessRuleTableMap::COL_UPDATE);
        } else {
            $criteria->addSelectColumn($alias . '.id');
            $criteria->addSelectColumn($alias . '.object');
            $criteria->addSelectColumn($alias . '.object_name');
            $criteria->addSelectColumn($alias . '.read');
            $criteria->addSelectColumn($alias . '.create');
            $criteria->addSelectColumn($alias . '.update');
        }
    }

    /**
     * Remove all the columns needed to create a new object.
     *
     * Note: any columns that were marked with lazyLoad="true" in the
     * XML schema will not be removed as they are only loaded on demand.
     *
     * @param Criteria $criteria Object containing the columns to remove.
     * @param string|null $alias Optional table alias
     * @throws \Propel\Runtime\Exception\PropelException Any exceptions caught during processing will be
     *                         rethrown wrapped into a PropelException.
     * @return void
     */
    public static function removeSelectColumns(Criteria $criteria, ?string $alias = null): void
    {
        if (null === $alias) {
            $criteria->removeSelectColumn(AccessRuleTableMap::COL_ID);
            $criteria->removeSelectColumn(AccessRuleTableMap::COL_OBJECT);
            $criteria->removeSelectColumn(AccessRuleTableMap::COL_OBJECT_NAME);
            $criteria->removeSelectColumn(AccessRuleTableMap::COL_READ);
            $criteria->removeSelectColumn(AccessRuleTableMap::COL_CREATE);
            $criteria->removeSelectColumn(AccessRuleTableMap::COL_UPDATE);
        } else {
            $criteria->removeSelectColumn($alias . '.id');
            $criteria->removeSelectColumn($alias . '.object');
            $criteria->removeSelectColumn($alias . '.object_name');
            $criteria->removeSelectColumn($alias . '.read');
            $criteria->removeSelectColumn($alias . '.create');
            $criteria->removeSelectColumn($alias . '.update');
        }
    }

    /**
     * Returns the TableMap related to this object.
     * This method is not needed for general use but a specific application could have a need.
     * @return TableMap
     * @throws \Propel\Runtime\Exception\PropelException Any exceptions caught during processing will be
     *                         rethrown wrapped into a PropelException.
     */
    public static function getTableMap(): TableMap
    {
        return Propel::getServiceContainer()->getDatabaseMap(AccessRuleTableMap::DATABASE_NAME)->getTable(AccessRuleTableMap::TABLE_NAME);
    }

    /**
     * Performs a DELETE on the database, given a AccessRule or Criteria object OR a primary key value.
     *
     * @param mixed $values Criteria or AccessRule object or primary key or array of primary keys
     *              which is used to create the DELETE statement
     * @param ConnectionInterface $con the connection to use
     * @return int The number of affected rows (if supported by underlying database driver).  This includes CASCADE-related rows
     *                         if supported by native driver or if emulated using Propel.
     * @throws \Propel\Runtime\Exception\PropelException Any exceptions caught during processing will be
     *                         rethrown wrapped into a PropelException.
     */
     public static function doDelete($values, ?ConnectionInterface $con = null): int
     {
        if (null === $con) {
            $con = Propel::getServiceContainer()->getWriteConnection(AccessRuleTableMap::DATABASE_NAME);
        }

        if ($values instanceof Criteria) {
            // rename for clarity
            $criteria = $values;
        } elseif ($values instanceof \Diamond\Infrastructure\Models\AccessRule\AccessRule) { // it's a model object
            // create criteria based on pk values
            $criteria = $values->buildPkeyCriteria();
        } else { // it's a primary key, or an array of pks
            $criteria = new Criteria(AccessRuleTableMap::DATABASE_NAME);
            $criteria->add(AccessRuleTableMap::COL_ID, (array) $values, Criteria::IN);
        }

        $query = AccessRuleQuery::create()->mergeWith($criteria);

        if ($values instanceof Criteria) {
            AccessRuleTableMap::clearInstancePool();
        } elseif (!is_object($values)) { // it's a primary key, or an array of pks
            foreach ((array) $values as $singleval) {
                AccessRuleTableMap::removeInstanceFromPool($singleval);
            }
        }

        return $query->delete($con);
    }

    /**
     * Deletes all rows from the _access_rules table.
     *
     * @param ConnectionInterface $con the connection to use
     * @return int The number of affected rows (if supported by underlying database driver).
     */
    public static function doDeleteAll(?ConnectionInterface $con = null): int
    {
        return AccessRuleQuery::create()->doDeleteAll($con);
    }

    /**
     * Performs an INSERT on the database, given a AccessRule or Criteria object.
     *
     * @param mixed $criteria Criteria or AccessRule object containing data that is used to create the INSERT statement.
     * @param ConnectionInterface $con the ConnectionInterface connection to use
     * @return mixed The new primary key.
     * @throws \Propel\Runtime\Exception\PropelException Any exceptions caught during processing will be
     *                         rethrown wrapped into a PropelException.
     */
    public static function doInsert($criteria, ?ConnectionInterface $con = null)
    {
        if (null === $con) {
            $con = Propel::getServiceContainer()->getWriteConnection(AccessRuleTableMap::DATABASE_NAME);
        }

        if ($criteria instanceof Criteria) {
            $criteria = clone $criteria; // rename for clarity
        } else {
            $criteria = $criteria->buildCriteria(); // build Criteria from AccessRule object
        }

        if ($criteria->containsKey(AccessRuleTableMap::COL_ID) && $criteria->keyContainsValue(AccessRuleTableMap::COL_ID) ) {
            throw new PropelException('Cannot insert a value for auto-increment primary key ('.AccessRuleTableMap::COL_ID.')');
        }


        // Set the correct dbName
        $query = AccessRuleQuery::create()->mergeWith($criteria);

        // use transaction because $criteria could contain info
        // for more than one table (I guess, conceivably)
        return $con->transaction(function () use ($con, $query) {
            return $query->doInsert($con);
        });
    }

}
